/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.annotators.gui;

import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.item.GuiItemAnnotator;
import com.wynntils.handlers.item.ItemAnnotation;
import com.wynntils.models.items.items.gui.ArchetypeAbilitiesItem;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.type.CappedValue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1799;

public final class ArchetypeAbilitiesAnnotator
implements GuiItemAnnotator {
    private static final Pattern ARCHETYPE_NAME = Pattern.compile("^\u00a7#([a-f0-9]{8})\u00a7l[A-Za-z ]+ Archetype$");
    private static final Pattern ARCHETYPE_PATTERN = Pattern.compile("^\u00a7a\u2714 \u00a77Unlocked Abilities: \u00a7f(\\d+)\u00a77/(\\d+)$");

    @Override
    public ItemAnnotation getAnnotation(class_1799 itemStack, StyledText name) {
        Matcher nameMatcher = name.getMatcher(ARCHETYPE_NAME);
        if (!nameMatcher.matches()) {
            return null;
        }
        Matcher loreMatcher = LoreUtils.matchLoreLine(itemStack, 5, ARCHETYPE_PATTERN);
        if (!loreMatcher.matches()) {
            return null;
        }
        int count = Integer.parseInt(loreMatcher.group(1));
        int max = Integer.parseInt(loreMatcher.group(2));
        return new ArchetypeAbilitiesItem(new CappedValue(count, max));
    }
}

