/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.annotators.gui;

import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.item.GuiItemAnnotator;
import com.wynntils.handlers.item.ItemAnnotation;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.items.items.gui.CharacterItem;
import com.wynntils.utils.mc.LoreUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1799;

public class CharacterAnnotator
implements GuiItemAnnotator {
    private static final Pattern CHARACTER_MENU_NAME_PATTERN = Pattern.compile("[\udb00\udc0b-\udb00\udc46]\u00a76(\u00a7o)?(?<name>[A-Za-z0-9_ ]{1,20})");
    private static final Pattern CHARACTER_MENU_CLASS_PATTERN = Pattern.compile("\u00a76- \u00a77Class:(?: (?<gamemodes>\u00a7.[\ue027\ue083\ue026\ue029\ue028])+\u00a77)? \u00a7f(?<class>.+)");
    private static final Pattern CHARACTER_MENU_LEVEL_PATTERN = Pattern.compile("\u00a76- \u00a77Level: \u00a7f(?<level>\\d+)\u00a77 \u00a78\\(\\d+(?:\\.\\d+)?%\\)");

    @Override
    public ItemAnnotation getAnnotation(class_1799 itemStack, StyledText name) {
        Matcher matcher = StyledText.fromComponent(itemStack.method_7964()).getMatcher(CHARACTER_MENU_NAME_PATTERN);
        if (!matcher.matches()) {
            return null;
        }
        String className = matcher.group("name");
        int level = 0;
        ClassType classType = null;
        boolean reskinned = false;
        for (StyledText lore : LoreUtils.getLore(itemStack)) {
            Matcher levelMatcher;
            Matcher classMatcher = lore.getMatcher(CHARACTER_MENU_CLASS_PATTERN);
            if (classMatcher.matches()) {
                classType = ClassType.fromName(classMatcher.group("class"));
                reskinned = ClassType.isReskinned(classMatcher.group("class"));
            }
            if (!(levelMatcher = lore.getMatcher(CHARACTER_MENU_LEVEL_PATTERN)).matches()) continue;
            level = Integer.parseInt(levelMatcher.group(1));
        }
        if (classType == null || classType == ClassType.NONE) {
            return null;
        }
        return new CharacterItem(className, level, classType, reskinned);
    }
}

