/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.annotators.gui;

import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.item.GuiItemAnnotator;
import com.wynntils.handlers.item.ItemAnnotation;
import com.wynntils.models.items.items.gui.DailyRewardItem;
import com.wynntils.utils.mc.LoreUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1799;

public final class DailyRewardMultiplierAnnotator
implements GuiItemAnnotator {
    private static final StyledText DAILY_REWARD_NAME = StyledText.fromString("\u00a76\u00a7lDaily Reward");
    private static final Pattern STREAK_PATTERN = Pattern.compile("^\u00a7e\u2726 Streak Multiplier: \u00a7f(\\d+)x$");

    @Override
    public ItemAnnotation getAnnotation(class_1799 itemStack, StyledText name) {
        if (!name.equals(DAILY_REWARD_NAME)) {
            return null;
        }
        Matcher matcher = LoreUtils.matchLoreLine(itemStack, 3, STREAK_PATTERN);
        if (!matcher.matches()) {
            return null;
        }
        int count = Integer.parseInt(matcher.group(1));
        return new DailyRewardItem(count);
    }
}

