/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.annotators.gui;

import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.item.GuiItemAnnotator;
import com.wynntils.handlers.item.ItemAnnotation;
import com.wynntils.models.items.items.gui.GuildLogItem;
import com.wynntils.utils.mc.LoreUtils;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1799;
import net.minecraft.class_1802;

public class GuildLogAnnotator
implements GuiItemAnnotator {
    private static final Pattern LOG_NAME_PATTERN = Pattern.compile("\u00a73(\\d+) ((month|week|day|hour|minute|second)s?) ago \u00a78\\((?<month>\\d+)\\/(?<day>\\d+)\\/(?<year>\\d+) (?<hour>\\d+):(?<minute>\\d+) (AM|PM) (EST|EDT)\\)");
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("MM/dd/yy hh:mm a", Locale.ROOT);
    private static final ZoneId LOG_ZONE = ZoneId.of("America/New_York");

    @Override
    public ItemAnnotation getAnnotation(class_1799 itemStack, StyledText name) {
        if (itemStack.method_7909() != class_1802.field_8407) {
            return null;
        }
        Matcher matcher = name.getMatcher(LOG_NAME_PATTERN);
        if (matcher.matches()) {
            String month = matcher.group("month");
            String day = matcher.group("day");
            String year = matcher.group("year");
            String hour = matcher.group("hour");
            String minute = matcher.group("minute");
            String amPm = matcher.group(9);
            StringBuilder dateTimeStr = new StringBuilder(month).append("/").append(day).append("/").append(year).append(" ").append(hour).append(":").append(minute).append(" ").append(amPm);
            LocalDateTime localDateTime = LocalDateTime.parse(dateTimeStr, DATE_FORMATTER);
            ZonedDateTime estZonedDateTime = localDateTime.atZone(LOG_ZONE);
            LinkedList<StyledText> unpaddedLore = new LinkedList<StyledText>(LoreUtils.getLore(itemStack));
            unpaddedLore.removeFirst();
            unpaddedLore.removeLast();
            return new GuildLogItem(estZonedDateTime.toInstant(), unpaddedLore);
        }
        return null;
    }
}

