/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.annotators.gui;

import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.item.GuiItemAnnotator;
import com.wynntils.handlers.item.ItemAnnotation;
import com.wynntils.models.items.items.gui.TerritoryItem;
import com.wynntils.models.territories.type.GuildResource;
import com.wynntils.models.territories.type.TerritoryUpgrade;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.type.CappedValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1799;
import net.minecraft.class_1802;

public class TerritoryAnnotator
implements GuiItemAnnotator {
    private static final Pattern NAME_PATTERN = Pattern.compile("\u00a7.(?:\u00a7l)?(?:\\[\u00a7c\u00a7l!\u00a74\u00a7l\\] \u00a7f)?(?<name>[^\\(\\)]+)(?<hq> \\(HQ\\))?");
    private static final Pattern GENERATOR_PATTERN = Pattern.compile("\u00a7.(?:[\u24b7\u24b8\u24c0\u24bf] )?\\+([0-9]*) (Emeralds|Ore|Wood|Fish|Crops) per Hour");
    private static final Pattern STORAGE_PATTERN = Pattern.compile("\u00a7.((?<type>[\u24b7\u24b8\u24c0\u24bf]) )?(?<current>[0-9]+)\\/(?<max>[0-9]+) stored");
    private static final Pattern TREASURY_PATTERN = Pattern.compile("\u00a7d\u2726 Treasury Bonus: \u00a7f([\\d\\.]+)%");
    private static final Pattern ALERTS_PATTERN = Pattern.compile("\u00a7c- \u00a77(.+?)");
    private static final Pattern UPGRADES_PATTERN = Pattern.compile("\u00a7d- \u00a77(.+?)\u00a78 \\[Lv. (\\d+)]");
    private static final Pattern TERRITORY_ITEM_LAST_LINE_PATTERN = Pattern.compile("(\u00a77Left-Click to view territory)|(\u00a7aClick to Select)|(\u00a7cClick to Unselect)");

    @Override
    public ItemAnnotation getAnnotation(class_1799 itemStack, StyledText name) {
        Matcher matcher = name.getMatcher(NAME_PATTERN);
        if (!matcher.matches()) {
            return null;
        }
        LinkedList<StyledText> lore = LoreUtils.getLore(itemStack);
        if (lore.isEmpty() || !((StyledText)lore.getLast()).matches(TERRITORY_ITEM_LAST_LINE_PATTERN)) {
            return null;
        }
        String territoryName = matcher.group("name");
        boolean isHeadquarters = matcher.group("hq") != null;
        boolean isSelected = itemStack.method_7909().equals(class_1802.field_8322) && itemStack.method_7919() == 20;
        EnumMap<GuildResource, Integer> generation = new EnumMap<GuildResource, Integer>(GuildResource.class);
        EnumMap<GuildResource, CappedValue> storage = new EnumMap<GuildResource, CappedValue>(GuildResource.class);
        float treasuryBonus = -1.0f;
        ArrayList<String> alerts = new ArrayList<String>();
        EnumMap<TerritoryUpgrade, Integer> upgrades = new EnumMap<TerritoryUpgrade, Integer>(TerritoryUpgrade.class);
        for (StyledText styledText : lore) {
            Matcher generatorMatcher = styledText.getMatcher(GENERATOR_PATTERN);
            if (generatorMatcher.matches()) {
                int amount = Integer.parseInt(generatorMatcher.group(1));
                GuildResource resource = GuildResource.fromName(generatorMatcher.group(2));
                generation.put(resource, amount);
                continue;
            }
            Matcher storageMatcher = styledText.getMatcher(STORAGE_PATTERN);
            if (storageMatcher.matches()) {
                int amount = Integer.parseInt(storageMatcher.group("current"));
                int max = Integer.parseInt(storageMatcher.group("max"));
                String type = storageMatcher.group("type");
                GuildResource resource = type == null ? GuildResource.EMERALDS : GuildResource.fromSymbol(type);
                storage.put(resource, new CappedValue(amount, max));
                continue;
            }
            Matcher treasuryMatcher = styledText.getMatcher(TREASURY_PATTERN);
            if (treasuryMatcher.matches()) {
                treasuryBonus = Float.parseFloat(treasuryMatcher.group(1));
                continue;
            }
            Matcher alertsMatcher = styledText.getMatcher(ALERTS_PATTERN);
            if (alertsMatcher.matches()) {
                alerts.add(alertsMatcher.group(1));
                continue;
            }
            Matcher upgradesMatcher = styledText.getMatcher(UPGRADES_PATTERN);
            if (!upgradesMatcher.matches()) continue;
            TerritoryUpgrade upgrade = TerritoryUpgrade.fromName(upgradesMatcher.group(1));
            int level = Integer.parseInt(upgradesMatcher.group(2));
            upgrades.put(upgrade, level);
        }
        return new TerritoryItem(territoryName, isHeadquarters, isSelected, Collections.unmodifiableMap(generation), Collections.unmodifiableMap(storage), treasuryBonus, Collections.unmodifiableList(alerts), upgrades);
    }
}

