/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.encoding.impl.block;

import com.wynntils.models.gear.type.GearType;
import com.wynntils.models.items.encoding.data.CustomGearTypeData;
import com.wynntils.models.items.encoding.type.DataTransformer;
import com.wynntils.models.items.encoding.type.DataTransformerType;
import com.wynntils.models.items.encoding.type.ItemTransformingVersion;
import com.wynntils.utils.type.ArrayReader;
import com.wynntils.utils.type.ErrorOr;
import com.wynntils.utils.type.UnsignedByte;

public class CustomGearTypeTransformer
extends DataTransformer<CustomGearTypeData> {
    @Override
    protected ErrorOr<UnsignedByte[]> encodeData(ItemTransformingVersion version, CustomGearTypeData data) {
        switch (version) {
            default: {
                throw new MatchException(null, null);
            }
            case VERSION_1: 
            case VERSION_2: 
        }
        return data.gearType().getEncodingId() == -1 ? ErrorOr.error("Gear type cannot be encoded.") : ErrorOr.of(new UnsignedByte[]{new UnsignedByte((byte)data.gearType().getEncodingId())});
    }

    @Override
    public ErrorOr<CustomGearTypeData> decodeData(ItemTransformingVersion version, ArrayReader<UnsignedByte> byteReader) {
        switch (version) {
            default: {
                throw new MatchException(null, null);
            }
            case VERSION_1: 
            case VERSION_2: 
        }
        GearType gearType = GearType.fromEncodingId(byteReader.read().value());
        return gearType == null ? ErrorOr.error("Gear type cannot be decoded.") : ErrorOr.of(new CustomGearTypeData(gearType));
    }

    @Override
    public byte getId() {
        return DataTransformerType.CUSTOM_GEAR_TYPE_TRANSFORMER.getId();
    }
}

