/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.encoding.impl.block;

import com.wynntils.models.gear.type.GearAttackSpeed;
import com.wynntils.models.items.encoding.data.DamageData;
import com.wynntils.models.items.encoding.type.DataTransformer;
import com.wynntils.models.items.encoding.type.DataTransformerType;
import com.wynntils.models.items.encoding.type.ItemTransformingVersion;
import com.wynntils.models.stats.type.DamageType;
import com.wynntils.utils.UnsignedByteUtils;
import com.wynntils.utils.type.ArrayReader;
import com.wynntils.utils.type.ErrorOr;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.type.RangedValue;
import com.wynntils.utils.type.UnsignedByte;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class DamageDataTransformer
extends DataTransformer<DamageData> {
    @Override
    protected ErrorOr<UnsignedByte[]> encodeData(ItemTransformingVersion version, DamageData data) {
        switch (version) {
            default: {
                throw new MatchException(null, null);
            }
            case VERSION_1: 
            case VERSION_2: 
        }
        return this.encodeDamageData(data);
    }

    @Override
    public ErrorOr<DamageData> decodeData(ItemTransformingVersion version, ArrayReader<UnsignedByte> byteReader) {
        switch (version) {
            default: {
                throw new MatchException(null, null);
            }
            case VERSION_1: 
            case VERSION_2: 
        }
        return this.decodeDamageData(byteReader);
    }

    @Override
    public byte getId() {
        return DataTransformerType.DAMAGE_DATA_TRANSFORMER.getId();
    }

    @Override
    protected boolean shouldEncodeData(ItemTransformingVersion version, DamageData data) {
        return !data.damages().isEmpty() || data.attackSpeed().isPresent();
    }

    private ErrorOr<UnsignedByte[]> encodeDamageData(DamageData data) {
        ArrayList<UnsignedByte> bytes = new ArrayList<UnsignedByte>();
        if (data.attackSpeed().isEmpty()) {
            return ErrorOr.error("Attack speed is not present, but damage data is present.");
        }
        bytes.add(UnsignedByte.of((byte)data.attackSpeed().get().getEncodingId()));
        bytes.add(UnsignedByte.of((byte)data.damages().size()));
        for (Pair<DamageType, RangedValue> damage : data.damages()) {
            DamageType damageType = damage.a();
            if (damageType != DamageType.NEUTRAL && damageType.getElement().isEmpty()) {
                return ErrorOr.error("Damage type " + String.valueOf((Object)damageType) + " does not have an element");
            }
            byte damageTypeId = (byte)damageType.getEncodingId();
            bytes.add(UnsignedByte.of(damageTypeId));
            UnsignedByte[] unsignedBytes = UnsignedByteUtils.encodeVariableSizedInteger(damage.b().low());
            bytes.addAll(List.of(unsignedBytes));
            unsignedBytes = UnsignedByteUtils.encodeVariableSizedInteger(damage.b().high());
            bytes.addAll(List.of(unsignedBytes));
        }
        return ErrorOr.of(bytes.toArray(new UnsignedByte[0]));
    }

    private ErrorOr<DamageData> decodeDamageData(ArrayReader<UnsignedByte> byteReader) {
        short attackSpeedId = byteReader.read().value();
        GearAttackSpeed attackSpeed = GearAttackSpeed.fromEncodingId(attackSpeedId);
        if (attackSpeed == null) {
            return ErrorOr.error("Invalid attack speed encoding: " + attackSpeedId);
        }
        int damageCount = byteReader.read().value();
        ArrayList<Pair<DamageType, RangedValue>> damages = new ArrayList<Pair<DamageType, RangedValue>>();
        for (int i = 0; i < damageCount; ++i) {
            short damageTypeId = byteReader.read().value();
            DamageType damageType = DamageType.fromEncodingId(damageTypeId);
            if (damageType == null) {
                return ErrorOr.error("Invalid damage type encoding: " + damageTypeId);
            }
            int minDamage = (int)UnsignedByteUtils.decodeVariableSizedInteger(byteReader);
            int maxDamage = (int)UnsignedByteUtils.decodeVariableSizedInteger(byteReader);
            damages.add(new Pair<DamageType, RangedValue>(damageType, new RangedValue(minDamage, maxDamage)));
        }
        return ErrorOr.of(new DamageData(Optional.of(attackSpeed), damages));
    }
}

