/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.encoding.type;

import com.wynntils.models.items.encoding.type.ItemData;
import com.wynntils.models.items.encoding.type.ItemTransformingVersion;
import com.wynntils.utils.type.ArrayReader;
import com.wynntils.utils.type.ErrorOr;
import com.wynntils.utils.type.UnsignedByte;

public abstract class DataTransformer<T extends ItemData> {
    public final ErrorOr<UnsignedByte[]> encode(ItemTransformingVersion version, T data) {
        if (!this.shouldEncodeData(version, data)) {
            return ErrorOr.of(new UnsignedByte[0]);
        }
        ErrorOr<UnsignedByte[]> errorOrData = this.encodeData(version, data);
        if (errorOrData.hasError()) {
            return errorOrData;
        }
        UnsignedByte[] dataBytes = errorOrData.getValue();
        UnsignedByte[] bytes = new UnsignedByte[dataBytes.length + 1];
        bytes[0] = UnsignedByte.of(this.getId());
        System.arraycopy(dataBytes, 0, bytes, 1, dataBytes.length);
        return ErrorOr.of(bytes);
    }

    protected abstract ErrorOr<UnsignedByte[]> encodeData(ItemTransformingVersion var1, T var2);

    protected boolean shouldEncodeData(ItemTransformingVersion version, T data) {
        return true;
    }

    public abstract ErrorOr<T> decodeData(ItemTransformingVersion var1, ArrayReader<UnsignedByte> var2);

    public abstract byte getId();
}

