/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.items.game;

import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.elements.type.Powder;
import com.wynntils.models.gear.type.GearInfo;
import com.wynntils.models.gear.type.GearInstance;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.gear.type.GearType;
import com.wynntils.models.gear.type.SetInfo;
import com.wynntils.models.gear.type.SetInstance;
import com.wynntils.models.items.items.game.GameItem;
import com.wynntils.models.items.properties.ClassableItemProperty;
import com.wynntils.models.items.properties.GearTierItemProperty;
import com.wynntils.models.items.properties.GearTypeItemProperty;
import com.wynntils.models.items.properties.IdentifiableItemProperty;
import com.wynntils.models.items.properties.LeveledItemProperty;
import com.wynntils.models.items.properties.PowderedItemProperty;
import com.wynntils.models.items.properties.RequirementItemProperty;
import com.wynntils.models.items.properties.RerollableItemProperty;
import com.wynntils.models.items.properties.SetItemProperty;
import com.wynntils.models.items.properties.ShinyItemProperty;
import com.wynntils.models.stats.type.ShinyStat;
import com.wynntils.models.stats.type.StatActualValue;
import com.wynntils.models.stats.type.StatPossibleValues;
import com.wynntils.models.stats.type.StatType;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.type.RangedValue;
import java.util.List;
import java.util.Optional;

public class GearItem
extends GameItem
implements GearTierItemProperty,
GearTypeItemProperty,
LeveledItemProperty,
PowderedItemProperty,
RerollableItemProperty,
ShinyItemProperty,
IdentifiableItemProperty<GearInfo, GearInstance>,
ClassableItemProperty,
SetItemProperty,
RequirementItemProperty {
    private final GearInfo gearInfo;
    private final GearInstance gearInstance;

    public GearItem(GearInfo gearInfo, GearInstance gearInstance) {
        this.gearInfo = gearInfo;
        this.gearInstance = gearInstance;
    }

    @Override
    public GearInfo getItemInfo() {
        return this.gearInfo;
    }

    @Override
    public Optional<GearInstance> getItemInstance() {
        return Optional.ofNullable(this.gearInstance);
    }

    @Override
    public Optional<SetInfo> getSetInfo() {
        return this.gearInfo.setInfo();
    }

    @Override
    public Optional<SetInstance> getSetInstance() {
        return this.gearInstance.setInstance();
    }

    public boolean isUnidentified() {
        return this.gearInstance == null;
    }

    @Override
    public GearTier getGearTier() {
        return this.gearInfo.tier();
    }

    @Override
    public GearType getGearType() {
        return this.gearInfo.type();
    }

    @Override
    public int getLevel() {
        return this.gearInfo.requirements().level();
    }

    @Override
    public String getName() {
        return this.gearInfo.name();
    }

    @Override
    public ClassType getRequiredClass() {
        return this.gearInfo.requirements().classType().orElse(null);
    }

    @Override
    public List<StatType> getVariableStats() {
        return this.gearInfo.variableStats().stream().map(Pair::a).toList();
    }

    @Override
    public List<StatActualValue> getIdentifications() {
        if (this.gearInstance == null) {
            return List.of();
        }
        return this.gearInstance.identifications();
    }

    @Override
    public List<StatPossibleValues> getPossibleValues() {
        return this.gearInfo.variableStats().stream().map(Pair::b).toList();
    }

    @Override
    public RangedValue getIdentificationLevelRange() {
        return RangedValue.NONE;
    }

    @Override
    public boolean hasOverallValue() {
        return this.gearInstance != null && this.gearInstance.hasOverallValue();
    }

    @Override
    public boolean isPerfect() {
        return this.gearInstance != null && this.gearInstance.isPerfect();
    }

    @Override
    public boolean isDefective() {
        return this.gearInstance != null && this.gearInstance.isDefective();
    }

    @Override
    public float getOverallPercentage() {
        return this.gearInstance != null ? this.gearInstance.getOverallPercentage() : 0.0f;
    }

    @Override
    public int getPowderSlots() {
        return this.gearInfo.powderSlots();
    }

    @Override
    public List<Powder> getPowders() {
        return this.gearInstance != null ? this.gearInstance.powders() : List.of();
    }

    @Override
    public int getRerollCount() {
        return this.gearInstance != null ? this.gearInstance.rerolls() : 0;
    }

    @Override
    public Optional<ShinyStat> getShinyStat() {
        return this.gearInstance != null ? this.gearInstance.shinyStat() : Optional.empty();
    }

    @Override
    public boolean meetsActualRequirements() {
        return this.gearInstance != null && this.gearInstance.meetsRequirements();
    }

    @Override
    public String toString() {
        return "GearItem{gearInfo=" + String.valueOf(this.gearInfo) + ", gearInstance=" + String.valueOf(this.gearInstance) + "}";
    }
}

