/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.items.game;

import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.gear.type.GearType;
import com.wynntils.models.items.items.game.GameItem;
import com.wynntils.models.items.properties.GearTierItemProperty;
import com.wynntils.models.items.properties.GearTypeItemProperty;
import com.wynntils.models.items.properties.IdentifiableItemProperty;
import com.wynntils.models.items.properties.LeveledItemProperty;
import com.wynntils.models.items.properties.RerollableItemProperty;
import com.wynntils.models.rewards.type.TomeInfo;
import com.wynntils.models.rewards.type.TomeInstance;
import com.wynntils.models.stats.type.StatActualValue;
import com.wynntils.models.stats.type.StatPossibleValues;
import com.wynntils.models.stats.type.StatType;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.type.RangedValue;
import java.util.List;
import java.util.Optional;

public class TomeItem
extends GameItem
implements GearTierItemProperty,
GearTypeItemProperty,
RerollableItemProperty,
LeveledItemProperty,
IdentifiableItemProperty<TomeInfo, TomeInstance> {
    private final TomeInfo tomeInfo;
    private final TomeInstance tomeInstance;

    public TomeItem(TomeInfo tomeInfo, TomeInstance tomeInstance) {
        this.tomeInfo = tomeInfo;
        this.tomeInstance = tomeInstance;
    }

    @Override
    public GearType getGearType() {
        return GearType.MASTERY_TOME;
    }

    @Override
    public TomeInfo getItemInfo() {
        return this.tomeInfo;
    }

    @Override
    public Optional<TomeInstance> getItemInstance() {
        return Optional.ofNullable(this.tomeInstance);
    }

    @Override
    public int getRerollCount() {
        return this.tomeInstance != null ? this.tomeInstance.rerolls() : 0;
    }

    @Override
    public GearTier getGearTier() {
        return this.tomeInfo.tier();
    }

    @Override
    public String getName() {
        return this.tomeInfo.name();
    }

    @Override
    public ClassType getRequiredClass() {
        return null;
    }

    @Override
    public List<StatType> getVariableStats() {
        return this.tomeInfo.variableStats().stream().map(Pair::a).toList();
    }

    @Override
    public int getLevel() {
        return this.tomeInfo.requirements().level();
    }

    @Override
    public List<StatActualValue> getIdentifications() {
        if (this.tomeInstance == null) {
            return List.of();
        }
        return this.tomeInstance.identifications();
    }

    @Override
    public List<StatPossibleValues> getPossibleValues() {
        return this.tomeInfo.variableStats().stream().map(Pair::b).toList();
    }

    @Override
    public RangedValue getIdentificationLevelRange() {
        return RangedValue.NONE;
    }

    @Override
    public boolean hasOverallValue() {
        return this.tomeInstance != null && this.tomeInstance.hasOverallValue();
    }

    @Override
    public boolean isPerfect() {
        return this.tomeInstance != null && this.tomeInstance.isPerfect();
    }

    @Override
    public boolean isDefective() {
        return this.tomeInstance != null && this.tomeInstance.isDefective();
    }

    @Override
    public float getOverallPercentage() {
        return this.tomeInstance != null ? this.tomeInstance.getOverallPercentage() : 0.0f;
    }

    @Override
    public String toString() {
        return "TomeItem{tomeInfo=" + String.valueOf(this.tomeInfo) + ", tomeInstance=" + String.valueOf(this.tomeInstance) + "}";
    }
}

