/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.items.game;

import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.elements.type.Element;
import com.wynntils.models.elements.type.Powder;
import com.wynntils.models.gear.type.GearAttackSpeed;
import com.wynntils.models.gear.type.GearRequirements;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.gear.type.GearType;
import com.wynntils.models.gear.type.SetInfo;
import com.wynntils.models.gear.type.SetInstance;
import com.wynntils.models.items.items.game.GameItem;
import com.wynntils.models.items.properties.ClassableItemProperty;
import com.wynntils.models.items.properties.GearTierItemProperty;
import com.wynntils.models.items.properties.GearTypeItemProperty;
import com.wynntils.models.items.properties.LeveledItemProperty;
import com.wynntils.models.items.properties.PowderedItemProperty;
import com.wynntils.models.items.properties.RequirementItemProperty;
import com.wynntils.models.items.properties.RerollableItemProperty;
import com.wynntils.models.items.properties.SetItemProperty;
import com.wynntils.models.items.properties.ShinyItemProperty;
import com.wynntils.models.stats.type.DamageType;
import com.wynntils.models.stats.type.ShinyStat;
import com.wynntils.models.stats.type.StatActualValue;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.type.RangedValue;
import java.util.List;
import java.util.Optional;

public class UnknownGearItem
extends GameItem
implements GearTierItemProperty,
GearTypeItemProperty,
LeveledItemProperty,
PowderedItemProperty,
RerollableItemProperty,
ShinyItemProperty,
ClassableItemProperty,
SetItemProperty,
RequirementItemProperty {
    private final String name;
    private final GearType gearType;
    private final GearTier gearTier;
    private final boolean isUnidentified;
    private final int level;
    private final GearAttackSpeed attackSpeed;
    private final int health;
    private final List<Pair<DamageType, RangedValue>> damages;
    private final List<Pair<Element, Integer>> defences;
    private final GearRequirements requirements;
    private final boolean allRequirementsMet;
    private final List<StatActualValue> identifications;
    private final List<Powder> powders;
    private final int powderSlots;
    private final int rerolls;
    private final SetInstance setInstance;
    private final ShinyStat shinyStat;

    public UnknownGearItem(String name, GearType gearType, GearTier gearTier, boolean isUnidentified, int level, GearAttackSpeed attackSpeed, int health, List<Pair<DamageType, RangedValue>> damages, List<Pair<Element, Integer>> defences, GearRequirements requirements, boolean allRequirementsMet, List<StatActualValue> identifications, List<Powder> powders, int powderSlots, int rerolls, SetInstance setInstance, ShinyStat shinyStat) {
        this.name = name;
        this.gearType = gearType;
        this.gearTier = gearTier;
        this.isUnidentified = isUnidentified;
        this.level = level;
        this.attackSpeed = attackSpeed;
        this.health = health;
        this.damages = damages;
        this.defences = defences;
        this.requirements = requirements;
        this.allRequirementsMet = allRequirementsMet;
        this.identifications = identifications;
        this.powders = powders;
        this.powderSlots = powderSlots;
        this.rerolls = rerolls;
        this.setInstance = setInstance;
        this.shinyStat = shinyStat;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public GearType getGearType() {
        return this.gearType;
    }

    @Override
    public GearTier getGearTier() {
        return this.gearTier;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public GearAttackSpeed getAttackSpeed() {
        return this.attackSpeed;
    }

    public int getHealth() {
        return this.health;
    }

    public List<Pair<DamageType, RangedValue>> getDamages() {
        return this.damages;
    }

    public List<Pair<Element, Integer>> getDefences() {
        return this.defences;
    }

    public GearRequirements getRequirements() {
        return this.requirements;
    }

    public boolean isUnidentified() {
        return this.isUnidentified;
    }

    public List<StatActualValue> getIdentifications() {
        return this.identifications;
    }

    @Override
    public ClassType getRequiredClass() {
        return this.requirements.classType().orElse(null);
    }

    @Override
    public List<Powder> getPowders() {
        return this.powders;
    }

    @Override
    public int getPowderSlots() {
        return this.powderSlots;
    }

    @Override
    public boolean meetsActualRequirements() {
        return this.allRequirementsMet;
    }

    @Override
    public int getRerollCount() {
        return this.rerolls;
    }

    @Override
    public Optional<SetInfo> getSetInfo() {
        return Optional.ofNullable(this.setInstance).map(SetInstance::setInfo);
    }

    @Override
    public Optional<SetInstance> getSetInstance() {
        return Optional.ofNullable(this.setInstance);
    }

    @Override
    public Optional<ShinyStat> getShinyStat() {
        return Optional.ofNullable(this.shinyStat);
    }

    @Override
    public String toString() {
        return "UnknownGearItem{name='" + this.name + "', gearType=" + String.valueOf((Object)this.gearType) + ", gearTier=" + String.valueOf((Object)this.gearTier) + ", level=" + this.level + ", attackSpeed=" + String.valueOf((Object)this.attackSpeed) + ", health=" + this.health + ", damages=" + String.valueOf(this.damages) + ", defences=" + String.valueOf(this.defences) + ", requirements=" + String.valueOf(this.requirements) + ", allRequirementsMet=" + this.allRequirementsMet + ", identifications=" + String.valueOf(this.identifications) + ", powders=" + String.valueOf(this.powders) + ", powderSlots=" + this.powderSlots + ", rerolls=" + this.rerolls + ", setInstance=" + String.valueOf(this.setInstance) + ", shinyStat=" + String.valueOf(this.shinyStat) + "}";
    }
}

