/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.lootrun.particle;

import com.wynntils.handlers.particle.type.Particle;
import com.wynntils.handlers.particle.type.ParticleType;
import com.wynntils.handlers.particle.type.ParticleVerifier;
import java.util.List;
import net.minecraft.class_2374;
import net.minecraft.class_243;

public class LootrunTaskParticleVerifier
implements ParticleVerifier {
    private static final int RADIUS = 5;
    private static final double CIRCLE_RADIUS_WITH_ERROR = 6.0;

    @Override
    public boolean verifyNewPosition(List<class_2374> positions, class_2374 addedPosition) {
        if (positions.isEmpty()) {
            return LootrunTaskParticleVerifier.isParticlePrecise(addedPosition);
        }
        class_2374 rightParticle = positions.getFirst();
        class_243 circleCenter = new class_243(rightParticle.method_10216() - 5.0, rightParticle.method_10214(), rightParticle.method_10215());
        boolean isPartOfCircle = circleCenter.method_24802(addedPosition, 6.0);
        if (!isPartOfCircle) {
            return false;
        }
        if (positions.size() % 5 == 0) {
            return LootrunTaskParticleVerifier.isParticlePrecise(addedPosition);
        }
        return true;
    }

    @Override
    public ParticleVerifier.VerificationResult verifyCompleteness(List<class_2374> positions) {
        if (positions.size() == 2) {
            class_2374 rightParticle = positions.get(0);
            class_2374 leftParticle = positions.get(1);
            if (LootrunTaskParticleVerifier.isParticlePrecise(rightParticle) && LootrunTaskParticleVerifier.isParticlePrecise(leftParticle)) {
                class_243 leftParticleVec;
                class_243 rightParticleVec = new class_243(rightParticle.method_10216(), rightParticle.method_10214(), rightParticle.method_10215());
                return rightParticleVec.method_1025(leftParticleVec = new class_243(leftParticle.method_10216(), leftParticle.method_10214(), leftParticle.method_10215())) == 100.0 ? ParticleVerifier.VerificationResult.VERIFIED : ParticleVerifier.VerificationResult.INVALID;
            }
            return ParticleVerifier.VerificationResult.UNVERIFIED;
        }
        if (positions.size() == 20) {
            return ParticleVerifier.VerificationResult.VERIFIED;
        }
        if (positions.size() > 20) {
            return ParticleVerifier.VerificationResult.INVALID;
        }
        return ParticleVerifier.VerificationResult.UNVERIFIED;
    }

    @Override
    public Particle getParticle(List<class_2374> positions) {
        class_2374 rightParticle = positions.getFirst();
        class_243 verifiedParticlePosition = new class_243(rightParticle.method_10216() - 5.0, rightParticle.method_10214(), rightParticle.method_10215());
        return new Particle((class_2374)verifiedParticlePosition, ParticleType.LOOTRUN_TASK);
    }

    private static boolean isParticlePrecise(class_2374 addedPosition) {
        return Math.abs(addedPosition.method_10216() % 0.5) == 0.0 && Math.abs(addedPosition.method_10215() % 0.5) == 0.0;
    }
}

