/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.spells.event;

import com.wynntils.models.spells.type.SpellDirection;
import com.wynntils.models.spells.type.SpellFailureReason;
import com.wynntils.models.spells.type.SpellType;
import net.neoforged.bus.api.Event;

public abstract class SpellEvent
extends Event {

    public static final class Failed
    extends SpellEvent {
        private final SpellFailureReason failureReason;

        public Failed(SpellFailureReason failureReason) {
            this.failureReason = failureReason;
        }

        public SpellFailureReason getFailureReason() {
            return this.failureReason;
        }
    }

    public static final class Cast
    extends SpellEvent {
        private final SpellType spellType;
        private final int manaCost;
        private final int healthCost;

        public Cast(SpellType spellType, int manaCost) {
            this(spellType, manaCost, 0);
        }

        public Cast(SpellType spellType, int manaCost, int healthCost) {
            this.spellType = spellType;
            this.manaCost = manaCost;
            this.healthCost = healthCost;
        }

        public SpellType getSpellType() {
            return this.spellType;
        }

        public int getManaCost() {
            return this.manaCost;
        }

        public int getHealthCost() {
            return this.healthCost;
        }
    }

    public static final class Expired
    extends Casting {
        public Expired() {
            super(SpellDirection.NO_SPELL);
        }
    }

    public static final class Completed
    extends Casting {
        private final SpellType spell;

        public Completed(SpellDirection[] spellDirectionArray, SpellType spell) {
            super(spellDirectionArray);
            this.spell = spell;
        }

        public SpellType getSpell() {
            return this.spell;
        }
    }

    public static final class Partial
    extends Casting {
        public Partial(SpellDirection[] spellDirectionArray) {
            super(spellDirectionArray);
        }
    }

    public static abstract class Casting
    extends SpellEvent {
        private final SpellDirection[] spellDirectionArray;

        protected Casting(SpellDirection[] spellDirectionArray) {
            this.spellDirectionArray = spellDirectionArray;
        }

        public SpellDirection[] getSpellDirectionArray() {
            return (SpellDirection[])this.spellDirectionArray.clone();
        }
    }
}

