/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.stats;

import com.google.common.reflect.TypeToken;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Model;
import com.wynntils.core.json.JsonManager;
import com.wynntils.core.net.DownloadRegistry;
import com.wynntils.core.net.UrlId;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.gear.type.GearInfo;
import com.wynntils.models.spells.type.SpellType;
import com.wynntils.models.stats.StatCalculator;
import com.wynntils.models.stats.StatListOrderer;
import com.wynntils.models.stats.builders.DamageStatBuilder;
import com.wynntils.models.stats.builders.DefenceStatBuilder;
import com.wynntils.models.stats.builders.MiscStatBuilder;
import com.wynntils.models.stats.builders.SkillStatBuilder;
import com.wynntils.models.stats.builders.SpellStatBuilder;
import com.wynntils.models.stats.builders.StatBuilder;
import com.wynntils.models.stats.type.DamageStatType;
import com.wynntils.models.stats.type.DefenceStatType;
import com.wynntils.models.stats.type.MiscStatType;
import com.wynntils.models.stats.type.SkillStatType;
import com.wynntils.models.stats.type.SpellStatType;
import com.wynntils.models.stats.type.StatActualValue;
import com.wynntils.models.stats.type.StatListOrdering;
import com.wynntils.models.stats.type.StatPossibleValues;
import com.wynntils.models.stats.type.StatType;
import com.wynntils.models.stats.type.StatUnit;
import com.wynntils.utils.type.RangedValue;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;

public final class StatModel
extends Model {
    private final List<StatType> statTypeRegistry = new ArrayList<StatType>();
    private final StatLookupTable statTypeLookup = new StatLookupTable();
    private final Map<StatListOrdering, List<StatType>> orderingLists;
    private Map<StatType, Integer> statTypeIdMap = new HashMap<StatType, Integer>();

    public StatModel() {
        super(List.of());
        List<SkillStatType> skillStats = StatModel.buildStats(new SkillStatBuilder());
        List<MiscStatType> miscStats = StatModel.buildStats(new MiscStatBuilder());
        List<DefenceStatType> defenceStats = StatModel.buildStats(new DefenceStatBuilder());
        List<DamageStatType> damageStats = StatModel.buildStats(new DamageStatBuilder());
        List<SpellStatType> spellStats = StatModel.buildStats(new SpellStatBuilder());
        this.initRegistry(skillStats, miscStats, defenceStats, damageStats, spellStats);
        this.orderingLists = StatListOrderer.createOrderingMap(skillStats, miscStats, defenceStats, damageStats, spellStats);
    }

    @Override
    public void registerDownloads(DownloadRegistry registry) {
        registry.registerDownload(UrlId.DATA_STATIC_IDENTIFICATION_KEYS).handleReader(this::handleIdentificationKeys);
    }

    public StatActualValue buildActualValue(StatType statType, int value, int stars, StatPossibleValues possibleValues) {
        RangedValue internalRoll = possibleValues != null ? StatCalculator.calculateInternalRollRange(possibleValues, value, stars) : RangedValue.NONE;
        return new StatActualValue(statType, value, stars, internalRoll);
    }

    public StatType fromDisplayName(String displayName, String unit) {
        return this.statTypeLookup.get(displayName, unit);
    }

    public StatType fromInternalRollId(String id) {
        for (StatType statType : this.statTypeRegistry) {
            if (!statType.getInternalRollName().equals(id)) continue;
            return statType;
        }
        return null;
    }

    public StatType fromApiName(String id) {
        for (StatType statType : this.statTypeRegistry) {
            if (!statType.getApiName().equals(id)) continue;
            return statType;
        }
        return null;
    }

    public Optional<Integer> getIdForStatType(StatType statType) {
        return Optional.ofNullable(this.statTypeIdMap.get(statType));
    }

    public Optional<StatType> getStatTypeForId(int id) {
        return this.statTypeIdMap.entrySet().stream().filter(entry -> (Integer)entry.getValue() == id).map(Map.Entry::getKey).findFirst();
    }

    public String getDisplayName(StatType statType, ClassType classReq, ClassType currentClass, RangedValue workingLevelRange) {
        if (statType instanceof SpellStatType) {
            SpellStatType spellStatType = (SpellStatType)statType;
            ClassType classToUse = classReq != null ? classReq : currentClass;
            SpellType spellType = spellStatType.getSpellType().forOtherClass(classToUse);
            return SpellStatBuilder.getStatNameForSpell(spellType.getName());
        }
        if (statType.getSpecialStatType() == StatType.SpecialStatType.CHARM_LEVELED_STAT) {
            return statType.getDisplayName().replace("${}", workingLevelRange.low() + "-" + workingLevelRange.high());
        }
        return statType.getDisplayName();
    }

    public List<StatType> getOrderingList(StatListOrdering ordering) {
        return this.orderingLists.get((Object)ordering);
    }

    public List<StatType> getSortedStats(GearInfo gearInfo, StatListOrdering ordering) {
        List<StatType> orderingList = this.orderingLists.get((Object)ordering);
        ArrayList<StatType> sortedStats = new ArrayList<StatType>(gearInfo.getVariableStats());
        sortedStats.sort(Comparator.comparingInt(orderingList::indexOf));
        return sortedStats;
    }

    public List<StatType> getAllStatTypes() {
        return this.statTypeRegistry;
    }

    private static <T extends StatType> List<T> buildStats(StatBuilder<T> builder) {
        ArrayList statList = new ArrayList();
        builder.buildStats(statList::add);
        return statList;
    }

    private void initRegistry(List<SkillStatType> skillStats, List<MiscStatType> miscStats, List<DefenceStatType> defenceStats, List<DamageStatType> damageStats, List<SpellStatType> spellStats) {
        this.statTypeRegistry.addAll(skillStats);
        this.statTypeRegistry.addAll(miscStats);
        this.statTypeRegistry.addAll(defenceStats);
        this.statTypeRegistry.addAll(damageStats);
        this.statTypeRegistry.addAll(spellStats);
        for (StatType statType : this.statTypeRegistry) {
            this.statTypeLookup.put(statType.getDisplayName(), statType.getUnit(), statType);
        }
        for (SpellStatType spellStatType : spellStats) {
            for (String alias : SpellStatBuilder.getAliases(spellStatType)) {
                this.statTypeLookup.put(alias, spellStatType.getUnit(), spellStatType);
            }
        }
    }

    private void handleIdentificationKeys(Reader reader) {
        Type type = new TypeToken<Map<String, Integer>>(){}.getType();
        Map apiNamesToIdMap = (Map)JsonManager.GSON.fromJson(reader, type);
        HashMap<StatType, Integer> tempMap = new HashMap<StatType, Integer>();
        for (Map.Entry entry : apiNamesToIdMap.entrySet()) {
            StatType statType = this.fromApiName((String)entry.getKey());
            if (statType == null) {
                WynntilsMod.warn("Unknown stat type for identification key: " + (String)entry.getKey());
                continue;
            }
            tempMap.put(statType, (Integer)entry.getValue());
        }
        this.statTypeIdMap = Map.copyOf(tempMap);
    }

    private static class StatLookupTable {
        private final Map<String, StatType> lookupTable = new HashMap<String, StatType>();
        private final Map<Pattern, StatType> regexLookupTable = new HashMap<Pattern, StatType>();

        private StatLookupTable() {
        }

        private StatType get(String displayName, String unit) {
            String lookupName = displayName + (unit == null ? "" : unit);
            StatType statType = this.lookupTable.get(lookupName);
            if (statType != null) {
                return statType;
            }
            for (Map.Entry<Pattern, StatType> entry : this.regexLookupTable.entrySet()) {
                if (!entry.getKey().matcher(displayName).matches()) continue;
                statType = entry.getValue();
                break;
            }
            return statType;
        }

        private void put(String displayName, StatUnit unit, StatType statType) {
            if (statType.getSpecialStatType() == StatType.SpecialStatType.TOME_BASE_STAT) {
                return;
            }
            if (statType.getSpecialStatType() == StatType.SpecialStatType.CHARM_LEVELED_STAT) {
                this.regexLookupTable.put(Pattern.compile(statType.getDisplayName().replace("${}", "(\\d+)-(\\d+)")), statType);
                return;
            }
            String lookupName = displayName + unit.getDisplayName();
            this.lookupTable.put(lookupName, statType);
        }
    }
}

