/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.TextOverlay;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.handlers.scoreboard.event.ScoreboardSegmentAdditionEvent;
import com.wynntils.models.raid.RaidModel;
import com.wynntils.models.raid.scoreboard.RaidScoreboardPart;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.VerticalAlignment;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public class RaidProgressOverlay
extends TextOverlay {
    private String template;
    private String previewTemplate;
    @Persisted
    public final Config<Boolean> showIntermission = new Config<Boolean>(false);
    @Persisted
    public final Config<Boolean> showMilliseconds = new Config<Boolean>(true);
    @Persisted
    public final Config<Boolean> totalIntermission = new Config<Boolean>(false);
    @Persisted
    public final Config<Boolean> showDamage = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> disableRaidInfoOnScoreboard = new Config<Boolean>(false);

    public RaidProgressOverlay() {
        super(new OverlayPosition(120.0f, 5.0f, VerticalAlignment.TOP, HorizontalAlignment.LEFT, OverlayPosition.AnchorSection.MIDDLE_LEFT), 200.0f, 120.0f);
        this.buildTemplates();
    }

    @Override
    protected String getTemplate() {
        return this.template;
    }

    @Override
    protected String getPreviewTemplate() {
        return this.previewTemplate;
    }

    @Override
    protected void onConfigUpdate(Config<?> config) {
        this.buildTemplates();
    }

    @Override
    public boolean isVisible() {
        return Models.Raid.getCurrentRaid() != null;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onScoreboardSegmentChange(ScoreboardSegmentAdditionEvent event) {
        if (((Boolean)this.disableRaidInfoOnScoreboard.get()).booleanValue() && event.getSegment().getScoreboardPart() instanceof RaidScoreboardPart) {
            event.setCanceled(true);
        }
    }

    private void buildTemplates() {
        StringBuilder templateBuilder = new StringBuilder("{concat(\"\u00a76\u00a7l\u00a7n\";current_raid;\"\n\";");
        StringBuilder previewBuilder = new StringBuilder("\u00a76\u00a7l\u00a7nNest of the Grootslangs\n\n");
        int i = 0;
        while (true) {
            if (i >= RaidModel.MAXIMUM_CHALLENGE_ROOMS) break;
            templateBuilder.append(this.getChallengeTemplate(i + 1));
            ++i;
        }
        for (i = 0; i < 3; ++i) {
            previewBuilder.append(this.getChallengePreview(i + 1));
        }
        templateBuilder.append("\"\n\";");
        i = 0;
        while (true) {
            if (i >= RaidModel.MAXIMUM_BOSS_ROOMS) break;
            templateBuilder.append(this.getBossTemplate(i + 1));
            ++i;
        }
        templateBuilder.append("\"\n\";");
        previewBuilder.append(this.getBossPreview());
        if (((Boolean)this.showIntermission.get()).booleanValue()) {
            templateBuilder.append(this.getIntermissionTemplate());
            previewBuilder.append(this.getIntermissionPreview());
        }
        templateBuilder.append(this.getTotalTemplate());
        previewBuilder.append(this.getTotalPreview());
        this.template = templateBuilder.toString();
        this.previewTemplate = previewBuilder.toString();
    }

    private String getChallengeTemplate(int challengeNum) {
        StringBuilder challengeBuilder = new StringBuilder("if_str(and(raid_has_room(").append(challengeNum).append(");not(raid_is_boss_room(").append(challengeNum).append(")));concat(\"\n\u00a7d\";if_str(eq_str(raid_room_name(").append(challengeNum).append(");\"\");\"Challenge ").append(challengeNum).append("\";raid_room_name(").append(challengeNum).append("));\": \";if_str(eq(raid_room_time(").append(challengeNum).append(");-1);\"\u00a77");
        if (((Boolean)this.showMilliseconds.get()).booleanValue()) {
            challengeBuilder.append("--:--.---");
        } else {
            challengeBuilder.append("--:--");
        }
        challengeBuilder.append("\";concat(\"\u00a7b\";leading_zeros(int(div(div(raid_room_time(").append(challengeNum).append(");1000);60));2);\":\";leading_zeros(int(mod(div(raid_room_time(").append(challengeNum).append(");1000);60));2)");
        if (((Boolean)this.showMilliseconds.get()).booleanValue()) {
            challengeBuilder.append(";\".\";leading_zeros(int(mod(raid_room_time(").append(challengeNum).append(");1000));3)))");
        } else {
            challengeBuilder.append("))");
        }
        if (((Boolean)this.showDamage.get()).booleanValue()) {
            challengeBuilder.append(";if_str(eq(raid_room_damage(").append(challengeNum).append(");-1);\"\";concat(\" \u00a7f(\u00a7e\";format(raid_room_damage(").append(challengeNum).append("));\"\u00a7f)\")));");
        } else {
            challengeBuilder.append(");");
        }
        challengeBuilder.append("\"\");");
        return challengeBuilder.toString();
    }

    private String getChallengePreview(int challengeNum) {
        String challengeName = switch (challengeNum) {
            case 1 -> "Slimey Platform";
            case 2 -> "Gathering Room";
            default -> "Hammer Room";
        };
        String challengePreview = (Boolean)this.showMilliseconds.get() != false ? "\u00a7d" + challengeName + ": \u00a7b01:17.022" : "\u00a7d" + challengeName + ": \u00a7b01:17";
        if (((Boolean)this.showDamage.get()).booleanValue()) {
            challengePreview = challengePreview + " \u00a7f(\u00a7e343k\u00a7f)";
        }
        challengePreview = challengePreview + "\n";
        return challengePreview;
    }

    private String getBossTemplate(int bossNum) {
        String realBossNum = "int(add(current_raid_challenge_count;" + bossNum + "))";
        StringBuilder bossBuilder = new StringBuilder("if_str(raid_is_boss_room(").append(realBossNum).append(");concat(\"\n\u00a74\";if_str(eq_str(raid_room_name(").append(realBossNum).append(");\"The ##### Anomaly\");\"The &k##### &r&4Anomaly\";raid_room_name(").append(realBossNum).append("));\": \";if_str(eq(raid_room_time(").append(realBossNum).append(");-1);\"\u00a77");
        if (((Boolean)this.showMilliseconds.get()).booleanValue()) {
            bossBuilder.append("--:--.---");
        } else {
            bossBuilder.append("--:--");
        }
        bossBuilder.append("\";concat(\"\u00a7b\";leading_zeros(int(div(div(raid_room_time(").append(realBossNum).append(");1000);60));2);\":\";leading_zeros(int(mod(div(raid_room_time(").append(realBossNum).append(");1000);60));2)");
        if (((Boolean)this.showMilliseconds.get()).booleanValue()) {
            bossBuilder.append(";\".\";leading_zeros(int(mod(raid_room_time(").append(realBossNum).append(");1000));3)))");
        } else {
            bossBuilder.append("))");
        }
        if (((Boolean)this.showDamage.get()).booleanValue()) {
            bossBuilder.append(";if_str(eq(raid_room_damage(").append(realBossNum).append(");-1);\"\";concat(\" \u00a7f(\u00a7e\";format(raid_room_damage(").append(realBossNum).append("));\"\u00a7f)\")));");
        } else {
            bossBuilder.append(");");
        }
        bossBuilder.append("\"\");");
        return bossBuilder.toString();
    }

    private String getBossPreview() {
        Object bossPreview = (Boolean)this.showMilliseconds.get() != false ? "\n\u00a74Grootslang Wyrmling: \u00a77--:--.---" : "\n\u00a74Grootslang Wyrmling: \u00a77--:--";
        if (((Boolean)this.showDamage.get()).booleanValue()) {
            bossPreview = (String)bossPreview + " \u00a7f(\u00a7e343k\u00a7f)";
        }
        bossPreview = (String)bossPreview + "\n";
        return bossPreview;
    }

    private String getIntermissionTemplate() {
        if (((Boolean)this.showMilliseconds.get()).booleanValue()) {
            return "\"\n\u00a78Intermission: \";concat(\"\u00a7b\";leading_zeros(int(div(div(raid_intermission_time;1000);60));2);\":\";leading_zeros(int(mod(div(raid_intermission_time;1000);60));2);\".\";leading_zeros(int(mod(raid_intermission_time;1000));3));";
        }
        return "\"\n\u00a78Intermission: \";concat(\"\u00a7b\";leading_zeros(int(div(div(raid_intermission_time;1000);60));2);\":\";leading_zeros(int(mod(div(raid_intermission_time;1000);60));2));";
    }

    private String getIntermissionPreview() {
        if (((Boolean)this.showMilliseconds.get()).booleanValue()) {
            return "\n\u00a78Intermission: \u00a7700:15.072";
        }
        return "\n\u00a78Intermission: \u00a7700:15";
    }

    private String getTotalTemplate() {
        String timeToUse = (Boolean)this.totalIntermission.get() != false ? "raid_time" : "sub(raid_time;raid_intermission_time)";
        String totalTemplate = (Boolean)this.showMilliseconds.get() != false ? "\"\n\u00a75Total: \";concat(\"\u00a7b\";leading_zeros(int(div(div(" + timeToUse + ";1000);60));2);\":\";leading_zeros(int(mod(div(" + timeToUse + ";1000);60));2);\".\";leading_zeros(int(mod(" + timeToUse + ";1000));3))" : "\"\n\u00a75Total: \";concat(\"\u00a7b\";leading_zeros(int(div(div(" + timeToUse + ";1000);60));2);\":\";leading_zeros(int(mod(div(" + timeToUse + ";1000);60));2))";
        totalTemplate = (Boolean)this.showDamage.get() != false ? totalTemplate + ";if_str(eq(raid_damage;-1);\"\";concat(\" \u00a7f(\u00a7e\";format(raid_damage);\"\u00a7f)\")))}" : totalTemplate + ")}";
        return totalTemplate;
    }

    private String getTotalPreview() {
        Object totalPreview = ((Boolean)this.totalIntermission.get()).booleanValue() ? (((Boolean)this.showMilliseconds.get()).booleanValue() ? "\n\u00a75Total: \u00a7b03:36.279" : "\n\u00a75Total: \u00a7b03:36") : ((Boolean)this.showMilliseconds.get() != false ? "\n\u00a75Total: \u00a7b03:21.207" : "\n\u00a75Total: \u00a7b03:21");
        if (((Boolean)this.showDamage.get()).booleanValue()) {
            totalPreview = (String)totalPreview + " \u00a7f(\u00a7e1.3M\u00a7f)";
        }
        return totalPreview;
    }
}

