/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.consumers.overlays.TextOverlay;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.models.abilities.event.ShamanMaskTitlePacketEvent;
import com.wynntils.models.abilities.type.ShamanMaskType;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.VerticalAlignment;
import net.minecraft.class_1041;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_9779;
import net.neoforged.bus.api.SubscribeEvent;

public class ShamanMaskOverlay
extends TextOverlay {
    private static final String TEMPLATE = "{shaman_mask} mask";
    @Persisted
    private final Config<Boolean> hideMaskTitles = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> displayNone = new Config<Boolean>(false);

    public ShamanMaskOverlay() {
        super(new OverlayPosition(-60.0f, 150.0f, VerticalAlignment.BOTTOM, HorizontalAlignment.CENTER, OverlayPosition.AnchorSection.BOTTOM_MIDDLE), new OverlaySize(81.0f, 21.0f), HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE);
    }

    @SubscribeEvent
    public void onShamanMaskTitle(ShamanMaskTitlePacketEvent event) {
        if (((Boolean)this.hideMaskTitles.get()).booleanValue()) {
            event.setCanceled(true);
        }
    }

    @Override
    public void render(class_332 guiGraphics, class_4597 bufferSource, class_9779 deltaTracker, class_1041 window) {
        ShamanMaskType currentMaskType = Models.ShamanMask.getCurrentMaskType();
        if (currentMaskType == ShamanMaskType.NONE && !((Boolean)this.displayNone.get()).booleanValue()) {
            return;
        }
        super.render(guiGraphics, bufferSource, deltaTracker, window);
    }

    @Override
    public String getTemplate() {
        return TEMPLATE;
    }

    @Override
    public String getPreviewTemplate() {
        return ShamanMaskType.AWAKENED.getName() + " mask";
    }
}

