/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays.gamebars;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.bossbar.TrackedBar;
import com.wynntils.handlers.bossbar.event.BossBarAddedEvent;
import com.wynntils.handlers.bossbar.type.BossBarProgress;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedFontRenderer;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.UniversalTexture;
import com.wynntils.utils.render.type.VerticalAlignment;
import net.minecraft.class_1041;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_9779;

public abstract class BaseBarOverlay
extends Overlay {
    @Persisted(i18nKey="feature.wynntils.gameBarsOverlay.overlay.baseBar.textShadow")
    protected final Config<TextShadow> textShadow = new Config<TextShadow>(TextShadow.OUTLINE);
    @Persisted(i18nKey="feature.wynntils.gameBarsOverlay.overlay.baseBar.flip")
    private final Config<Boolean> flip = new Config<Boolean>(false);
    @Persisted(i18nKey="feature.wynntils.gameBarsOverlay.overlay.baseBar.barTexture")
    protected final Config<UniversalTexture> barTexture = new Config<UniversalTexture>(UniversalTexture.A);
    @Persisted(i18nKey="feature.wynntils.gameBarsOverlay.overlay.baseBar.animationTime")
    private final Config<Float> animationTime = new Config<Float>(Float.valueOf(2.0f));
    @Persisted(i18nKey="feature.wynntils.gameBarsOverlay.overlay.baseBar.shouldDisplayOriginal")
    protected final Config<Boolean> shouldDisplayOriginal = new Config<Boolean>(false);
    @Persisted(i18nKey="feature.wynntils.gameBarsOverlay.overlay.baseBar.textColor")
    protected final Config<CustomColor> textColor = new Config<CustomColor>(CommonColors.WHITE);
    protected float currentProgress = 0.0f;

    protected BaseBarOverlay(OverlayPosition position, OverlaySize size, CustomColor textColor) {
        super(position, size);
        this.textColor.store(textColor);
        WynntilsMod.registerListener(this::onBossBarAdd);
    }

    protected float textureHeight() {
        return ((UniversalTexture)this.barTexture.get()).getHeight();
    }

    protected abstract BossBarProgress progress();

    protected abstract Class<? extends TrackedBar> getTrackedBarClass();

    private void onBossBarAdd(BossBarAddedEvent event) {
        if (!Managers.Overlay.isEnabled(this)) {
            return;
        }
        if (!event.getTrackedBar().getClass().equals(this.getTrackedBarClass())) {
            return;
        }
        if (!((Boolean)this.shouldDisplayOriginal.get()).booleanValue()) {
            event.setCanceled(true);
        }
    }

    @Override
    public void tick() {
        if (!this.isRendered() || this.progress() == null) {
            return;
        }
        if (((Float)this.animationTime.get()).floatValue() == 0.0f) {
            this.currentProgress = this.progress().progress();
            return;
        }
        this.currentProgress -= ((Float)this.animationTime.get()).floatValue() * 0.1f * (this.currentProgress - this.progress().progress());
    }

    @Override
    public void render(class_332 guiGraphics, class_4597 bufferSource, class_9779 deltaTracker, class_1041 window) {
        float renderedProgress = (float)Math.round((float)((Boolean)this.flip.get() != false ? -1 : 1) * this.currentProgress * 100.0f) / 100.0f;
        this.renderAll(guiGraphics, bufferSource, renderedProgress);
    }

    @Override
    public void renderPreview(class_332 guiGraphics, class_4597 bufferSource, class_9779 deltaTracker, class_1041 window) {
        if (this.progress() == null) {
            this.renderAll(guiGraphics, bufferSource, 50.0f);
            return;
        }
        float renderedProgress = (float)Math.round((float)((Boolean)this.flip.get() != false ? -1 : 1) * this.currentProgress * 100.0f) / 100.0f;
        this.renderAll(guiGraphics, bufferSource, renderedProgress);
    }

    private void renderAll(class_332 guiGraphics, class_4597 bufferSource, float renderedProgress) {
        class_4587 poseStack = guiGraphics.method_51448();
        float barHeight = this.textureHeight() * (this.getWidth() / 81.0f);
        float renderY = this.getModifiedRenderY(barHeight + 10.0f);
        this.renderText(poseStack, bufferSource, renderY, this.text());
        this.renderBar(poseStack, bufferSource, renderY + 10.0f, barHeight, renderedProgress);
    }

    protected String text() {
        BossBarProgress barProgress = this.progress();
        if (this.progress() == null) {
            return this.icon();
        }
        return String.format("%s %s %s", this.progress().value().current(), this.icon(), this.progress().value().max());
    }

    protected String icon() {
        return "";
    }

    private float getModifiedRenderY(float renderedHeight) {
        return switch (this.getRenderVerticalAlignment()) {
            default -> throw new MatchException(null, null);
            case VerticalAlignment.TOP -> this.getRenderY();
            case VerticalAlignment.MIDDLE -> this.getRenderY() + (this.getHeight() - renderedHeight) / 2.0f;
            case VerticalAlignment.BOTTOM -> this.getRenderY() + this.getHeight() - renderedHeight;
        };
    }

    protected void renderBar(class_4587 poseStack, class_4597 bufferSource, float renderY, float renderHeight, float progress) {
        BufferedRenderUtils.drawColoredProgressBar(poseStack, bufferSource, Texture.UNIVERSAL_BAR, (CustomColor)this.textColor.get(), this.getRenderX(), renderY, this.getRenderX() + this.getWidth(), renderY + renderHeight, 0, ((UniversalTexture)this.barTexture.get()).getTextureY1(), Texture.UNIVERSAL_BAR.width(), ((UniversalTexture)this.barTexture.get()).getTextureY2(), progress);
    }

    protected void renderText(class_4587 poseStack, class_4597 bufferSource, float renderY, String text) {
        BufferedFontRenderer.getInstance().renderAlignedTextInBox(poseStack, bufferSource, StyledText.fromString(text), this.getRenderX(), this.getRenderX() + this.getWidth(), renderY, 0.0f, (CustomColor)this.textColor.get(), this.getRenderHorizontalAlignment(), (TextShadow)this.textShadow.get());
    }
}

