/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.activities;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.handlers.wrappedscreen.WrappedScreenHolder;
import com.wynntils.handlers.wrappedscreen.type.WrappedScreenInfo;
import com.wynntils.mc.event.ContainerSetContentEvent;
import com.wynntils.mc.event.ContainerSetSlotEvent;
import com.wynntils.models.activities.type.ActivityInfo;
import com.wynntils.models.activities.type.ActivityTrackingState;
import com.wynntils.models.items.items.gui.ActivityItem;
import com.wynntils.screens.activities.WynntilsContentBookScreen;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.wynn.ContainerUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_437;
import net.neoforged.bus.api.SubscribeEvent;

public class ContentBookHolder
extends WrappedScreenHolder<WynntilsContentBookScreen> {
    private static final Pattern TITLE_PATTERN = Pattern.compile("\u00a7f\udaff\udfee\ue004");
    private static final String TUTORIAL_ITEM_NAME = "\udb3f\udfff";
    private static final Pair<Integer, Integer> DIALOGUE_HISTORY_SLOTS = Pair.of(13, 58);
    public static final Pair<Integer, Integer> SCROLL_UP_SLOTS = Pair.of(20, 65);
    private static final Pair<Integer, Integer> FILTER_ITEM_SLOTS = Pair.of(21, 66);
    private static final Pair<Integer, Integer> SORT_ITEM_SLOTS = Pair.of(22, 67);
    private static final Pair<Integer, Integer> PROGRESS_SLOTS = Pair.of(23, 68);
    public static final Pair<Integer, Integer> SCROLL_DOWN_SLOTS = Pair.of(24, 69);
    private static final Set<Pair<Integer, Integer>> ACTION_SLOTS = Set.of(DIALOGUE_HISTORY_SLOTS, SCROLL_UP_SLOTS, FILTER_ITEM_SLOTS, SORT_ITEM_SLOTS, PROGRESS_SLOTS, SCROLL_DOWN_SLOTS);
    private Map<Integer, Pair<class_1799, ActivityInfo>> activities = new TreeMap<Integer, Pair<class_1799, ActivityInfo>>();
    private Map<Integer, class_1799> actions = new TreeMap<Integer, class_1799>();
    public boolean inTutorial = false;
    private boolean resetNextSetContent = true;
    private WynntilsContentBookScreen wrappedScreen;

    @SubscribeEvent
    public void onSetSlot(ContainerSetSlotEvent.Post event) {
        class_437 class_4372 = McUtils.screen();
        if (!(class_4372 instanceof WynntilsContentBookScreen)) {
            return;
        }
        WynntilsContentBookScreen contentBookScreen = (WynntilsContentBookScreen)class_4372;
        if (event.getContainerId() == McUtils.inventoryMenu().field_7763) {
            for (Pair pair : ACTION_SLOTS) {
                if (((Integer)pair.a()).intValue() != event.getSlot()) continue;
                this.handleActionSlot(event.getItemStack(), (Integer)pair.b());
                return;
            }
        } else if (event.getContainerId() == this.wrappedScreen.getWrappedScreenInfo().containerId()) {
            if (event.getItemStack().method_7960()) {
                this.activities.remove(event.getSlot());
                contentBookScreen.reloadContentBookWidgets(true);
                return;
            }
            boolean resetPage = this.handleActivityItem(event.getItemStack(), event.getSlot());
            contentBookScreen.reloadContentBookWidgets(resetPage);
        }
    }

    @SubscribeEvent
    public void onContainerSetContent(ContainerSetContentEvent.Post event) {
        if (event.getContainerId() != this.wrappedScreen.getWrappedScreenInfo().containerId()) {
            return;
        }
        class_437 class_4372 = McUtils.screen();
        if (class_4372 instanceof WynntilsContentBookScreen) {
            WynntilsContentBookScreen contentBookScreen = (WynntilsContentBookScreen)class_4372;
            this.activities = new TreeMap<Integer, Pair<class_1799, ActivityInfo>>();
            for (int i = 0; i < event.getItems().size(); ++i) {
                class_1799 item = event.getItems().get(i);
                boolean actionSlot = false;
                for (Pair<Integer, Integer> slotPair : ACTION_SLOTS) {
                    if (slotPair.b() != i) continue;
                    this.handleActionSlot(item, slotPair.b());
                    actionSlot = true;
                    break;
                }
                if (actionSlot) continue;
                if (item.method_7960()) {
                    this.activities.remove(i);
                    continue;
                }
                this.handleActivityItem(item, i);
            }
            contentBookScreen.reloadContentBookWidgets(this.resetNextSetContent);
        }
    }

    public Map<Integer, Pair<class_1799, ActivityInfo>> getActivities() {
        return Collections.unmodifiableMap(this.activities.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b, TreeMap::new)));
    }

    public Optional<ActivityInfo> getTrackedActivityInfo() {
        return this.activities.values().stream().filter(activityInfoPair -> ((ActivityInfo)activityInfoPair.b()).trackingState() == ActivityTrackingState.TRACKED).map(Pair::b).findFirst();
    }

    public void reloadActions() {
        for (Map.Entry<Integer, class_1799> entry : this.actions.entrySet()) {
            this.handleActionSlot(entry.getValue(), entry.getKey());
        }
    }

    public void scrollUp() {
        this.pressSlot(SCROLL_UP_SLOTS.b());
    }

    public void scrollDown() {
        this.pressSlot(SCROLL_DOWN_SLOTS.b());
    }

    public void pressSlot(int slot) {
        this.pressSlot(slot, 0);
    }

    public void pressSlot(int slot, int mouseButton) {
        boolean bl = this.resetNextSetContent = mouseButton != 0 || slot != PROGRESS_SLOTS.b() && slot != DIALOGUE_HISTORY_SLOTS.b();
        if (KeyboardUtils.isShiftDown()) {
            ContainerUtils.shiftClickOnSlot(slot, this.wrappedScreen.getWrappedScreenInfo().containerId(), mouseButton, (List<class_1799>)McUtils.containerMenu().method_7602());
        } else {
            ContainerUtils.clickOnSlot(slot, this.wrappedScreen.getWrappedScreenInfo().containerId(), mouseButton, (List<class_1799>)McUtils.containerMenu().method_7602());
        }
    }

    private boolean handleActivityItem(class_1799 itemStack, int slot) {
        Optional<ActivityItem> activityItemOpt = Models.Item.asWynnItem(itemStack, ActivityItem.class);
        if (activityItemOpt.isPresent()) {
            boolean resetPage = this.activities.get(slot) == null || !this.activities.get(slot).a().method_7964().equals((Object)itemStack.method_7964());
            this.activities.put(slot, Pair.of(itemStack, activityItemOpt.get().getActivityInfo()));
            return resetPage;
        }
        if (itemStack.method_7964().getString().equals(TUTORIAL_ITEM_NAME)) {
            this.inTutorial = true;
            return false;
        }
        WynntilsMod.error("Item: " + itemStack.method_7964().getString() + " was not identified as an activity item");
        this.activities.remove(slot);
        return true;
    }

    private void handleActionSlot(class_1799 itemStack, int slot) {
        class_437 class_4372 = McUtils.screen();
        if (class_4372 instanceof WynntilsContentBookScreen) {
            WynntilsContentBookScreen contentBookScreen = (WynntilsContentBookScreen)class_4372;
            if (slot == DIALOGUE_HISTORY_SLOTS.b()) {
                contentBookScreen.setDialogueHistoryItem(itemStack, DIALOGUE_HISTORY_SLOTS.b());
                this.actions.put(DIALOGUE_HISTORY_SLOTS.b(), itemStack);
            } else if (slot == SCROLL_UP_SLOTS.b()) {
                contentBookScreen.setScrollUpItem(itemStack);
                this.actions.put(SCROLL_UP_SLOTS.b(), itemStack);
            } else if (slot == FILTER_ITEM_SLOTS.b()) {
                contentBookScreen.setFilterItem(itemStack, FILTER_ITEM_SLOTS.b());
                this.actions.put(FILTER_ITEM_SLOTS.b(), itemStack);
            } else if (slot == SORT_ITEM_SLOTS.b()) {
                contentBookScreen.setSortItem(itemStack, SORT_ITEM_SLOTS.b());
                this.actions.put(SORT_ITEM_SLOTS.b(), itemStack);
            } else if (slot == PROGRESS_SLOTS.b()) {
                contentBookScreen.setPlayerProgressItem(itemStack, PROGRESS_SLOTS.b());
                this.actions.put(PROGRESS_SLOTS.b(), itemStack);
            } else if (slot == SCROLL_DOWN_SLOTS.b()) {
                contentBookScreen.setScrollDownItem(itemStack);
                this.actions.put(SCROLL_DOWN_SLOTS.b(), itemStack);
            }
        }
    }

    @Override
    protected Pattern getReplacedScreenTitlePattern() {
        return TITLE_PATTERN;
    }

    @Override
    protected WynntilsContentBookScreen createWrappedScreen(WrappedScreenInfo wrappedScreenInfo) {
        return new WynntilsContentBookScreen(wrappedScreenInfo, this);
    }

    @Override
    protected void setWrappedScreen(WynntilsContentBookScreen wrappedScreen) {
        this.wrappedScreen = wrappedScreen;
    }

    @Override
    protected void reset() {
        this.activities = new TreeMap<Integer, Pair<class_1799, ActivityInfo>>();
        this.actions = new TreeMap<Integer, class_1799>();
        this.inTutorial = false;
    }
}

