/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.chattabs.widgets;

import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.chattabs.ChatTabEditingScreen;
import com.wynntils.services.chat.type.ChatTab;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_6382;

public class ChatTabsWidget
extends class_339 {
    private final float gridDivisions;
    private final ChatTab chatTab;
    private final class_4185 deleteButton;
    private final class_4185 moveUpButton;
    private final class_4185 moveDownButton;
    private final ChatTabEditingScreen parent;

    public ChatTabsWidget(float x, float y, int width, int height, ChatTab chatTab, float gridDivisions, ChatTabEditingScreen parent) {
        super((int)x, (int)y, width, height, (class_2561)class_2561.method_43470((String)chatTab.name()));
        this.chatTab = chatTab;
        this.gridDivisions = gridDivisions;
        this.parent = parent;
        this.deleteButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.chatTabsGui.delete").method_27692(class_124.field_1061), button -> {
            Services.ChatTab.removeTab(chatTab);
            McUtils.setScreen(ChatTabEditingScreen.create());
        }).method_46433((int)((float)this.method_46426() + (float)this.field_22758 / this.gridDivisions * 17.0f), this.method_46427() + this.field_22759 / 2 - 10).method_46437((int)((float)this.field_22758 / gridDivisions * 5.0f) - 3, 20).method_46431();
        this.moveUpButton = new class_4185.class_7840((class_2561)class_2561.method_43470((String)"\ud83e\udc1d"), button -> this.setChatTabIndex(-1)).method_46433((int)((float)this.method_46426() + (float)this.field_22758 / this.gridDivisions * 22.0f), this.method_46427() + this.field_22759 / 2 - 10).method_46437((int)((float)this.field_22758 / gridDivisions * 2.0f) - 2, 20).method_46431();
        this.moveDownButton = new class_4185.class_7840((class_2561)class_2561.method_43470((String)"\ud83e\udc1f"), button -> this.setChatTabIndex(1)).method_46433((int)((float)this.method_46426() + (float)this.field_22758 / this.gridDivisions * 24.0f), this.method_46427() + this.field_22759 / 2 - 10).method_46437((int)((float)this.field_22758 / gridDivisions * 2.0f) - 2, 20).method_46431();
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4587 poseStack = guiGraphics.method_51448();
        if (this.method_25405(mouseX, mouseY)) {
            RenderUtils.drawRect(poseStack, CommonColors.GRAY.withAlpha(70), this.method_46426(), this.method_46427(), 0.0f, this.field_22758, this.field_22759);
        }
        CustomColor nameColor = this.parent.isActiveChatTab(this.chatTab) ? CommonColors.GREEN : CommonColors.WHITE;
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(this.chatTab.name()), this.method_46426() + 4, this.method_46427() + (this.field_22759 >> 1), nameColor, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        this.deleteButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.moveUpButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.moveDownButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    private void setChatTabIndex(int offset) {
        int newIndex = MathUtils.clamp(Services.ChatTab.getTabIndex(this.chatTab) + offset, 0, Services.ChatTab.getTabCount() - 1);
        Services.ChatTab.removeTab(this.chatTab);
        Services.ChatTab.addTab(newIndex, this.chatTab);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.deleteButton.method_25402(mouseX, mouseY, button) || this.moveUpButton.method_25402(mouseX, mouseY, button) || this.moveDownButton.method_25402(mouseX, mouseY, button)) {
            this.parent.reloadChatTabsWidgets();
            return true;
        }
        McUtils.setScreen(ChatTabEditingScreen.create(this.chatTab));
        return true;
    }
}

