/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.downloads;

import com.wynntils.core.components.Managers;
import com.wynntils.core.net.DownloadDependencyGraph;
import com.wynntils.core.net.QueuedDownload;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.ui.WynncraftButtonFeature;
import com.wynntils.screens.base.WynntilsGridLayoutScreen;
import com.wynntils.screens.base.widgets.WynntilsCheckbox;
import com.wynntils.screens.downloads.widgets.DownloadWidget;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_412;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_639;
import net.minecraft.class_642;

public final class DownloadScreen
extends WynntilsGridLayoutScreen {
    private static final float SCROLL_FACTOR = 10.0f;
    private static final int WIDGET_TOP_Y = 11;
    private static final int WIDGETS_PER_PAGE = 15;
    private final class_437 previousScreen;
    private final class_642 serverData;
    private final class_2561 infoText;
    private List<DownloadWidget> downloadWidgets = new ArrayList<DownloadWidget>();
    private int scrollY;
    private int scrollOffset = 0;
    private int widgetHeight;
    private boolean draggingScroll = false;

    private DownloadScreen(class_437 previousScreen, class_642 serverData) {
        super((class_2561)class_2561.method_43471((String)"screens.wynntils.downloads.name"));
        this.previousScreen = previousScreen;
        this.serverData = serverData;
        this.infoText = class_2561.method_43471((String)"screens.wynntils.downloads.description1").method_27693("\n\n").method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.downloads.description2")).method_27693("\n\n").method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.downloads.description3")).method_27693("\n\n").method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.downloads.description4"));
    }

    public static class_437 create(class_437 previousScreen, class_642 serverData) {
        return new DownloadScreen(previousScreen, serverData);
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.downloads.back"), button -> this.method_25419()).method_46433((int)(this.dividedWidth * 5.0f), (int)(this.dividedHeight * 37.0f)).method_46437((int)(this.dividedWidth * 6.0f), 20).method_46431());
        if (this.serverData != null) {
            this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.downloads.connect"), button -> this.connectToServer()).method_46433((int)this.dividedWidth, (int)(this.dividedHeight * 31.0f)).method_46437((int)(this.dividedWidth * 14.0f), 20).method_46431());
            this.method_37063((class_364)new WynntilsCheckbox((int)(this.dividedWidth * 2.0f), (int)(this.dividedHeight * 25.0f), 20, (class_2561)class_2561.method_43471((String)"screens.wynntils.downloads.dontShowAgain"), false, (int)(this.dividedWidth * 10.0f), (c, b) -> this.toggleShowAgain((boolean)b)));
        }
        this.widgetHeight = (int)(this.dividedHeight * 3.5f);
        this.updateDownloadWidgets();
    }

    public void method_25419() {
        McUtils.setScreen(this.previousScreen);
    }

    @Override
    public void doRender(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.doRender(guiGraphics, mouseX, mouseY, partialTick);
        class_4587 poseStack = guiGraphics.method_51448();
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((class_2561)class_2561.method_43471((String)"screens.wynntils.downloads.name").method_27692(class_124.field_1073)), this.dividedWidth * 32.0f, this.dividedHeight * 6.5f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 3.0f);
        RenderUtils.enableScissor(guiGraphics, (int)(this.dividedWidth * 16.0f), (int)(this.dividedHeight * 11.0f), (int)(this.dividedWidth * 32.0f), 15 * this.widgetHeight);
        for (class_4068 class_40682 : this.downloadWidgets) {
            class_40682.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
        RenderUtils.disableScissor(guiGraphics);
        RenderUtils.drawRect(poseStack, CommonColors.LIGHT_GRAY, this.dividedWidth * 48.0f, (int)(this.dividedHeight * 11.0f), 0.0f, 6.0f, 15 * this.widgetHeight);
        this.scrollY = (int)(this.dividedHeight * 11.0f + MathUtils.map(this.scrollOffset, 0.0f, this.getMaxScrollOffset(), 0.0f, 15 * this.widgetHeight - 20));
        RenderUtils.drawRect(poseStack, this.draggingScroll ? CommonColors.BLACK : CommonColors.GRAY, this.dividedWidth * 48.0f, this.scrollY, 0.0f, 6.0f, 20.0f);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((class_2561)class_2561.method_43471((String)"screens.wynntils.downloads.info").method_27692(class_124.field_1073)), this.dividedWidth * 56.0f, this.dividedHeight * 11.0f - 18.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.NORMAL, 1.5f);
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromComponent(this.infoText), this.dividedWidth * 50.0f, this.dividedWidth * 63.0f, this.dividedHeight * 11.0f, this.dividedHeight * 11.0f + (float)(15 * this.widgetHeight), this.dividedWidth * 13.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 0.8f);
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        if (!this.draggingScroll && MathUtils.isInside((int)mouseX, (int)mouseY, (int)(this.dividedWidth * 48.0f), (int)(this.dividedWidth * 48.0f + 6.0f), this.scrollY, this.scrollY + 20)) {
            this.draggingScroll = true;
            return true;
        }
        for (class_364 listener : this.field_22786) {
            if (!listener.method_25405(mouseX, mouseY)) continue;
            return listener.method_25402(mouseX, mouseY, button);
        }
        for (DownloadWidget downloadWidget : this.downloadWidgets) {
            if (!downloadWidget.method_25405(mouseX, mouseY)) continue;
            return downloadWidget.method_25402(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingScroll) {
            int scrollAreaStartY = (int)(this.dividedHeight * 11.0f + 10.0f);
            int scrollAreaHeight = 14 * this.widgetHeight;
            int newOffset = Math.round(MathUtils.map((float)mouseY, scrollAreaStartY, scrollAreaStartY + scrollAreaHeight, 0.0f, this.getMaxScrollOffset()));
            newOffset = Math.max(0, Math.min(newOffset, this.getMaxScrollOffset()));
            this.scroll(newOffset);
            return true;
        }
        for (class_364 listener : this.field_22786) {
            if (!listener.method_25405(mouseX, mouseY)) continue;
            return listener.method_25403(mouseX, mouseY, button, dragX, dragY);
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.draggingScroll = false;
        for (class_364 listener : this.field_22786) {
            if (!listener.method_25405(mouseX, mouseY)) continue;
            return listener.method_25406(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        int scrollAmount = (int)(-deltaY * 10.0);
        int newOffset = Math.max(0, Math.min(this.scrollOffset + scrollAmount, this.getMaxScrollOffset()));
        this.scroll(newOffset);
        return true;
    }

    private void connectToServer() {
        class_412.method_36877((class_437)this, (class_310)McUtils.mc(), (class_639)class_639.method_2950((String)this.serverData.field_3761), (class_642)this.serverData, (boolean)false, null);
    }

    private void toggleShowAgain(boolean show) {
        Managers.Feature.getFeatureInstance(WynncraftButtonFeature.class).ignoreFailedDownloads.store(show);
    }

    private void scroll(int newOffset) {
        this.scrollOffset = newOffset;
        for (DownloadWidget widget : this.downloadWidgets) {
            int newY = (int)(this.dividedHeight * 11.0f + (float)(this.downloadWidgets.indexOf((Object)widget) * this.widgetHeight) - (float)this.scrollOffset);
            widget.method_46419(newY);
            widget.field_22764 = (float)newY >= this.dividedHeight * 11.0f - (float)this.widgetHeight && (float)newY <= this.dividedHeight * 11.0f + (float)(16 * this.widgetHeight);
        }
    }

    private void updateDownloadWidgets() {
        for (class_339 class_3392 : this.downloadWidgets) {
            this.method_37066((class_364)class_3392);
        }
        this.downloadWidgets = new ArrayList<DownloadWidget>();
        int y = (int)(this.dividedHeight * 11.0f);
        for (QueuedDownload download : Managers.Download.registeredDownloads()) {
            DownloadDependencyGraph.DownloadDependencyGraphState downloadState = Managers.Download.graphState();
            this.downloadWidgets.add(new DownloadWidget((int)(this.dividedWidth * 16.0f), y, (int)(this.dividedWidth * 32.0f), this.widgetHeight, download));
            y += this.widgetHeight;
        }
        this.scroll(this.scrollOffset);
    }

    private int getMaxScrollOffset() {
        return (this.downloadWidgets.size() - 15) * this.widgetHeight;
    }
}

