/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides;

import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.WynntilsListScreen;
import com.wynntils.screens.base.widgets.BackButton;
import com.wynntils.screens.base.widgets.PageSelectorButton;
import com.wynntils.screens.guides.aspect.WynntilsAspectGuideScreen;
import com.wynntils.screens.guides.charm.WynntilsCharmGuideScreen;
import com.wynntils.screens.guides.emeraldpouch.WynntilsEmeraldPouchGuideScreen;
import com.wynntils.screens.guides.gear.WynntilsItemGuideScreen;
import com.wynntils.screens.guides.ingredient.WynntilsIngredientGuideScreen;
import com.wynntils.screens.guides.powder.WynntilsPowderGuideScreen;
import com.wynntils.screens.guides.tome.WynntilsTomeGuideScreen;
import com.wynntils.screens.guides.widgets.ExportButton;
import com.wynntils.screens.guides.widgets.GuidesButton;
import com.wynntils.screens.guides.widgets.ImportButton;
import com.wynntils.screens.wynntilsmenu.WynntilsMenuScreen;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.Texture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public final class WynntilsGuidesListScreen
extends WynntilsListScreen<class_437, GuidesButton> {
    private static final List<class_437> GUIDES = List.of(WynntilsItemGuideScreen.create(), WynntilsIngredientGuideScreen.create(), WynntilsTomeGuideScreen.create(), WynntilsCharmGuideScreen.create(), WynntilsAspectGuideScreen.create(), WynntilsEmeraldPouchGuideScreen.create(), WynntilsPowderGuideScreen.create());

    private WynntilsGuidesListScreen() {
        super((class_2561)class_2561.method_43471((String)"screens.wynntils.wynntilsGuides.name"));
    }

    public static class_437 create() {
        return new WynntilsGuidesListScreen();
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.method_37063((class_364)new BackButton((int)(((float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 16.0f) / 2.0f) + this.offsetX, 65 + this.offsetY, Texture.BACK_ARROW_OFFSET.width() / 2, Texture.BACK_ARROW_OFFSET.height(), WynntilsMenuScreen.create()));
        this.method_37063((class_364)new ImportButton(Texture.CONTENT_BOOK_BACKGROUND.width() - 21 + this.offsetX, 11 + this.offsetY, (int)((float)Texture.ADD_ICON.width() / 1.5f), (int)((float)Texture.ADD_ICON.height() / 1.5f), this::importFavorites));
        this.method_37063((class_364)new ExportButton(Texture.CONTENT_BOOK_BACKGROUND.width() - 21 + this.offsetX, 11 + (int)((float)Texture.ADD_ICON.height() / 1.5f) + this.offsetY, (int)((float)Texture.SHARE_ICON.width() / 1.5f), (int)((float)Texture.SHARE_ICON.height() / 1.5f), this::exportFavorites));
        this.method_37063((class_364)new PageSelectorButton((int)((float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f + 50.0f - (float)Texture.FORWARD_ARROW_OFFSET.width() / 2.0f + (float)this.offsetX), Texture.CONTENT_BOOK_BACKGROUND.height() - 25 + this.offsetY, Texture.FORWARD_ARROW_OFFSET.width() / 2, Texture.FORWARD_ARROW_OFFSET.height(), false, this));
        this.method_37063((class_364)new PageSelectorButton(Texture.CONTENT_BOOK_BACKGROUND.width() - 50 + this.offsetX, Texture.CONTENT_BOOK_BACKGROUND.height() - 25 + this.offsetY, Texture.FORWARD_ARROW_OFFSET.width() / 2, Texture.FORWARD_ARROW_OFFSET.height(), true, this));
    }

    private void importFavorites() {
        String clipboard = McUtils.mc().field_1774.method_1460();
        if (clipboard == null || !clipboard.startsWith("wynntilsFavorites,")) {
            McUtils.sendErrorToClient(class_1074.method_4662((String)"screens.wynntils.wynntilsGuides.invalidClipboard", (Object[])new Object[0]));
        }
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(clipboard.split(",")));
        names.removeFirst();
        names.forEach(name -> {
            if (name.isBlank()) {
                return;
            }
            Services.Favorites.addFavorite((String)name);
        });
        McUtils.sendMessageToClient((class_2561)class_2561.method_43469((String)"screens.wynntils.wynntilsGuides.importedFavorites", (Object[])new Object[]{names.size()}).method_27692(class_124.field_1060));
    }

    private void exportFavorites() {
        McUtils.mc().field_1774.method_1455("wynntilsFavorites," + String.join((CharSequence)",", Services.Favorites.getFavoriteItems()));
        McUtils.sendMessageToClient((class_2561)class_2561.method_43469((String)"screens.wynntils.wynntilsGuides.exportedFavorites", (Object[])new Object[]{Services.Favorites.getFavoriteItems().size()}).method_27692(class_124.field_1060));
    }

    @Override
    public void doRender(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4587 poseStack = guiGraphics.method_51448();
        this.renderBackgroundTexture(poseStack);
        this.renderTitle(poseStack, class_1074.method_4662((String)"screens.wynntils.wynntilsGuides.name", (Object[])new Object[0]));
        this.renderVersion(poseStack);
        this.renderWidgets(guiGraphics, mouseX, mouseY, partialTick);
        this.renderDescription(poseStack, class_1074.method_4662((String)"screens.wynntils.wynntilsGuides.screenDescription", (Object[])new Object[0]), "");
        this.renderPageInfo(poseStack, this.currentPage + 1, this.maxPage + 1);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected GuidesButton getButtonFromElement(int i) {
        int offset = i % this.getElementsPerPage();
        return new GuidesButton((int)((float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f + 15.0f + (float)this.offsetX), offset * 13 + 25 + this.offsetY, Texture.CONTENT_BOOK_BACKGROUND.width() / 2 - 37, 9, (class_437)this.elements.get(i), this.offsetX, this.offsetY);
    }

    @Override
    protected void reloadElementsList(String searchTerm) {
        this.elements.addAll(GUIDES.stream().filter(screen -> StringUtils.partialMatch(StyledText.fromComponent(screen.method_25440()).getStringWithoutFormatting(), searchTerm)).toList());
    }
}

