/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.ingredient;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Services;
import com.wynntils.core.net.UrlId;
import com.wynntils.models.ingredients.type.IngredientTierFormatting;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.guides.ingredient.GuideIngredientItemStack;
import com.wynntils.screens.guides.ingredient.WynntilsIngredientGuideScreen;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class GuideIngredientItemStackButton
extends WynntilsButton {
    private final GuideIngredientItemStack itemStack;

    public GuideIngredientItemStackButton(int x, int y, int width, int height, GuideIngredientItemStack itemStack, WynntilsIngredientGuideScreen screen) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)"Guide IngredientItemStack Button"));
        this.itemStack = itemStack;
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4587 poseStack = guiGraphics.method_51448();
        CustomColor color = this.getHighlightColor(this.itemStack.getIngredientInfo().tier());
        RenderUtils.drawTexturedRectWithColor(poseStack, Texture.HIGHLIGHT.resource(), color.withAlpha(1.0f), this.method_46426() - 1, this.method_46427() - 1, 0.0f, 18.0f, 18.0f, Texture.HIGHLIGHT.width(), Texture.HIGHLIGHT.height());
        RenderUtils.renderItem(guiGraphics, this.itemStack, this.method_46426(), this.method_46427());
        String unformattedName = this.itemStack.getIngredientInfo().name();
        if (Services.Favorites.isFavorite(unformattedName)) {
            RenderUtils.drawScalingTexturedRect(poseStack, Texture.FAVORITE_ICON.resource(), this.method_46426() + 12, this.method_46427() - 4, 200.0f, 9.0f, 9.0f, Texture.FAVORITE_ICON.width(), Texture.FAVORITE_ICON.height());
        }
    }

    private CustomColor getHighlightColor(int tier) {
        CustomColor highlightColor = IngredientTierFormatting.fromTierNum(tier).getHighlightColor();
        if (highlightColor == null) {
            WynntilsMod.warn("Invalid ingredient tier for: " + this.itemStack.getIngredientInfo().name() + ": " + tier);
            return CustomColor.NONE;
        }
        return highlightColor;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!KeyboardUtils.isKeyDown(340) && !KeyboardUtils.isKeyDown(344)) {
            return false;
        }
        String unformattedName = this.itemStack.getIngredientInfo().name();
        if (button == 1) {
            Managers.Net.openLink(UrlId.LINK_WYNNCRAFT_ITEM_LOOKUP, Map.of("itemname", unformattedName));
            return true;
        }
        if (button == 0) {
            Services.Favorites.toggleFavorite(unformattedName);
        }
        return true;
    }

    public void method_25306() {
    }

    public GuideIngredientItemStack getItemStack() {
        return this.itemStack;
    }
}

