/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.ingredient;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.widgets.ItemSearchWidget;
import com.wynntils.screens.base.widgets.SearchWidget;
import com.wynntils.screens.guides.WynntilsGuideScreen;
import com.wynntils.screens.guides.ingredient.GuideIngredientItemStack;
import com.wynntils.screens.guides.ingredient.GuideIngredientItemStackButton;
import com.wynntils.screens.guides.widgets.filters.GuideFilterWidget;
import com.wynntils.screens.guides.widgets.filters.ProfessionTypeFilterWidget;
import com.wynntils.screens.guides.widgets.filters.QualityTierFilterWidget;
import com.wynntils.screens.guides.widgets.sorts.GuideSortButton;
import com.wynntils.services.itemfilter.statproviders.QualityTierStatProvider;
import com.wynntils.services.itemfilter.type.ItemProviderType;
import com.wynntils.services.itemfilter.type.ItemSearchQuery;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public final class WynntilsIngredientGuideScreen
extends WynntilsGuideScreen<GuideIngredientItemStack, GuideIngredientItemStackButton> {
    private static final int ELEMENTS_COLUMNS = 7;
    private static final int ELEMENT_ROWS = 7;
    private List<GuideIngredientItemStack> allIngredientItems = List.of();

    private WynntilsIngredientGuideScreen() {
        super((class_2561)class_2561.method_43471((String)"screens.wynntils.wynntilsGuides.ingredientGuide.name"), List.of(ItemProviderType.GENERIC, ItemProviderType.INGREDIENT, ItemProviderType.PROFESSION));
    }

    public static class_437 create() {
        return new WynntilsIngredientGuideScreen();
    }

    @Override
    protected void doInit() {
        super.doInit();
        SearchWidget searchWidget = this.searchWidget;
        if (searchWidget instanceof ItemSearchWidget) {
            ItemSearchWidget itemSearchWidget = (ItemSearchWidget)searchWidget;
            this.guideFilterWidgets.add((GuideFilterWidget)this.method_37063((class_364)new ProfessionTypeFilterWidget(47 + this.offsetX, 81 + this.offsetY, this, itemSearchWidget.getSearchQuery())));
            this.guideFilterWidgets.add((GuideFilterWidget)this.method_37063((class_364)new QualityTierFilterWidget(47 + this.offsetX, 121 + this.offsetY, this, itemSearchWidget.getSearchQuery())));
            this.guideSortWidget.setSecondarySortButton(new GuideSortButton(itemSearchWidget.getSearchQuery(), this, QualityTierStatProvider.class));
        } else {
            WynntilsMod.error("WynntilsIngredientGuideScreen's SearchWidget is not an ItemSearchWidget");
        }
    }

    @Override
    public void doRender(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4587 poseStack = guiGraphics.method_51448();
        this.renderBackgroundTexture(poseStack);
        this.renderTitle(poseStack, class_1074.method_4662((String)"screens.wynntils.wynntilsGuides.ingredientGuide.name", (Object[])new Object[0]));
        this.renderVersion(poseStack);
        this.renderItemsHeader(poseStack);
        this.renderWidgets(guiGraphics, mouseX, mouseY, partialTick);
        this.renderPageInfo(poseStack, this.currentPage + 1, this.maxPage + 1);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected void renderTitle(class_4587 poseStack, String titleString) {
        int txWidth = Texture.CONTENT_BOOK_TITLE.width();
        int txHeight = Texture.CONTENT_BOOK_TITLE.height();
        RenderUtils.drawScalingTexturedRect(poseStack, Texture.CONTENT_BOOK_TITLE.resource(), this.offsetX, 30 + this.offsetY, 0.0f, txWidth, txHeight, txWidth, txHeight);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(titleString), (float)(10 + this.offsetX), (float)(36 + this.offsetY), CommonColors.YELLOW, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 1.8f);
    }

    @Override
    protected void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        class_4068 class_40682 = this.hovered;
        if (class_40682 instanceof GuideIngredientItemStackButton) {
            GuideIngredientItemStackButton guideGearItemStack = (GuideIngredientItemStackButton)class_40682;
            guiGraphics.method_51446(FontRenderer.getInstance().getFont(), (class_1799)guideGearItemStack.getItemStack(), mouseX, mouseY);
        }
        super.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderItemsHeader(class_4587 poseStack) {
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.wynntilsGuides.itemGuide.available", (Object[])new Object[0])), (float)Texture.CONTENT_BOOK_BACKGROUND.width() * 0.75f + (float)this.offsetX, 30 + this.offsetY, CommonColors.BLACK, HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.NONE);
    }

    @Override
    protected GuideIngredientItemStackButton getButtonFromElement(int i) {
        int xOffset = i % 7 * 20;
        int yOffset = i % this.getElementsPerPage() / 7 * 20;
        return new GuideIngredientItemStackButton((int)((float)xOffset + (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f + 13.0f + (float)this.offsetX), yOffset + 43 + this.offsetY, 18, 18, (GuideIngredientItemStack)((Object)this.elements.get(i)), this);
    }

    @Override
    protected void reloadElementsList(ItemSearchQuery searchQuery) {
        this.elements.addAll(Services.ItemFilter.filterAndSort(searchQuery, this.getAllIngredientItems()));
        this.guideFilterWidgets.forEach(filter -> filter.updateFromQuery(searchQuery));
        if (this.guideSortWidget == null) {
            return;
        }
        this.guideSortWidget.updateFromQuery(searchQuery);
    }

    private List<GuideIngredientItemStack> getAllIngredientItems() {
        if (this.allIngredientItems.isEmpty()) {
            this.allIngredientItems = Models.Ingredient.getAllIngredientInfos().map(GuideIngredientItemStack::new).toList();
        }
        return this.allIngredientItems;
    }

    @Override
    protected int getElementsPerPage() {
        return 49;
    }
}

