/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.powder;

import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.models.elements.type.Powder;
import com.wynntils.models.elements.type.PowderTierInfo;
import com.wynntils.models.items.items.game.PowderItem;
import com.wynntils.screens.guides.GuideItemStack;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;

public final class GuidePowderItemStack
extends GuideItemStack {
    private final int tier;
    private final Powder element;
    private final PowderTierInfo powderTierInfo;
    private final List<class_2561> generatedTooltip;

    public GuidePowderItemStack(PowderTierInfo powderTierInfo) {
        super(GuidePowderItemStack.getItemStack(powderTierInfo), new PowderItem(powderTierInfo), powderTierInfo.element().getName() + " Powder");
        this.element = powderTierInfo.element();
        this.tier = powderTierInfo.tier();
        this.powderTierInfo = powderTierInfo;
        this.generatedTooltip = this.generateLore();
    }

    public class_2561 method_7964() {
        return class_2561.method_43473().method_27696(class_2583.field_24360.method_10977(this.element.getLightColor())).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.element.getSymbol())).method_27696(class_2583.field_24360.method_27704(class_2960.method_60656((String)"common")))).method_10852((class_2561)class_2561.method_43470((String)(" " + this.element.getName() + " Powder " + MathUtils.toRoman(this.tier))));
    }

    public List<class_2561> method_7950(class_1792.class_9635 context, class_1657 player, class_1836 flag) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        tooltip.add(this.method_7964());
        tooltip.addAll(this.generatedTooltip);
        tooltip.add((class_2561)class_2561.method_43473());
        if (Services.Favorites.isFavorite(this)) {
            tooltip.add((class_2561)class_2561.method_43471((String)"screens.wynntils.wynntilsGuides.itemGuide.unfavorite").method_27692(class_124.field_1054));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"screens.wynntils.wynntilsGuides.itemGuide.favorite").method_27692(class_124.field_1060));
        }
        return tooltip;
    }

    private List<class_2561> generateLore() {
        ArrayList<class_2561> itemLore = new ArrayList<class_2561>();
        String tierStringBuilder = String.valueOf(this.element.getDarkColor()) + "\u25a0".repeat(Math.max(0, this.tier)) + String.valueOf(class_124.field_1063) + "\u25a0".repeat(Math.max(0, 6 - this.tier));
        String name = this.element.getName();
        Powder opposingElement = Models.Element.getOpposingElement(this.element);
        itemLore.add((class_2561)class_2561.method_43470((String)("Tier " + this.tier + " [")).method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)tierStringBuilder)).method_10852((class_2561)class_2561.method_43470((String)"]").method_27692(class_124.field_1080)));
        itemLore.add((class_2561)class_2561.method_43473());
        itemLore.add((class_2561)class_2561.method_43470((String)"Effect on Weapons:").method_27692(this.element.getDarkColor()));
        itemLore.add((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)(String.valueOf(this.element.getDarkColor()) + "\u2014 " + String.valueOf(class_124.field_1080) + "+" + this.powderTierInfo.min() + "-" + this.powderTierInfo.max() + " " + String.valueOf(this.element.getLightColor())))).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.element.getSymbol())).method_27696(class_2583.field_24360.method_27704(class_2960.method_60656((String)"common")).method_10977(this.element.getLightColor()))).method_10852((class_2561)class_2561.method_43470((String)(String.valueOf(this.element.getLightColor()) + " " + name + " " + String.valueOf(class_124.field_1080) + "Damage"))));
        itemLore.add((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)(String.valueOf(this.element.getDarkColor()) + "\u2014 " + String.valueOf(class_124.field_1080) + "+" + this.powderTierInfo.convertedFromNeutral() + "% " + String.valueOf(class_124.field_1065) + "\u2723 Neutral" + String.valueOf(class_124.field_1080) + " to " + String.valueOf(this.element.getLightColor())))).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.element.getSymbol())).method_27696(class_2583.field_24360.method_27704(class_2960.method_60656((String)"common")).method_10977(this.element.getLightColor()))).method_10852((class_2561)class_2561.method_43470((String)(String.valueOf(this.element.getLightColor()) + " " + name))));
        itemLore.add((class_2561)class_2561.method_43473());
        itemLore.add((class_2561)class_2561.method_43470((String)"Effect on Armour:").method_27692(this.element.getDarkColor()));
        itemLore.add((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)(String.valueOf(this.element.getDarkColor()) + "\u2014 " + String.valueOf(class_124.field_1080) + "+" + this.powderTierInfo.addedDefence() + " " + String.valueOf(this.element.getLightColor())))).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.element.getSymbol())).method_27696(class_2583.field_24360.method_27704(class_2960.method_60656((String)"common")).method_10977(this.element.getLightColor()))).method_10852((class_2561)class_2561.method_43470((String)(String.valueOf(this.element.getLightColor()) + " " + name + " " + String.valueOf(class_124.field_1080) + "Defence"))));
        itemLore.add((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)(String.valueOf(this.element.getDarkColor()) + "\u2014 " + String.valueOf(class_124.field_1080) + "-" + this.powderTierInfo.removedDefence() + " " + String.valueOf(opposingElement.getLightColor())))).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(opposingElement.getSymbol())).method_27696(class_2583.field_24360.method_27704(class_2960.method_60656((String)"common")).method_10977(opposingElement.getLightColor()))).method_10852((class_2561)class_2561.method_43470((String)(String.valueOf(opposingElement.getLightColor()) + " " + StringUtils.capitalizeFirst(opposingElement.name().toLowerCase(Locale.ROOT)) + " " + String.valueOf(class_124.field_1080) + "Defence"))));
        itemLore.add((class_2561)class_2561.method_43473());
        itemLore.add((class_2561)class_2561.method_43470((String)"Add this powder to your items by visiting a Powder Master or use it as an ingredient when crafting.").method_27692(class_124.field_1063));
        if (this.tier > 3) {
            itemLore.add((class_2561)class_2561.method_43473());
            itemLore.add((class_2561)class_2561.method_43470((String)"Adding 2 powders of tier 4-6 at the powder master will unlock a special attack/effect.").method_27692(class_124.field_1063));
        }
        return itemLore;
    }

    private static class_1799 getItemStack(PowderTierInfo profile) {
        if (profile.tier() <= 3) {
            return new class_1799((class_1935)profile.element().getLowTierItem());
        }
        return new class_1799((class_1935)profile.element().getHighTierItem());
    }

    public int getTier() {
        return this.tier;
    }

    public Powder getElement() {
        return this.element;
    }
}

