/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.widgets.sorts;

import com.google.common.collect.Lists;
import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.guides.WynntilsGuideScreen;
import com.wynntils.services.itemfilter.type.ItemSearchQuery;
import com.wynntils.services.itemfilter.type.ItemStatProvider;
import com.wynntils.services.itemfilter.type.SortDirection;
import com.wynntils.services.itemfilter.type.SortInfo;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6382;

public class GuideSortButton
extends class_339 {
    private final WynntilsGuideScreen guideScreen;
    private final ItemStatProvider<?> provider;
    private SortDirection sortDirection = null;

    public GuideSortButton(ItemSearchQuery searchQuery, WynntilsGuideScreen guideScreen, Class<?> clazz) {
        super(0, 0, 64, 16, (class_2561)class_2561.method_43473());
        this.guideScreen = guideScreen;
        this.provider = Services.ItemFilter.getItemStatProviders().stream().filter(clazz::isInstance).findFirst().orElseThrow(() -> new IllegalStateException("No provider of type " + clazz.getSimpleName()));
        this.updateFromQuery(searchQuery);
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderUtils.drawRect(guiGraphics.method_51448(), CommonColors.BLACK.withAlpha(this.field_22762 ? 0.7f : 0.5f), this.method_46426(), this.method_46427(), 0.0f, this.method_25368(), this.method_25364());
        FontRenderer.getInstance().renderText(guiGraphics.method_51448(), StyledText.fromString(this.getSortName()), (float)this.method_46426() + (float)this.method_25368() / 2.0f, (float)this.method_46427() + (float)this.method_25364() / 2.0f, this.sortDirection == null ? CommonColors.WHITE : CommonColors.ORANGE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        if (this.sortDirection != null) {
            FontRenderer.getInstance().renderText(guiGraphics.method_51448(), StyledText.fromString(this.sortDirection == SortDirection.ASCENDING ? "\u25b2" : "\u25bc"), this.method_46426() + this.method_25368(), this.method_46427() - 2, CommonColors.YELLOW, HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.OUTLINE);
        }
        if (this.field_22762) {
            McUtils.screen().method_47414(Lists.transform(ComponentUtils.wrapTooltips(List.of(class_2561.method_43469((String)"screens.wynntils.wynntilsGuides.sortWidget.tooltip", (Object[])new Object[]{this.getSortName()})), 200), class_2561::method_30937));
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 || button == 1) {
            if (this.sortDirection == SortDirection.DESCENDING) {
                this.sortDirection = SortDirection.ASCENDING;
            } else if (this.sortDirection != SortDirection.DESCENDING) {
                this.sortDirection = SortDirection.DESCENDING;
            }
        } else if (button == 2) {
            this.sortDirection = null;
        }
        this.guideScreen.updateSearchFromQuickFilters();
        return super.method_25402(mouseX, mouseY, button);
    }

    public final void updateFromQuery(ItemSearchQuery searchQuery) {
        Optional<SortInfo> sortInfoOptional = searchQuery.sorts().stream().filter(sortInfo -> sortInfo.provider() == this.provider).findFirst();
        this.sortDirection = sortInfoOptional.map(SortInfo::direction).orElse(null);
    }

    protected final SortInfo getSortInfo() {
        if (this.sortDirection == null) {
            return null;
        }
        return new SortInfo(this.sortDirection, this.provider);
    }

    private String getSortName() {
        return this.provider.getDisplayName();
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }
}

