/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guildlog.widgets;

import com.wynntils.core.text.StyledText;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6382;

public class LogEntryWidget
extends class_339 {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().appendLocalized(FormatStyle.SHORT, FormatStyle.SHORT).appendLiteral(' ').appendPattern("z").toFormatter().withLocale(Locale.getDefault());
    private final List<StyledText> logLines;
    private final StyledText timeText;

    public LogEntryWidget(int x, int y, int height, List<StyledText> logLines, Instant dateTime) {
        super(x, y, Texture.LOG_ENTRY_MIDDLE.width(), height, (class_2561)class_2561.method_43470((String)"Log Entry Widget"));
        this.logLines = logLines;
        ZonedDateTime logZonedDateTime = dateTime.atZone(ZoneId.systemDefault());
        this.timeText = StyledText.fromString(logZonedDateTime.format(DATE_TIME_FORMATTER));
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        int renderY = this.method_46427();
        RenderUtils.drawTexturedRect(guiGraphics.method_51448(), Texture.LOG_ENTRY_TOP, this.method_46426(), renderY);
        renderY += Texture.LOG_ENTRY_BOTTOM.height();
        for (StyledText logLine : this.logLines) {
            RenderUtils.drawTexturedRect(guiGraphics.method_51448(), Texture.LOG_ENTRY_MIDDLE, this.method_46426(), renderY);
            FontRenderer.getInstance().renderText(guiGraphics.method_51448(), logLine, this.method_46426() + 6, renderY, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL);
            renderY += Texture.LOG_ENTRY_MIDDLE.height();
        }
        RenderUtils.drawTexturedRect(guiGraphics.method_51448(), Texture.LOG_ENTRY_MIDDLE, this.method_46426(), renderY);
        FontRenderer.getInstance().renderText(guiGraphics.method_51448(), this.timeText, this.method_46426() + this.field_22758 - 6, renderY + 1, CommonColors.LIGHT_GRAY, HorizontalAlignment.RIGHT, VerticalAlignment.TOP, TextShadow.NORMAL);
        RenderUtils.drawTexturedRect(guiGraphics.method_51448(), Texture.LOG_ENTRY_BOTTOM, this.method_46426(), renderY += Texture.LOG_ENTRY_MIDDLE.height());
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }
}

