/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemfilter.widgets;

import com.wynntils.core.text.StyledText;
import com.wynntils.screens.itemfilter.ItemFilterScreen;
import com.wynntils.screens.itemfilter.type.NumericFilterWidgetFactory;
import com.wynntils.screens.itemfilter.widgets.AnyFilterWidget;
import com.wynntils.screens.itemfilter.widgets.BooleanFilterWidget;
import com.wynntils.screens.itemfilter.widgets.GeneralFilterWidget;
import com.wynntils.screens.itemfilter.widgets.SelectionFilterWidget;
import com.wynntils.screens.itemfilter.widgets.StringFilterWidget;
import com.wynntils.services.itemfilter.filters.AnyStatFilters;
import com.wynntils.services.itemfilter.type.ItemStatProvider;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import com.wynntils.utils.EnumUtils;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_6382;

public class ProviderFilterListWidget
extends class_339 {
    private static final float SCROLL_FACTOR = 10.0f;
    private static final int MAX_WIDGETS_PER_PAGE = 5;
    private static final int MAX_SELECTION_WIDGETS_PER_PAGE = 6;
    private static final int SCROLLBAR_HEIGHT = 20;
    private static final int SCROLLBAR_WIDTH = 6;
    private static final int SCROLLBAR_RENDER_X = 184;
    private final ItemFilterScreen filterScreen;
    private final ItemStatProvider<?> provider;
    private boolean draggingScroll = false;
    private class_4185 addNumericFilterButton;
    private class_4185 addStringFilterButton;
    private class_4185 numericChoiceButton;
    private int scrollOffset = 0;
    private int scrollRenderY;
    private List<GeneralFilterWidget> widgets = new ArrayList<GeneralFilterWidget>();
    private List<StatProviderAndFilterPair> filterPairs;
    private NumericType numericChoice = NumericType.SINGLE;

    public ProviderFilterListWidget(int x, int y, ItemFilterScreen filterScreen, ItemStatProvider<?> provider, List<StatProviderAndFilterPair> filterPairs) {
        super(x, y, 195, 145, (class_2561)class_2561.method_43470((String)"Provider Filter List Widget"));
        this.filterScreen = filterScreen;
        this.provider = provider;
        this.filterPairs = new ArrayList<StatProviderAndFilterPair>(filterPairs);
        if (provider.getType().equals(String.class) && provider.getValidInputs().isEmpty()) {
            this.addStringFilterButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.itemFilter.addNewFilter"), button -> {
                int renderY = this.widgets.isEmpty() ? this.method_46427() + 2 : this.widgets.getLast().method_46427() + 24;
                this.widgets.add(new StringFilterWidget(this.method_46426() + 5, renderY, 175, 20, null, this, filterScreen));
                if (this.isScrollable()) {
                    this.scroll(this.scrollOffset + 24);
                }
                this.addStringFilterButton.field_22763 = false;
            }).method_46433(this.method_46426() + 55, this.method_46427() + 125).method_46437(85, 20).method_46431();
        } else if (!provider.getType().equals(Boolean.class) && !provider.getType().equals(String.class)) {
            this.numericChoiceButton = new class_4185.class_7840((class_2561)class_2561.method_43470((String)EnumUtils.toNiceString(this.numericChoice)), null).method_46433(this.method_46426(), this.method_46427() + 125).method_46437(85, 20).method_46431();
            this.addNumericFilterButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.itemFilter.addNewFilter"), button -> {
                int renderY = this.widgets.isEmpty() ? this.method_46427() + 2 : this.widgets.getLast().method_46427() + 24;
                GeneralFilterWidget filterWidget = this.getNumericFilterWidget(renderY);
                if (filterWidget == null) {
                    return;
                }
                this.widgets.add(filterWidget);
                if (this.isScrollable()) {
                    this.scroll(this.scrollOffset + 24);
                }
                this.addNumericFilterButton.field_22763 = false;
            }).method_46433(this.method_46426() + 95, this.method_46427() + 125).method_46437(85, 20).method_46431();
        }
        this.createWidgets();
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.addStringFilterButton != null) {
            this.addStringFilterButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        } else if (this.addNumericFilterButton != null) {
            this.addNumericFilterButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            this.numericChoiceButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (this.widgets.isEmpty()) {
            FontRenderer.getInstance().renderAlignedTextInBox(guiGraphics.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_43471((String)"screens.wynntils.itemFilter.noFilters")), this.method_46426(), this.method_46426() + this.method_25368(), this.method_46427(), (float)this.method_46427() + this.getScrollableArea(), 180.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
            return;
        }
        RenderUtils.enableScissor(guiGraphics, this.method_46426(), this.method_46427() - 2, this.method_25368(), (int)(this.getScrollbarHeight() + 5.0f));
        for (GeneralFilterWidget widget : this.widgets) {
            widget.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
        RenderUtils.disableScissor(guiGraphics);
        if (this.isScrollable()) {
            this.renderScrollBar(guiGraphics.method_51448());
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.addStringFilterButton != null && this.addStringFilterButton.method_25405(mouseX, mouseY)) {
            return this.addStringFilterButton.method_25402(mouseX, mouseY, button);
        }
        if (this.addNumericFilterButton != null && this.addNumericFilterButton.method_25405(mouseX, mouseY)) {
            return this.addNumericFilterButton.method_25402(mouseX, mouseY, button);
        }
        if (this.numericChoiceButton != null && this.numericChoiceButton.method_25405(mouseX, mouseY)) {
            if (button == 0) {
                this.cycleNumericChoice(1);
                return true;
            }
            if (button == 1) {
                this.cycleNumericChoice(-1);
                return true;
            }
            return false;
        }
        if (mouseY > (double)(this.method_46427() + 2) && mouseY < (double)((float)(this.method_46427() + 2) + this.getScrollbarHeight())) {
            for (GeneralFilterWidget widget : this.widgets) {
                if (!widget.method_25405(mouseX, mouseY)) continue;
                return widget.method_25402(mouseX, mouseY, button);
            }
        }
        if (!this.draggingScroll && this.isScrollable() && MathUtils.isInside((int)mouseX, (int)mouseY, this.method_46426() + 184, this.method_46426() + 184 + 6, this.scrollRenderY, this.scrollRenderY + 20)) {
            this.draggingScroll = true;
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingScroll) {
            int scrollAreaStartY = this.method_46427();
            int newOffset = Math.round(MathUtils.map((float)mouseY, scrollAreaStartY, (float)scrollAreaStartY + this.getScrollbarHeight(), 0.0f, this.getMaxScrollOffset()));
            newOffset = Math.max(0, Math.min(newOffset, this.getMaxScrollOffset()));
            this.scroll(newOffset);
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.draggingScroll = false;
        if (mouseY > (double)(this.method_46427() + 2) && mouseY < (double)((float)(this.method_46427() + 2) + this.getScrollbarHeight())) {
            for (GeneralFilterWidget widget : this.widgets) {
                if (!widget.method_25405(mouseX, mouseY)) continue;
                return widget.method_25406(mouseX, mouseY, button);
            }
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.isScrollable()) {
            int scrollAmount = (int)(-deltaY * 10.0);
            int newOffset = Math.max(0, Math.min(this.scrollOffset + scrollAmount, this.getMaxScrollOffset()));
            this.scroll(newOffset);
            return true;
        }
        return false;
    }

    public void createWidgets() {
        this.widgets = new ArrayList<GeneralFilterWidget>();
        if (!this.filterPairs.isEmpty()) {
            for (StatProviderAndFilterPair filterPair : this.filterPairs) {
                if (!(filterPair.statFilter() instanceof AnyStatFilters.AbstractAnyStatFilter)) continue;
                this.widgets.add(new AnyFilterWidget(this.method_46426(), this.method_46427(), this));
                if (this.addStringFilterButton != null) {
                    this.addStringFilterButton.field_22764 = false;
                } else if (this.addNumericFilterButton != null) {
                    this.addNumericFilterButton.field_22764 = false;
                    this.numericChoiceButton.field_22764 = false;
                }
                return;
            }
        }
        if (this.provider.getType().equals(Boolean.class)) {
            if (this.filterPairs.isEmpty()) {
                this.widgets.add(new BooleanFilterWidget(this.method_46426(), this.method_46427(), null, this));
            } else {
                this.widgets.add(new BooleanFilterWidget(this.method_46426(), this.method_46427(), this.filterPairs.getFirst(), this));
            }
            return;
        }
        if (!this.provider.getValidInputs().isEmpty()) {
            int renderY = this.method_46427() + 2;
            for (int i = 0; i < this.provider.getValidInputs().size(); ++i) {
                String valueName = this.provider.getValidInputs().get(i);
                Optional<StatProviderAndFilterPair> filterPair = this.filterPairs.stream().filter(filter -> filter.statFilter().asString().equalsIgnoreCase(valueName)).findFirst();
                SelectionFilterWidget filterWidget = new SelectionFilterWidget(this.method_46426() + 5, renderY, 150, 20, valueName, filterPair, this);
                this.widgets.add(filterWidget);
                renderY += 24;
            }
            this.scroll(this.scrollOffset);
            return;
        }
        int renderY = this.method_46427() + 2;
        for (StatProviderAndFilterPair filterPair : this.filterPairs) {
            GeneralFilterWidget filterWidget = filterPair.statProvider().getType().equals(String.class) ? new StringFilterWidget(this.method_46426() + 5, renderY, 175, 20, filterPair, this, this.filterScreen) : NumericFilterWidgetFactory.createFilterWidget(this.provider.getType(), this.method_46426() + 5, renderY, 175, 20, filterPair, this, this.filterScreen);
            if (filterWidget == null) continue;
            this.widgets.add(filterWidget);
            renderY += 24;
        }
        if (this.provider.getType().equals(String.class)) {
            this.addStringFilterButton.field_22764 = true;
            this.addStringFilterButton.field_22763 = true;
        } else if (!this.provider.getType().equals(Boolean.class)) {
            this.addNumericFilterButton.field_22764 = true;
            this.addNumericFilterButton.field_22763 = true;
            this.numericChoiceButton.field_22764 = true;
            this.numericChoiceButton.field_22763 = true;
        }
        this.scroll(this.scrollOffset);
    }

    public final void onFiltersChanged(List<StatProviderAndFilterPair> filterPairs) {
        this.filterPairs = new ArrayList<StatProviderAndFilterPair>(filterPairs);
        this.createWidgets();
    }

    public void updateQuery() {
        ArrayList<StatProviderAndFilterPair> newFilterpairs = new ArrayList<StatProviderAndFilterPair>();
        for (GeneralFilterWidget filterWidget : this.widgets) {
            newFilterpairs.add(filterWidget.getFilterPair());
        }
        this.filterPairs = new ArrayList<StatProviderAndFilterPair>(newFilterpairs.stream().filter(Objects::nonNull).toList());
        if (this.addStringFilterButton != null) {
            this.addStringFilterButton.field_22763 = this.filterPairs.size() == newFilterpairs.size();
        } else if (this.addNumericFilterButton != null) {
            this.addNumericFilterButton.field_22763 = this.filterPairs.size() == newFilterpairs.size();
        }
        this.filterScreen.setFiltersForProvider(this.provider, this.filterPairs);
    }

    public void removeWidget(GeneralFilterWidget filterWidget) {
        this.widgets.remove((Object)filterWidget);
        this.scrollOffset = 0;
        this.updateQuery();
        this.createWidgets();
    }

    public ItemStatProvider<?> getProvider() {
        return this.provider;
    }

    private boolean isScrollable() {
        if (this.anyFilterActive()) {
            return false;
        }
        if (this.provider.getValidInputs().isEmpty()) {
            return this.widgets.size() > 5;
        }
        return this.provider.getValidInputs().size() > 6;
    }

    private float getScrollableArea() {
        if (this.provider.getValidInputs().isEmpty() && !this.anyFilterActive()) {
            return 90.0f;
        }
        return 112.0f;
    }

    private int getMaxScrollOffset() {
        if (this.provider.getValidInputs().isEmpty() && !this.anyFilterActive()) {
            return (this.widgets.size() - 5) * 24;
        }
        return (this.provider.getValidInputs().size() - 6) * 24;
    }

    private float getScrollbarHeight() {
        if (this.provider.getValidInputs().isEmpty() && !this.anyFilterActive()) {
            return 120.0f;
        }
        return 144.0f;
    }

    private boolean anyFilterActive() {
        return !this.widgets.isEmpty() && this.widgets.getFirst() instanceof AnyFilterWidget;
    }

    private void cycleNumericChoice(int direction) {
        ArrayList<NumericType> types = new ArrayList<NumericType>(List.of(NumericType.values()));
        this.numericChoice = types.indexOf((Object)this.numericChoice) + direction < 0 ? (NumericType)((Object)types.getLast()) : (types.indexOf((Object)this.numericChoice) + direction == types.size() ? (NumericType)((Object)types.getFirst()) : (NumericType)((Object)types.get(types.indexOf((Object)this.numericChoice) + direction)));
        this.numericChoiceButton.method_25355((class_2561)class_2561.method_43470((String)EnumUtils.toNiceString(this.numericChoice)));
    }

    private void renderScrollBar(class_4587 poseStack) {
        RenderUtils.drawRect(poseStack, CommonColors.LIGHT_GRAY, this.method_46426() + 184, this.method_46427(), 0.0f, 6.0f, this.getScrollbarHeight());
        this.scrollRenderY = (int)((float)this.method_46427() + MathUtils.map(this.scrollOffset, 0.0f, this.getMaxScrollOffset(), 0.0f, this.getScrollbarHeight() - 20.0f));
        RenderUtils.drawRect(poseStack, this.draggingScroll ? CommonColors.BLACK : CommonColors.GRAY, this.method_46426() + 184, this.scrollRenderY, 0.0f, 6.0f, 20.0f);
    }

    private void scroll(int newOffset) {
        this.scrollOffset = newOffset;
        for (GeneralFilterWidget filterWidget : this.widgets) {
            int newY = this.method_46427() + 2 + this.widgets.indexOf((Object)filterWidget) * 24 - this.scrollOffset;
            filterWidget.updateY(newY);
            filterWidget.field_22764 = newY >= this.method_46427() + 2 - 24 && (float)newY <= (float)(this.method_46427() + 2) + this.getScrollbarHeight();
        }
    }

    private GeneralFilterWidget getNumericFilterWidget(int renderY) {
        return switch (this.numericChoice.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> NumericFilterWidgetFactory.createSingleWidget(this.provider.getType(), this.method_46426() + 5, renderY, 175, 20, null, this, this.filterScreen);
            case 1 -> NumericFilterWidgetFactory.createRangedWidget(this.provider.getType(), this.method_46426() + 5, renderY, 175, 20, null, this, this.filterScreen);
            case 2 -> NumericFilterWidgetFactory.createInequalityWidget(this.provider.getType(), this.method_46426() + 5, renderY, 175, 20, null, this, this.filterScreen);
        };
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    private static enum NumericType {
        SINGLE,
        RANGED,
        INEQUALITY;

    }
}

