/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemfilter.widgets;

import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.widgets.WynntilsCheckbox;
import com.wynntils.screens.itemfilter.widgets.GeneralFilterWidget;
import com.wynntils.screens.itemfilter.widgets.ProviderFilterListWidget;
import com.wynntils.services.itemfilter.filters.StringStatFilter;
import com.wynntils.services.itemfilter.type.StatFilter;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public final class SelectionFilterWidget
extends GeneralFilterWidget {
    private static final CustomColor UNUSED_COLOR = new CustomColor(116, 0, 0, 255);
    private static final CustomColor UNUSED_COLOR_BORDER = new CustomColor(220, 0, 0, 255);
    private static final CustomColor USED_COLOR = new CustomColor(0, 116, 0, 255);
    private static final CustomColor USED_COLOR_BORDER = new CustomColor(0, 220, 0, 255);
    private final String valueName;
    private final WynntilsCheckbox usedCheckbox;
    private boolean used;

    public SelectionFilterWidget(int x, int y, int width, int height, String valueName, Optional<StatProviderAndFilterPair> filterPair, ProviderFilterListWidget parent) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)"Selection Filter Widget"), parent);
        this.valueName = valueName;
        this.used = filterPair.isPresent();
        this.usedCheckbox = new WynntilsCheckbox(x + width - 16, y + 2, 16, (class_2561)class_2561.method_43470((String)""), this.used, 0, (c, b) -> this.toggleUsed());
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4587 poseStack = guiGraphics.method_51448();
        RenderUtils.drawRect(poseStack, this.getRectColor().withAlpha(100), this.method_46426(), this.method_46427(), 0.0f, this.field_22758 - 18, this.field_22759);
        RenderUtils.drawRectBorders(poseStack, this.getBorderColor(), this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758 - 18, this.method_46427() + this.field_22759, 1.0f, 2.0f);
        FontRenderer.getInstance().renderScrollingText(poseStack, StyledText.fromString(this.valueName), this.method_46426() + 2, (float)this.method_46427() + (float)this.field_22759 / 2.0f, this.field_22758 - 4, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 1.0f);
        this.usedCheckbox.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.usedCheckbox.method_25405(mouseX, mouseY)) {
            return this.usedCheckbox.method_25402(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public void updateY(int y) {
        this.method_46419(y);
        this.usedCheckbox.method_46419(y + 2);
    }

    @Override
    protected StatProviderAndFilterPair getFilterPair() {
        if (!this.used) {
            return null;
        }
        Optional<StringStatFilter> statFilterOpt = new StringStatFilter.StringStatFilterFactory().create(this.valueName);
        return statFilterOpt.map(stringStatFilter -> new StatProviderAndFilterPair<String>(this.parent.getProvider(), (StatFilter<String>)stringStatFilter)).orElse(null);
    }

    private void toggleUsed() {
        this.used = !this.used;
        this.parent.updateQuery();
    }

    private CustomColor getRectColor() {
        return this.used ? USED_COLOR : UNUSED_COLOR;
    }

    private CustomColor getBorderColor() {
        return this.used ? USED_COLOR_BORDER : UNUSED_COLOR_BORDER;
    }
}

