/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemfilter.widgets.numeric;

import com.wynntils.screens.base.widgets.WynntilsCheckbox;
import com.wynntils.screens.itemfilter.ItemFilterScreen;
import com.wynntils.screens.itemfilter.widgets.ProviderFilterListWidget;
import com.wynntils.screens.itemfilter.widgets.numeric.RangedNumericFilterWidget;
import com.wynntils.services.itemfilter.filters.PercentageStatFilter;
import com.wynntils.services.itemfilter.filters.RangedStatFilters;
import com.wynntils.services.itemfilter.type.StatFilter;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import com.wynntils.services.itemfilter.type.StatValue;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class RangedStatValueFilterWidget
extends RangedNumericFilterWidget<StatValue> {
    private final WynntilsCheckbox percentageCheckbox;

    public RangedStatValueFilterWidget(int x, int y, int width, int height, StatProviderAndFilterPair filterPair, ProviderFilterListWidget parent, ItemFilterScreen filterScreen) {
        super(x, y, width, height, parent, filterScreen);
        StatFilter statFilter;
        boolean percentage = false;
        if (filterPair != null && (statFilter = filterPair.statFilter()) instanceof PercentageStatFilter) {
            PercentageStatFilter percentageStatFilter = (PercentageStatFilter)statFilter;
            this.setMinInput(String.valueOf(percentageStatFilter.getMin()));
            this.setMaxInput(String.valueOf(percentageStatFilter.getMax()));
            percentage = true;
        } else if (filterPair != null && (statFilter = filterPair.statFilter()) instanceof RangedStatFilters.RangedStatValueStatFilter) {
            RangedStatFilters.RangedStatValueStatFilter statValueStatFilter = (RangedStatFilters.RangedStatValueStatFilter)statFilter;
            this.setMinInput(String.valueOf(statValueStatFilter.getMin()));
            this.setMaxInput(String.valueOf(statValueStatFilter.getMax()));
        }
        this.percentageCheckbox = new WynntilsCheckbox(this.method_46426() + this.method_25368() - 52, this.method_46427(), 20, (class_2561)class_2561.method_43470((String)"%"), percentage, 10, (checkbox, button) -> parent.updateQuery(), List.of(class_2561.method_43471((String)"screens.wynntils.itemFilter.percentageTooltip")));
    }

    @Override
    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
        this.percentageCheckbox.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.percentageCheckbox.method_25405(mouseX, mouseY)) {
            return this.percentageCheckbox.method_25402(mouseX, mouseY, button);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public void updateY(int y) {
        super.updateY(y);
        this.percentageCheckbox.method_46419(y);
    }

    @Override
    protected Optional<StatFilter<StatValue>> getRangedStatFilter(String min, String max) {
        if (this.percentageCheckbox.selected) {
            return new PercentageStatFilter.PercentageStatFilterFactory().create(min + "-" + max + "%").map(f -> f);
        }
        return new RangedStatFilters.RangedStatValueStatFilter.RangedStatValueStatFilterFactory().create(min + "-" + max).map(f -> f);
    }
}

