/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.loading;

import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.screens.WynntilsScreen;
import com.wynntils.core.text.StyledText;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_634;

public final class LoadingScreen
extends WynntilsScreen {
    private static final String LOGO_STRING = "\ue005\udaff\udfff\ue006";
    private static final String TEXT_LOGO_STRING = "Wynncraft";
    private static final class_2960 LOGO_FONT_LOCATION = class_2960.method_60656((String)"screen/static");
    private static final CustomColor MOSS_GREEN = CustomColor.fromInt(5403945).withAlpha(255);
    private static final int SPINNER_SPEED = 1200;
    private final Runnable onClose;
    private int offsetX;
    private int offsetY;
    private String message = "";
    private String stageTitle = "";
    private String subtitle = "";

    private LoadingScreen(Runnable onClose) {
        super((class_2561)class_2561.method_43471((String)"screens.wynntils.characterSelection.name"));
        this.onClose = onClose;
    }

    public static LoadingScreen create(Runnable onClose) {
        return new LoadingScreen(onClose);
    }

    public void method_25419() {
        class_634 connection = McUtils.mc().method_1562();
        if (connection != null) {
            connection.method_47658();
        }
        this.onClose.run();
        super.method_25419();
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setStageTitle(String stageTitle) {
        this.stageTitle = stageTitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    @Override
    public void doInit() {
        super.doInit();
        this.offsetX = (int)((float)(this.field_22789 - Texture.SCROLL_BACKGROUND.width()) / 2.0f);
        this.offsetY = (int)((float)(this.field_22790 - Texture.SCROLL_BACKGROUND.height()) / 2.0f);
    }

    @Override
    public void doRender(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4587 poseStack = guiGraphics.method_51448();
        int textureWidth = Texture.BACKGROUND_SPLASH.width();
        int textureHeight = Texture.BACKGROUND_SPLASH.height();
        float widthScaleFactor = (float)this.field_22789 / (float)textureWidth;
        float heightScaleFactor = (float)this.field_22790 / (float)textureHeight;
        float scaleFactor = Math.max(widthScaleFactor, heightScaleFactor);
        float scaledWidth = (float)textureWidth * scaleFactor;
        float scaledHeight = (float)textureHeight * scaleFactor;
        RenderUtils.drawScalingTexturedRect(poseStack, Texture.BACKGROUND_SPLASH.resource(), ((float)this.field_22789 - scaledWidth) / 2.0f, ((float)this.field_22790 - scaledHeight) / 2.0f, 0.0f, scaledWidth, scaledHeight, textureWidth, textureHeight);
        RenderUtils.drawTexturedRect(poseStack, Texture.SCROLL_BACKGROUND, this.offsetX, this.offsetY);
        int centerX = (int)((float)Texture.SCROLL_BACKGROUND.width() / 2.0f + 15.0f + (float)this.offsetX);
        class_5250 logoComponent = Services.ResourcePack.isPreloadedPackSelected() ? class_2561.method_43470((String)LOGO_STRING).method_27696(class_2583.field_24360.method_27704(LOGO_FONT_LOCATION)) : class_2561.method_43470((String)TEXT_LOGO_STRING);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((class_2561)logoComponent), centerX, 60 + this.offsetY, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.NONE);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(this.message), centerX, 100 + this.offsetY, MOSS_GREEN, HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.NONE);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(this.stageTitle), centerX, 120 + this.offsetY, MOSS_GREEN, HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.NONE);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(this.subtitle), centerX, 130 + this.offsetY, MOSS_GREEN, HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.NONE);
        boolean state = System.currentTimeMillis() % 1200L < 600L;
        this.drawSpinner(poseStack, centerX, 150 + this.offsetY, state);
    }

    private void drawSpinner(class_4587 poseStack, float x, float y, boolean state) {
        class_2960 resource = Texture.RELOAD_ICON_OFFSET.resource();
        int fullWidth = Texture.RELOAD_ICON_OFFSET.width();
        int spinnerWidth = fullWidth / 2;
        int spinnerHeight = Texture.RELOAD_ICON_OFFSET.height();
        int uOffset = state ? spinnerWidth : 0;
        RenderUtils.drawTexturedRect(poseStack, resource, x - (float)spinnerWidth / 2.0f, y, 0.0f, spinnerWidth, spinnerHeight, uOffset, 0, spinnerWidth, spinnerHeight, fullWidth, spinnerHeight);
    }
}

