/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.maps;

import com.wynntils.screens.base.WynntilsGridLayoutScreen;
import com.wynntils.screens.maps.PoiManagementScreen;
import com.wynntils.screens.maps.widgets.IconFilterWidget;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public final class IconFilterScreen
extends WynntilsGridLayoutScreen {
    private static final int HEADER_HEIGHT = 13;
    private static final int ICONS_PER_ROW = 7;
    private static final int MAX_ICONS_TO_DISPLAY = 28;
    private final List<class_339> iconFilterWidgets = new ArrayList<class_339>();
    private final Map<Texture, Boolean> icons;
    private final PoiManagementScreen previousScreen;
    private class_4185 includeAllButton;
    private class_4185 excludeAllButton;
    private boolean draggingScroll = false;
    private float backgroundHeight;
    private float backgroundWidth;
    private float backgroundX;
    private float backgroundY;
    private float scrollButtonHeight;
    private float scrollButtonRenderX;
    private float scrollButtonRenderY;
    private int iconButtonSize;
    private int scrollAreaHeight;
    private int scrollOffset = 0;
    private List<Texture> usedIcons;

    private IconFilterScreen(PoiManagementScreen previousScreen, Map<Texture, Boolean> icons) {
        super((class_2561)class_2561.method_43470((String)"Icon Filter Screen"));
        this.previousScreen = previousScreen;
        this.icons = icons;
    }

    public static class_437 create(PoiManagementScreen previousScreen, Map<Texture, Boolean> icons) {
        return new IconFilterScreen(previousScreen, icons);
    }

    public void method_25419() {
        McUtils.setScreen(this.previousScreen);
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.iconButtonSize = (int)(this.dividedWidth * 5.0f);
        this.backgroundX = this.dividedWidth * 10.0f;
        this.backgroundWidth = this.dividedWidth * 44.0f;
        this.backgroundY = this.dividedHeight * 7.0f;
        this.backgroundHeight = this.dividedHeight * 50.0f;
        this.scrollButtonHeight = this.dividedWidth / 2.0f / (float)Texture.SCROLL_BUTTON.width() * (float)Texture.SCROLL_BUTTON.height();
        this.scrollAreaHeight = (int)(this.backgroundHeight - this.scrollButtonHeight) - (int)(this.dividedHeight * 4.0f);
        this.scrollButtonRenderX = (float)((int)(this.dividedWidth * 52.0f)) + this.dividedWidth / 4.0f;
        int filterButtonWidth = (int)(this.dividedWidth * 10.0f);
        this.includeAllButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.iconFilter.includeAll"), button -> {
            this.icons.replaceAll((key, value) -> true);
            button.field_22763 = false;
            this.excludeAllButton.field_22763 = true;
            this.populateIcons();
        }).method_46433((int)this.backgroundX, (int)(this.dividedHeight * 3.0f)).method_46437(filterButtonWidth, 20).method_46431();
        this.includeAllButton.field_22763 = this.icons.containsValue(false);
        this.method_37063((class_364)this.includeAllButton);
        this.excludeAllButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.iconFilter.excludeAll"), button -> {
            this.icons.replaceAll((key, value) -> false);
            button.field_22763 = false;
            this.includeAllButton.field_22763 = true;
            this.populateIcons();
        }).method_46433((int)this.backgroundX + filterButtonWidth + 5, (int)(this.dividedHeight * 3.0f)).method_46437(filterButtonWidth, 20).method_46431();
        this.excludeAllButton.field_22763 = this.icons.containsValue(true);
        this.method_37063((class_364)this.excludeAllButton);
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.iconFilter.done"), button -> McUtils.mc().method_1507((class_437)this.previousScreen)).method_46433((int)(this.dividedWidth * 44.0f), (int)(this.dividedHeight * 3.0f)).method_46437(filterButtonWidth, 20).method_46431());
        this.usedIcons = new ArrayList<Texture>(this.icons.keySet());
        this.populateIcons();
    }

    @Override
    public void doRender(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.doRender(guiGraphics, mouseX, mouseY, partialTick);
        this.renderScrollButton(guiGraphics.method_51448());
    }

    @Override
    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25420(guiGraphics, mouseX, mouseY, partialTick);
        RenderUtils.drawScalingTexturedRect(guiGraphics.method_51448(), Texture.WAYPOINT_MANAGER_BACKGROUND.resource(), this.backgroundX, this.backgroundY, 0.0f, this.backgroundWidth, this.backgroundHeight, Texture.WAYPOINT_MANAGER_BACKGROUND.width(), Texture.WAYPOINT_MANAGER_BACKGROUND.height());
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        if (!this.draggingScroll && this.usedIcons.size() > 28 && MathUtils.isInside((int)mouseX, (int)mouseY, (int)this.scrollButtonRenderX, (int)(this.scrollButtonRenderX + this.dividedWidth / 2.0f), (int)this.scrollButtonRenderY, (int)(this.scrollButtonRenderY + this.scrollButtonHeight))) {
            this.draggingScroll = true;
            return true;
        }
        return super.doMouseClicked(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.draggingScroll) {
            return false;
        }
        int renderY = (int)(((float)this.field_22790 - this.backgroundHeight) / 2.0f + (float)((int)(this.dividedHeight * 3.0f)));
        int scrollAreaStartY = renderY + 7;
        int newValue = Math.round(MathUtils.map((float)mouseY, scrollAreaStartY, scrollAreaStartY + this.scrollAreaHeight, 0.0f, this.getMaxScrollOffset()));
        this.scroll(newValue - this.scrollOffset);
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.draggingScroll = false;
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        double scrollValue = -Math.signum(deltaY);
        this.scroll((int)scrollValue);
        return true;
    }

    public void toggleIcon(Texture icon) {
        this.icons.put(icon, this.icons.get((Object)icon) == false);
        this.previousScreen.setFilteredIcons(this.icons);
        this.includeAllButton.field_22763 = this.icons.containsValue(false);
        this.excludeAllButton.field_22763 = this.icons.containsValue(true);
        this.populateIcons();
    }

    private void renderScrollButton(class_4587 poseStack) {
        if (this.usedIcons.size() <= 28) {
            return;
        }
        this.scrollButtonRenderY = ((float)this.field_22790 - this.backgroundHeight) / 2.0f + (float)((int)(this.dividedHeight * 3.0f)) + MathUtils.map(this.scrollOffset, 0.0f, this.getMaxScrollOffset(), 0.0f, this.scrollAreaHeight);
        RenderUtils.drawScalingTexturedRect(poseStack, Texture.SCROLL_BUTTON.resource(), this.scrollButtonRenderX, this.scrollButtonRenderY, 1.0f, this.dividedWidth / 2.0f, this.scrollButtonHeight, Texture.SCROLL_BUTTON.width(), Texture.SCROLL_BUTTON.height());
    }

    private void scroll(int delta) {
        int maxValue = this.getMaxScrollOffset();
        this.scrollOffset = MathUtils.clamp(this.scrollOffset + delta, 0, maxValue);
        this.populateIcons();
    }

    private int getMaxScrollOffset() {
        int maxItemOffset = Math.max(0, this.usedIcons.size() - 28);
        return maxItemOffset / 7 + (maxItemOffset % 7 > 0 ? 1 : 0);
    }

    private void populateIcons() {
        int currentIcon;
        for (class_339 widget : this.iconFilterWidgets) {
            this.method_37066((class_364)widget);
        }
        this.iconFilterWidgets.clear();
        int row = (int)((float)((int)(this.dividedHeight * 13.0f)) + this.dividedHeight / 2.0f);
        int xPos = (int)(this.dividedWidth * 14.0f);
        int widgetsOnCurrentRow = 0;
        for (int i = 0; i < 28 && (currentIcon = i + this.scrollOffset * 7) <= this.usedIcons.size() - 1; ++i) {
            Texture icon = this.usedIcons.get(currentIcon);
            IconFilterWidget filterWidget = new IconFilterWidget(xPos, row, this.iconButtonSize, this.iconButtonSize, icon, this, this.icons.getOrDefault((Object)icon, false));
            this.iconFilterWidgets.add(filterWidget);
            this.method_37063((class_364)filterWidget);
            if (++widgetsOnCurrentRow == 7) {
                row += this.iconButtonSize;
                xPos = (int)(this.dividedWidth * 14.0f);
                widgetsOnCurrentRow = 0;
                continue;
            }
            xPos += this.iconButtonSize;
        }
    }
}

