/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.maps;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.wynntils.core.components.Managers;
import com.wynntils.core.json.JsonManager;
import com.wynntils.core.persisted.config.HiddenConfig;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.map.MainMapFeature;
import com.wynntils.models.marker.MarkerModel;
import com.wynntils.screens.base.WynntilsGridLayoutScreen;
import com.wynntils.screens.base.widgets.InfoButton;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.screens.maps.IconFilterScreen;
import com.wynntils.screens.maps.MainMapScreen;
import com.wynntils.screens.maps.widgets.PoiManagerWidget;
import com.wynntils.screens.maps.widgets.PoiSortButton;
import com.wynntils.services.map.pois.CustomPoi;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_7919;

public final class PoiManagementScreen
extends WynntilsGridLayoutScreen {
    private static final int GRID_ROWS_PER_PAGE = 43;
    private static final int HEADER_HEIGHT = 12;
    private final List<class_339> poiManagerWidgets = new ArrayList<class_339>();
    private final List<CustomPoi> deletedPois = new ArrayList<CustomPoi>();
    private final List<Integer> deletedIndexes = new ArrayList<Integer>();
    private final MainMapScreen oldMapScreen;
    private class_4185 deleteSelectedButton;
    private class_4185 deselectAllButton;
    private class_4185 downButton;
    private class_4185 exportButton;
    private class_4185 filterButton;
    private class_4185 removeMarkersButton;
    private class_4185 selectAllButton;
    private class_4185 setMarkersButton;
    private class_4185 undoDeleteButton;
    private class_4185 upButton;
    private PoiSortButton activeSortButton;
    private PoiSortButton iconSortButton;
    private PoiSortButton nameSortButton;
    private PoiSortButton xSortButton;
    private PoiSortButton ySortButton;
    private PoiSortButton zSortButton;
    private TextInputBoxWidget focusedTextInput;
    private TextInputBoxWidget searchInput;
    private boolean draggingScroll = false;
    private float backgroundHeight;
    private float backgroundWidth;
    private float backgroundX;
    private float backgroundY;
    private float scrollButtonHeight;
    private float scrollButtonRenderX;
    private float scrollButtonRenderY;
    private int maxPoisToDisplay;
    private int scrollAreaHeight;
    private int scrollOffset = 0;
    private boolean selectionMode = false;
    private List<CustomPoi> selectedPois = new ArrayList<CustomPoi>();
    private List<CustomPoi> pois;
    private Map<Texture, Boolean> filteredIcons = new EnumMap<Texture, Boolean>(Texture.class);
    private PoiSortOrder sortOrder;

    private PoiManagementScreen(MainMapScreen oldMapScreen) {
        super((class_2561)class_2561.method_43470((String)"Poi Management Screen"));
        this.oldMapScreen = oldMapScreen;
    }

    public static class_437 create() {
        return new PoiManagementScreen(null);
    }

    public static class_437 create(MainMapScreen oldMapScreen) {
        return new PoiManagementScreen(oldMapScreen);
    }

    public void method_25419() {
        McUtils.setScreen(this.oldMapScreen);
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.maxPoisToDisplay = (int)(this.dividedHeight * 43.0f) / 20;
        this.backgroundX = this.dividedWidth * 10.0f;
        this.backgroundWidth = this.dividedWidth * 44.0f;
        this.backgroundY = this.dividedHeight * 7.0f;
        this.backgroundHeight = this.dividedHeight * 50.0f;
        this.scrollButtonHeight = this.dividedWidth / 2.0f / (float)Texture.SCROLL_BUTTON.width() * (float)Texture.SCROLL_BUTTON.height();
        this.scrollAreaHeight = (int)(this.backgroundHeight - this.scrollButtonHeight) - (int)(this.dividedHeight * 4.0f);
        this.scrollButtonRenderX = (float)((int)(this.dividedWidth * 52.0f)) + this.dividedWidth / 4.0f;
        int importExportButtonWidth = (int)(this.dividedWidth * 6.0f);
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43470((String)"X").method_27692(class_124.field_1061), button -> this.method_25419()).method_46433((int)(this.dividedWidth * 60.0f), (int)(this.dividedHeight * 4.0f)).method_46437(20, 20).method_46431());
        this.method_37063((class_364)new InfoButton((int)(this.dividedWidth * 3.0f), (int)(this.dividedHeight * 4.0f), (class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.poiManagementGui.help").method_27692(class_124.field_1073)).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.poiManagementGui.help1").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.poiManagementGui.help2").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.poiManagementGui.help3").method_27692(class_124.field_1080))));
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.poiManagementGui.import"), button -> this.importFromClipboard()).method_46433((int)(this.dividedWidth * 22.0f), (int)(this.dividedHeight * 58.0f)).method_46437(importExportButtonWidth, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"screens.wynntils.poiManagementGui.import.tooltip"))).method_46431());
        this.exportButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.poiManagementGui.export"), button -> this.exportToClipboard()).method_46433((int)(this.dividedWidth * 36.0f), (int)(this.dividedHeight * 58.0f)).method_46437(importExportButtonWidth, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"screens.wynntils.poiManagementGui.exportAll.tooltip"))).method_46431();
        this.method_37063((class_364)this.exportButton);
        this.undoDeleteButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.poiManagementGui.undo"), button -> this.undoDelete()).method_46433((int)(this.dividedWidth * 55.0f), (int)(this.dividedHeight * 58.0f)).method_46437((int)(this.dividedWidth * 8.0f), 20).method_46431();
        this.method_37063((class_364)this.undoDeleteButton);
        this.deleteSelectedButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.poiManagementGui.deleteSelected"), button -> this.deleteSelectedPois()).method_46433((int)(this.dividedWidth * 55.0f), (int)(this.dividedHeight * 58.0f) - 25).method_46437((int)(this.dividedWidth * 8.0f), 20).method_46431();
        this.deleteSelectedButton.field_22763 = false;
        this.method_37063((class_364)this.deleteSelectedButton);
        this.setMarkersButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.poiManagementGui.setMarkers"), button -> this.toggleMarkers(true)).method_46433((int)this.dividedWidth, (int)(this.dividedHeight * 58.0f) - 75).method_46437((int)(this.dividedWidth * 8.0f), 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"screens.wynntils.poiManagementGui.setMarkers.tooltip"))).method_46431();
        this.setMarkersButton.field_22763 = false;
        this.method_37063((class_364)this.setMarkersButton);
        this.removeMarkersButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.poiManagementGui.removeMarkers"), button -> this.toggleMarkers(false)).method_46433((int)this.dividedWidth, (int)(this.dividedHeight * 58.0f) - 50).method_46437((int)(this.dividedWidth * 8.0f), 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"screens.wynntils.poiManagementGui.removeMarkers.tooltip"))).method_46431();
        this.removeMarkersButton.field_22763 = false;
        this.method_37063((class_364)this.removeMarkersButton);
        this.deselectAllButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.poiManagementGui.deselectAll"), button -> this.toggleSelectAll(false)).method_46433((int)this.dividedWidth, (int)(this.dividedHeight * 58.0f)).method_46437((int)(this.dividedWidth * 8.0f), 20).method_46431();
        this.deselectAllButton.field_22763 = false;
        this.method_37063((class_364)this.deselectAllButton);
        this.selectAllButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.poiManagementGui.selectAll"), button -> this.toggleSelectAll(true)).method_46433((int)this.dividedWidth, (int)(this.dividedHeight * 58.0f) - 25).method_46437((int)(this.dividedWidth * 8.0f), 20).method_46431();
        this.method_37063((class_364)this.selectAllButton);
        this.upButton = new class_4185.class_7840((class_2561)class_2561.method_43470((String)"\ud83e\udc1d"), button -> this.updateSelectedPoiPositions(-1)).method_46433(this.field_22789 / 2 - 22, (int)(this.dividedHeight * 58.0f)).method_46437(20, 20).method_46431();
        this.upButton.field_22764 = false;
        this.method_37063((class_364)this.upButton);
        this.downButton = new class_4185.class_7840((class_2561)class_2561.method_43470((String)"\ud83e\udc1f"), button -> this.updateSelectedPoiPositions(1)).method_46433(this.field_22789 / 2 + 2, (int)(this.dividedHeight * 58.0f)).method_46437(20, 20).method_46431();
        this.downButton.field_22764 = false;
        this.method_37063((class_364)this.downButton);
        int filterButtonWidth = (int)(this.dividedWidth * 10.0f);
        this.filterButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.poiManagementGui.filter"), button -> {
            this.scrollOffset = 0;
            McUtils.setScreen(IconFilterScreen.create(this, this.filteredIcons));
        }).method_46433((int)(this.dividedWidth * 44.0f), (int)(this.dividedHeight * 3.0f)).method_46437(filterButtonWidth, 20).method_46431();
        this.method_37063((class_364)this.filterButton);
        this.searchInput = new TextInputBoxWidget((int)(this.dividedWidth * 10.0f) + 5, (int)(this.dividedHeight * 3.0f), (int)(this.backgroundWidth - (float)filterButtonWidth - 10.0f), 20, s -> {
            this.scrollOffset = 0;
            this.populatePois();
        }, this, this.searchInput);
        this.method_37063((class_364)this.searchInput);
        this.setFocusedTextInput(this.searchInput);
        int iconTitleWidth = McUtils.mc().field_1772.method_1727(class_1074.method_4662((String)"screens.wynntils.poiManagementGui.icon", (Object[])new Object[0])) + 1;
        int nameTitleWidth = McUtils.mc().field_1772.method_1727(class_1074.method_4662((String)"screens.wynntils.poiManagementGui.name", (Object[])new Object[0])) + 1;
        int coordinateTitleWidth = McUtils.mc().field_1772.method_1727("X") + 1;
        this.iconSortButton = (PoiSortButton)this.method_37063((class_364)new PoiSortButton((int)(this.dividedWidth * 13.0f) - iconTitleWidth / 2, (int)(this.dividedHeight * 12.0f) - 10, iconTitleWidth, 10, (class_2561)class_2561.method_43471((String)"screens.wynntils.poiManagementGui.icon"), this, PoiSortType.ICON));
        this.nameSortButton = (PoiSortButton)this.method_37063((class_364)new PoiSortButton((int)(this.dividedWidth * 22.0f) - nameTitleWidth / 2, (int)(this.dividedHeight * 12.0f) - 10, nameTitleWidth, 10, (class_2561)class_2561.method_43471((String)"screens.wynntils.poiManagementGui.name"), this, PoiSortType.NAME));
        this.xSortButton = (PoiSortButton)this.method_37063((class_364)new PoiSortButton((int)(this.dividedWidth * 32.0f) - coordinateTitleWidth / 2, (int)(this.dividedHeight * 12.0f) - 10, coordinateTitleWidth, 10, (class_2561)class_2561.method_43470((String)"X"), this, PoiSortType.X));
        this.ySortButton = (PoiSortButton)this.method_37063((class_364)new PoiSortButton((int)(this.dividedWidth * 35.0f) - coordinateTitleWidth / 2, (int)(this.dividedHeight * 12.0f) - 10, coordinateTitleWidth, 10, (class_2561)class_2561.method_43470((String)"Y"), this, PoiSortType.Y));
        this.zSortButton = (PoiSortButton)this.method_37063((class_364)new PoiSortButton((int)(this.dividedWidth * 38.0f) - coordinateTitleWidth / 2, (int)(this.dividedHeight * 12.0f) - 10, coordinateTitleWidth, 10, (class_2561)class_2561.method_43470((String)"Z"), this, PoiSortType.Z));
        if (this.deletedIndexes.isEmpty()) {
            this.undoDeleteButton.field_22763 = false;
        }
        this.pois = (List)Managers.Feature.getFeatureInstance(MainMapFeature.class).customPois.get();
        if (this.pois.isEmpty()) {
            this.searchInput.field_22764 = false;
            this.filterButton.field_22764 = false;
            this.iconSortButton.field_22764 = false;
            this.nameSortButton.field_22764 = false;
            this.xSortButton.field_22764 = false;
            this.ySortButton.field_22764 = false;
            this.zSortButton.field_22764 = false;
            this.exportButton.field_22763 = false;
        }
        this.updateAllUsedIcons();
        this.populatePois();
    }

    @Override
    public void doRender(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.doRender(guiGraphics, mouseX, mouseY, partialTick);
        class_4587 poseStack = guiGraphics.method_51448();
        this.renderScrollButton(poseStack);
        if (((List)Managers.Feature.getFeatureInstance(MainMapFeature.class).customPois.get()).isEmpty()) {
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((class_2561)class_2561.method_43471((String)"screens.wynntils.poiManagementGui.noPois")), (int)(this.dividedWidth * 32.0f), (int)(this.dividedHeight * 32.0f), CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
            return;
        }
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((class_2561)class_2561.method_43471((String)"screens.wynntils.poiManagementGui.search")), (int)(this.dividedWidth * 10.0f) + 5, (int)this.dividedHeight, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL);
        if (this.pois.isEmpty()) {
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((class_2561)class_2561.method_43471((String)"screens.wynntils.poiManagementGui.noFilteredPois")), (int)(this.dividedWidth * 32.0f), (int)(this.dividedHeight * 32.0f), CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        } else {
            RenderUtils.drawRect(poseStack, CommonColors.WHITE, (int)(this.dividedWidth * 12.0f), (int)(this.dividedHeight * 12.0f), 0.0f, (int)(this.dividedWidth * 38.0f), 1.0f);
        }
    }

    @Override
    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25420(guiGraphics, mouseX, mouseY, partialTick);
        RenderUtils.drawScalingTexturedRect(guiGraphics.method_51448(), Texture.WAYPOINT_MANAGER_BACKGROUND.resource(), this.backgroundX, this.backgroundY, 0.0f, this.backgroundWidth, this.backgroundHeight, Texture.WAYPOINT_MANAGER_BACKGROUND.width(), Texture.WAYPOINT_MANAGER_BACKGROUND.height());
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        if (!this.draggingScroll && this.pois.size() > this.maxPoisToDisplay && MathUtils.isInside((int)mouseX, (int)mouseY, (int)this.scrollButtonRenderX, (int)(this.scrollButtonRenderX + this.dividedWidth / 2.0f), (int)this.scrollButtonRenderY, (int)(this.scrollButtonRenderY + this.scrollButtonHeight))) {
            this.draggingScroll = true;
            return true;
        }
        return super.doMouseClicked(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.draggingScroll) {
            return false;
        }
        int renderY = (int)(((float)this.field_22790 - this.backgroundHeight) / 2.0f + (float)((int)(this.dividedHeight * 3.0f)));
        int scrollAreaStartY = renderY + 7;
        int newValue = Math.round(MathUtils.map((float)mouseY, scrollAreaStartY, scrollAreaStartY + this.scrollAreaHeight, 0.0f, Math.max(0, this.pois.size() - this.maxPoisToDisplay)));
        this.scroll(newValue - this.scrollOffset);
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.draggingScroll = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        double scrollValue = -Math.signum(deltaY);
        this.scroll((int)scrollValue);
        return true;
    }

    public void selectPoi(CustomPoi selectedPoi) {
        boolean addedPoi = true;
        if (this.selectedPois.contains(selectedPoi)) {
            this.selectedPois.remove(selectedPoi);
            addedPoi = false;
        } else {
            this.selectedPois.add(selectedPoi);
        }
        boolean bl = this.selectAllButton.field_22763 = this.selectedPois.size() < this.pois.size();
        if (addedPoi || this.selectedPois.isEmpty()) {
            this.selectionMode = addedPoi;
            this.deselectAllButton.field_22763 = addedPoi;
            this.deleteSelectedButton.field_22763 = addedPoi;
            this.setMarkersButton.field_22763 = addedPoi;
            this.removeMarkersButton.field_22763 = addedPoi;
            this.upButton.field_22764 = addedPoi;
            this.downButton.field_22764 = addedPoi;
            class_5250 tooltip = addedPoi ? class_2561.method_43469((String)"screens.wynntils.poiManagementGui.exportSelected.tooltip", (Object[])new Object[]{this.selectedPois.size()}) : class_2561.method_43471((String)"screens.wynntils.poiManagementGui.exportAll.tooltip");
            this.exportButton.method_47400(class_7919.method_47407((class_2561)tooltip));
        }
        this.populatePois();
    }

    public void toggleSortType(PoiSortType sortType, PoiSortButton selectedButton) {
        if (this.activeSortButton != null && this.activeSortButton != selectedButton) {
            this.activeSortButton.setSelected(false);
        }
        this.activeSortButton = selectedButton;
        boolean selected = this.toggleSortOrder(sortType);
        selectedButton.setSelected(selected);
        this.populatePois();
    }

    public void deletePoi(CustomPoi poiToDelete, boolean save) {
        HiddenConfig<List<CustomPoi>> customPois = Managers.Feature.getFeatureInstance(MainMapFeature.class).customPois;
        int deletedPoiIndex = ((List)customPois.get()).indexOf(poiToDelete);
        ((List)customPois.get()).remove(poiToDelete);
        if (save) {
            customPois.touched();
        }
        Managers.Feature.getFeatureInstance(MainMapFeature.class).updateWaypoints();
        this.deletedPois.add(poiToDelete);
        this.deletedIndexes.add(deletedPoiIndex);
        this.undoDeleteButton.field_22763 = true;
        if (((List)customPois.get()).isEmpty()) {
            this.searchInput.field_22764 = false;
            this.iconSortButton.field_22764 = false;
            this.nameSortButton.field_22764 = false;
            this.xSortButton.field_22764 = false;
            this.ySortButton.field_22764 = false;
            this.zSortButton.field_22764 = false;
            this.selectAllButton.field_22763 = false;
            this.exportButton.field_22763 = false;
        }
        if (this.scrollOffset == Math.max(0, this.pois.size() - this.maxPoisToDisplay)) {
            this.scroll(-1);
        }
        this.updateAllUsedIcons();
        this.populatePois();
    }

    public void updatePoiPosition(CustomPoi poiToMove, int direction) {
        int poiToMoveIndex = this.pois.indexOf(poiToMove);
        if (poiToMoveIndex == -1 || poiToMoveIndex + direction < 0 || poiToMoveIndex + direction > this.pois.size() - 1) {
            return;
        }
        CustomPoi poiToSwap = this.pois.get(this.pois.indexOf(poiToMove) + direction);
        HiddenConfig<List<CustomPoi>> customPois = Managers.Feature.getFeatureInstance(MainMapFeature.class).customPois;
        Collections.swap((List)customPois.get(), ((List)customPois.get()).indexOf(poiToMove), ((List)customPois.get()).indexOf(poiToSwap));
        customPois.touched();
        Managers.Feature.getFeatureInstance(MainMapFeature.class).updateWaypoints();
        this.populatePois();
    }

    public List<CustomPoi> getPois() {
        return Collections.unmodifiableList(this.pois);
    }

    public void setFilteredIcons(Map<Texture, Boolean> filteredIcons) {
        this.filteredIcons = filteredIcons;
    }

    private void renderScrollButton(class_4587 poseStack) {
        if (this.pois.size() <= this.maxPoisToDisplay) {
            return;
        }
        this.scrollButtonRenderY = ((float)this.field_22790 - this.backgroundHeight) / 2.0f + (float)((int)(this.dividedHeight * 3.0f)) + MathUtils.map(this.scrollOffset, 0.0f, this.pois.size() - this.maxPoisToDisplay, 0.0f, this.scrollAreaHeight);
        RenderUtils.drawScalingTexturedRect(poseStack, Texture.SCROLL_BUTTON.resource(), this.scrollButtonRenderX, this.scrollButtonRenderY, 1.0f, this.dividedWidth / 2.0f, this.scrollButtonHeight, Texture.SCROLL_BUTTON.width(), Texture.SCROLL_BUTTON.height());
    }

    private void scroll(int delta) {
        this.scrollOffset = MathUtils.clamp(this.scrollOffset + delta, 0, Math.max(0, this.pois.size() - this.maxPoisToDisplay));
        this.populatePois();
    }

    private void populatePois() {
        int currentPoi;
        for (class_339 widget : this.poiManagerWidgets) {
            this.method_37066((class_364)widget);
        }
        this.poiManagerWidgets.clear();
        this.pois = ((List)Managers.Feature.getFeatureInstance(MainMapFeature.class).customPois.get()).stream().filter(poi -> this.searchMatches(poi.getName())).collect(Collectors.toList());
        if (this.pois.isEmpty()) {
            return;
        }
        this.pois = this.pois.stream().filter(poi -> this.filteredIcons.getOrDefault((Object)poi.getIcon(), true)).collect(Collectors.toList());
        this.iconSortButton.field_22764 = !this.pois.isEmpty();
        this.nameSortButton.field_22764 = !this.pois.isEmpty();
        this.xSortButton.field_22764 = !this.pois.isEmpty();
        this.ySortButton.field_22764 = !this.pois.isEmpty();
        this.zSortButton.field_22764 = !this.pois.isEmpty();
        this.exportButton.field_22763 = !this.pois.isEmpty();
        this.selectAllButton.field_22763 = !this.pois.isEmpty();
        this.deselectAllButton.field_22763 = !this.selectedPois.isEmpty();
        this.setMarkersButton.field_22763 = !this.selectedPois.isEmpty();
        boolean bl = this.removeMarkersButton.field_22763 = !this.selectedPois.isEmpty();
        if (((List)Managers.Feature.getFeatureInstance(MainMapFeature.class).customPois.get()).isEmpty()) {
            this.searchInput.field_22764 = false;
            this.filterButton.field_22764 = false;
        }
        if (this.pois.isEmpty()) {
            return;
        }
        if (this.sortOrder != null) {
            this.sortPois();
        }
        int row = (int)((float)((int)(this.dividedHeight * 12.0f)) + this.dividedHeight / 2.0f);
        for (int i = 0; i < this.maxPoisToDisplay && (currentPoi = i + this.scrollOffset) <= this.pois.size() - 1; ++i) {
            CustomPoi poi2 = this.pois.get(currentPoi);
            PoiManagerWidget poiWidget = new PoiManagerWidget((int)(this.dividedWidth * 12.0f), row, (int)(this.dividedWidth * 38.0f), 20, poi2, this, this.dividedWidth, this.selectionMode, this.selectedPois.contains(poi2));
            row += 20;
            this.poiManagerWidgets.add(poiWidget);
            this.method_37063((class_364)poiWidget);
        }
    }

    private void sortPois() {
        switch (this.sortOrder.ordinal()) {
            case 0: {
                this.pois.sort(Comparator.comparing(CustomPoi::getIcon));
                break;
            }
            case 1: {
                this.pois.sort(Comparator.comparing(CustomPoi::getIcon).reversed());
                break;
            }
            case 2: {
                this.pois.sort(Comparator.comparing(CustomPoi::getName, String.CASE_INSENSITIVE_ORDER));
                break;
            }
            case 3: {
                this.pois.sort(Comparator.comparing(CustomPoi::getName, String.CASE_INSENSITIVE_ORDER).reversed());
                break;
            }
            case 4: {
                this.pois.sort(Comparator.comparing(poi -> poi.getLocation().getX()));
                break;
            }
            case 5: {
                this.pois.sort(Comparator.comparing(poi -> poi.getLocation().getX(), Comparator.reverseOrder()));
                break;
            }
            case 6: {
                this.pois.sort(Comparator.comparing(poi -> poi.getLocation().getY().orElse(null), Comparator.nullsFirst(Comparator.naturalOrder())));
                break;
            }
            case 7: {
                this.pois.sort(Comparator.comparing(poi -> poi.getLocation().getY().orElse(null), Comparator.nullsLast(Comparator.reverseOrder())));
                break;
            }
            case 8: {
                this.pois.sort(Comparator.comparing(poi -> poi.getLocation().getZ()));
                break;
            }
            case 9: {
                this.pois.sort(Comparator.comparing(poi -> poi.getLocation().getZ(), Comparator.reverseOrder()));
            }
        }
    }

    private void toggleMarkers(boolean addMarkers) {
        if (addMarkers) {
            this.selectedPois.forEach(poi -> MarkerModel.USER_WAYPOINTS_PROVIDER.addLocation(poi.getLocation().asLocation(), poi.getIcon(), poi.getColor(), poi.getColor(), poi.getName()));
        } else {
            this.selectedPois.forEach(poi -> MarkerModel.USER_WAYPOINTS_PROVIDER.removeLocation(poi.getLocation().asLocation()));
        }
    }

    private void toggleSelectAll(boolean select) {
        class_5250 tooltip;
        this.selectionMode = select;
        this.upButton.field_22764 = select;
        this.downButton.field_22764 = select;
        this.deleteSelectedButton.field_22763 = select;
        if (select) {
            this.selectedPois = this.pois;
            tooltip = class_2561.method_43469((String)"screens.wynntils.poiManagementGui.exportSelected.tooltip", (Object[])new Object[]{this.selectedPois.size()});
        } else {
            this.selectedPois.clear();
            tooltip = class_2561.method_43471((String)"screens.wynntils.poiManagementGui.exportAll.tooltip");
        }
        this.exportButton.method_47400(class_7919.method_47407((class_2561)tooltip));
        this.populatePois();
    }

    private boolean toggleSortOrder(PoiSortType sortType) {
        PoiSortOrder newOrder = null;
        boolean selected = true;
        switch (sortType.ordinal()) {
            case 0: {
                if (this.sortOrder == null) {
                    newOrder = PoiSortOrder.ICON_ASC;
                    break;
                }
                if (this.sortOrder != PoiSortOrder.ICON_ASC) break;
                newOrder = PoiSortOrder.ICON_DESC;
                break;
            }
            case 1: {
                if (this.sortOrder == null) {
                    newOrder = PoiSortOrder.NAME_ASC;
                    break;
                }
                if (this.sortOrder != PoiSortOrder.NAME_ASC) break;
                newOrder = PoiSortOrder.NAME_DESC;
                break;
            }
            case 2: {
                if (this.sortOrder == null) {
                    newOrder = PoiSortOrder.X_ASC;
                    break;
                }
                if (this.sortOrder != PoiSortOrder.X_ASC) break;
                newOrder = PoiSortOrder.X_DESC;
                break;
            }
            case 3: {
                if (this.sortOrder == null) {
                    newOrder = PoiSortOrder.Y_ASC;
                    break;
                }
                if (this.sortOrder != PoiSortOrder.Y_ASC) break;
                newOrder = PoiSortOrder.Y_DESC;
                break;
            }
            case 4: {
                if (this.sortOrder == null) {
                    newOrder = PoiSortOrder.Z_ASC;
                    break;
                }
                if (this.sortOrder != PoiSortOrder.Z_ASC) break;
                newOrder = PoiSortOrder.Z_DESC;
                break;
            }
            default: {
                selected = false;
            }
        }
        this.sortOrder = newOrder;
        return newOrder != null && selected;
    }

    private void updateAllUsedIcons() {
        this.filteredIcons = ((List)Managers.Feature.getFeatureInstance(MainMapFeature.class).customPois.get()).stream().map(CustomPoi::getIcon).distinct().collect(Collectors.toMap(Function.identity(), texture -> this.filteredIcons.getOrDefault(texture, true), (existing, replacement) -> existing, () -> new EnumMap(Texture.class)));
        this.filterButton.field_22764 = this.filteredIcons.size() > 1;
    }

    private boolean searchMatches(String poiName) {
        return StringUtils.partialMatch(poiName, this.searchInput.getTextBoxInput());
    }

    private void updateSelectedPoiPositions(int direction) {
        List orderedPois = this.pois.stream().filter(poi -> this.selectedPois.contains(poi)).collect(Collectors.toList());
        if (direction == 1) {
            Collections.reverse(orderedPois);
        }
        for (CustomPoi selectedPoi : orderedPois) {
            this.updatePoiPosition(selectedPoi, direction);
        }
    }

    private void deleteSelectedPois() {
        HiddenConfig<List<CustomPoi>> customPois = Managers.Feature.getFeatureInstance(MainMapFeature.class).customPois;
        for (CustomPoi poi : this.selectedPois) {
            this.deletePoi(poi, false);
        }
        customPois.touched();
        McUtils.sendMessageToClient((class_2561)class_2561.method_43469((String)"screens.wynntils.poiManagementGui.deletedPois", (Object[])new Object[]{this.selectedPois.size()}).method_27692(class_124.field_1060));
        if (((List)customPois.get()).isEmpty()) {
            this.selectAllButton.field_22763 = false;
            this.filterButton.field_22764 = false;
            this.iconSortButton.field_22764 = false;
            this.nameSortButton.field_22764 = false;
            this.xSortButton.field_22764 = false;
            this.ySortButton.field_22764 = false;
            this.zSortButton.field_22764 = false;
        }
        if (this.scrollOffset == Math.max(0, this.pois.size() - this.maxPoisToDisplay)) {
            this.scroll(-1);
        }
        this.toggleSelectAll(false);
    }

    private void importFromClipboard() {
        CustomPoi[] customPois;
        String clipboard = McUtils.mc().field_1774.method_1460();
        try {
            customPois = (CustomPoi[])JsonManager.GSON.fromJson(clipboard, CustomPoi[].class);
        }
        catch (JsonSyntaxException e) {
            McUtils.sendErrorToClient(class_1074.method_4662((String)"screens.wynntils.poiManagementGui.import.error", (Object[])new Object[0]));
            return;
        }
        if (customPois == null) {
            McUtils.sendErrorToClient(class_1074.method_4662((String)"screens.wynntils.poiManagementGui.import.error", (Object[])new Object[0]));
            return;
        }
        HiddenConfig<List<CustomPoi>> customPoiConfig = Managers.Feature.getFeatureInstance(MainMapFeature.class).customPois;
        ArrayList<CustomPoi> existingPois = new ArrayList<CustomPoi>((Collection)customPoiConfig.get());
        List<CustomPoi> poisToAdd = Stream.of(customPois).filter(newPoi -> !existingPois.contains(newPoi)).toList();
        existingPois.addAll(poisToAdd);
        customPoiConfig.setValue(existingPois);
        customPoiConfig.touched();
        Managers.Feature.getFeatureInstance(MainMapFeature.class).updateWaypoints();
        if (!((List)customPoiConfig.get()).isEmpty()) {
            this.searchInput.field_22764 = true;
            this.filterButton.field_22764 = true;
        }
        this.updateAllUsedIcons();
        this.populatePois();
        McUtils.sendMessageToClient((class_2561)class_2561.method_43469((String)"screens.wynntils.poiManagementGui.import.success", (Object[])new Object[]{poisToAdd.size()}).method_27692(class_124.field_1060));
    }

    private void exportToClipboard() {
        List poisToExport = this.selectedPois.isEmpty() ? (List)Managers.Feature.getFeatureInstance(MainMapFeature.class).customPois.get() : this.selectedPois;
        McUtils.mc().field_1774.method_1455(poisToExport.stream().map(arg_0 -> ((Gson)JsonManager.GSON).toJson(arg_0)).toList().toString());
        McUtils.sendMessageToClient((class_2561)class_2561.method_43469((String)"screens.wynntils.poiManagementGui.exportedPois", (Object[])new Object[]{poisToExport.size()}).method_27692(class_124.field_1060));
    }

    private void undoDelete() {
        HiddenConfig<List<CustomPoi>> allPois = Managers.Feature.getFeatureInstance(MainMapFeature.class).customPois;
        if (!((List)allPois.get()).contains(this.deletedPois.getLast())) {
            ((List)allPois.get()).add(this.deletedIndexes.getLast(), this.deletedPois.getLast());
            allPois.touched();
            Managers.Feature.getFeatureInstance(MainMapFeature.class).updateWaypoints();
            this.scrollOffset = Math.max(this.scrollOffset - 1, 0);
            this.updateAllUsedIcons();
            this.populatePois();
        }
        this.deletedIndexes.removeLast();
        this.deletedPois.removeLast();
        this.undoDeleteButton.field_22763 = !this.deletedIndexes.isEmpty();
    }

    public static enum PoiSortType {
        ICON,
        NAME,
        X,
        Y,
        Z;

    }

    private static enum PoiSortOrder {
        ICON_ASC,
        ICON_DESC,
        NAME_ASC,
        NAME_DESC,
        X_ASC,
        X_DESC,
        Y_ASC,
        Y_DESC,
        Z_ASC,
        Z_DESC;

    }
}

