/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.statistics;

import com.wynntils.core.components.Services;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.WynntilsListScreen;
import com.wynntils.screens.base.widgets.BackButton;
import com.wynntils.screens.base.widgets.FilterButton;
import com.wynntils.screens.base.widgets.PageSelectorButton;
import com.wynntils.screens.statistics.widgets.StatisticButton;
import com.wynntils.screens.wynntilsmenu.WynntilsMenuScreen;
import com.wynntils.services.statistics.type.StatisticEntry;
import com.wynntils.services.statistics.type.StatisticKind;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4587;

public final class WynntilsStatisticsScreen
extends WynntilsListScreen<StatisticKind, StatisticButton> {
    private StatisticKind highlightedStatisticKind;

    private WynntilsStatisticsScreen() {
        super((class_2561)class_2561.method_43471((String)"screens.wynntils.statistics.name"));
    }

    public static WynntilsStatisticsScreen create() {
        return new WynntilsStatisticsScreen();
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.method_37063((class_364)new BackButton((int)(((float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 16.0f) / 2.0f + (float)this.offsetX), 65 + this.offsetY, Texture.BACK_ARROW_OFFSET.width() / 2, Texture.BACK_ARROW_OFFSET.height(), WynntilsMenuScreen.create()));
        this.method_37063((class_364)new PageSelectorButton((int)((float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f + 50.0f - (float)Texture.FORWARD_ARROW_OFFSET.width() / 2.0f + (float)this.offsetX), Texture.CONTENT_BOOK_BACKGROUND.height() - 25 + this.offsetY, Texture.FORWARD_ARROW_OFFSET.width() / 2, Texture.FORWARD_ARROW_OFFSET.height(), false, this));
        this.method_37063((class_364)new PageSelectorButton(Texture.CONTENT_BOOK_BACKGROUND.width() - 50 + this.offsetX, Texture.CONTENT_BOOK_BACKGROUND.height() - 25 + this.offsetY, Texture.FORWARD_ARROW_OFFSET.width() / 2, Texture.FORWARD_ARROW_OFFSET.height(), true, this));
        this.method_37063((class_364)new FilterButton((int)(((float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 15.0f) / 2.0f + (float)this.offsetX), 157 + this.offsetY, 30, 30, Texture.FAVORITE_ICON, false, List.of(class_2561.method_43470((String)"[>] ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.statistics.modeButton.name").method_27692(class_124.field_1067).method_27692(class_124.field_1060))), List.of(class_2561.method_43471((String)"screens.wynntils.statistics.modeButton.descriptionOverall").method_27692(class_124.field_1080), class_2561.method_43473(), class_2561.method_43471((String)"screens.wynntils.statistics.modeButton.enabled").method_27692(class_124.field_1080)), List.of(class_2561.method_43471((String)"screens.wynntils.statistics.modeButton.descriptionSingle").method_27692(class_124.field_1080), class_2561.method_43473(), class_2561.method_43471((String)"screens.wynntils.statistics.modeButton.disabled").method_27692(class_124.field_1080)), () -> {
            Storage<Boolean> screenOverallMode;
            screenOverallMode.store((Boolean)(screenOverallMode = Services.Statistics.screenOverallMode).get() == false);
            this.reloadElements();
        }, Services.Statistics.screenOverallMode::get));
    }

    @Override
    public void doRender(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4587 poseStack = guiGraphics.method_51448();
        this.renderBackgroundTexture(poseStack);
        this.renderTitle(poseStack, class_1074.method_4662((String)"screens.wynntils.statistics.name", (Object[])new Object[0]));
        this.renderVersion(poseStack);
        this.renderWidgets(guiGraphics, mouseX, mouseY, partialTick);
        if (this.elements.isEmpty()) {
            this.renderNoElementsHelper(poseStack, class_1074.method_4662((String)"screens.wynntils.statistics.noStatistics", (Object[])new Object[0]));
        }
        this.renderDescription(poseStack);
        this.renderPageInfo(poseStack, this.currentPage + 1, this.maxPage + 1);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderDescription(class_4587 poseStack) {
        if (this.highlightedStatisticKind == null) {
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.statistics.noItemSelected", (Object[])new Object[0])), (float)(20 + this.offsetX), (float)(100 + this.offsetY), (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 20.0f, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE);
            return;
        }
        StatisticEntry entry = (Boolean)Services.Statistics.screenOverallMode.get() != false ? Services.Statistics.getOverallStatistic(this.highlightedStatisticKind) : Services.Statistics.getStatistic(this.highlightedStatisticKind);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(this.highlightedStatisticKind.getName()), (float)(20 + this.offsetX), (float)(75 + this.offsetY), ((float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 20.0f) / 1.2f, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE, 1.2f);
        switch (this.highlightedStatisticKind.getType()) {
            case COUNT: {
                this.renderCountStatistics(poseStack, this.highlightedStatisticKind, entry);
                break;
            }
            case ADVANCED: {
                this.renderAdvancedStatistics(poseStack, this.highlightedStatisticKind, entry);
            }
        }
    }

    private void renderCountStatistics(class_4587 poseStack, StatisticKind statisticKind, StatisticEntry entry) {
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.statistics.count", (Object[])new Object[]{statisticKind.getFormattedValue(entry.count())})), (float)(20 + this.offsetX), (float)(105 + this.offsetY), (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 20.0f, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE);
    }

    private void renderAdvancedStatistics(class_4587 poseStack, StatisticKind statisticKind, StatisticEntry entry) {
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.statistics.total", (Object[])new Object[]{statisticKind.getFormattedValue(entry.total())})), (float)(20 + this.offsetX), (float)(105 + this.offsetY), (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 20.0f, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.statistics.count", (Object[])new Object[]{entry.count()})), (float)(20 + this.offsetX), (float)(115 + this.offsetY), (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 20.0f, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.statistics.min", (Object[])new Object[]{statisticKind.getFormattedValue(entry.min())})), (float)(20 + this.offsetX), (float)(125 + this.offsetY), (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 20.0f, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.statistics.max", (Object[])new Object[]{statisticKind.getFormattedValue(entry.max())})), (float)(20 + this.offsetX), (float)(135 + this.offsetY), (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 20.0f, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.statistics.average", (Object[])new Object[]{statisticKind.getFormattedValue(entry.average())})), (float)(20 + this.offsetX), (float)(145 + this.offsetY), (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 20.0f, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE);
    }

    public void setHighlightedStatisticKind(StatisticKind kind) {
        this.highlightedStatisticKind = kind;
    }

    public StatisticKind getHighlightedStatisticKind() {
        return this.highlightedStatisticKind;
    }

    @Override
    protected StatisticButton getButtonFromElement(int i) {
        int offset = i % this.getElementsPerPage();
        return new StatisticButton((int)((float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f + 15.0f + (float)this.offsetX), offset * 13 + 25 + this.offsetY, Texture.CONTENT_BOOK_BACKGROUND.width() / 2 - 37, 9, (StatisticKind)((Object)this.elements.get(i)), this);
    }

    @Override
    protected void reloadElementsList(String searchTerm) {
        this.elements.addAll(Arrays.stream(StatisticKind.values()).filter(statisticEntry -> StringUtils.partialMatch(statisticEntry.getName(), searchTerm)).toList());
    }
}

