/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.territorymanagement;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.core.text.type.StyleType;
import com.wynntils.handlers.wrappedscreen.WrappedScreenHolder;
import com.wynntils.handlers.wrappedscreen.type.WrappedScreenInfo;
import com.wynntils.mc.event.ContainerSetContentEvent;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.models.items.items.gui.TerritoryItem;
import com.wynntils.models.territories.type.GuildResource;
import com.wynntils.models.territories.type.TerritoryConnectionType;
import com.wynntils.models.territories.type.TerritoryUpgrade;
import com.wynntils.screens.territorymanagement.TerritoryManagementScreen;
import com.wynntils.screens.territorymanagement.highlights.TerritoryBonusEffectHighlighter;
import com.wynntils.screens.territorymanagement.highlights.TerritoryHighlighter;
import com.wynntils.screens.territorymanagement.highlights.TerritoryTypeHighlighter;
import com.wynntils.screens.territorymanagement.type.TerritoryColor;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.type.CappedValue;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.wynn.ContainerUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.neoforged.bus.api.SubscribeEvent;

public class TerritoryManagementHolder
extends WrappedScreenHolder<TerritoryManagementScreen> {
    private static final String SELECT_TERRITORIES_TITLE = "Select Territories";
    private static final Pattern TITLE_PATTERN = Pattern.compile("(?:.+: Territories)|(?:Select Territories)");
    private static final int ITEMS_PER_CONTAINER_PAGE = 45;
    private static final int ITEMS_PER_PAGE = 35;
    private static final int ITEMS_PER_ROW = 7;
    private static final Pattern NEXT_PAGE_PATTERN = Pattern.compile("\u00a7a\u00a7lNext Page");
    private static final Pattern PREVIOUS_PAGE_PATTERN = Pattern.compile("\u00a7a\u00a7lPrevious Page");
    private static final int NEXT_PAGE_SLOT = 27;
    private static final int PREVIOUS_PAGE_SLOT = 9;
    private static final int APPLY_BUTTON_SLOT = 0;
    private static final int APPLY_DISABLED_DAMAGE = 17;
    private static final int APPLY_UNCONFIRMED_DAMAGE = 19;
    private static final int APPLY_CONFIRMED_DAMAGE = 20;
    private static final int REQUEST_LOAD_DELAY = 5;
    private static final int SELECTION_MODE_LOAD_DELAY = 20;
    private static final int FORCED_LOAD_DELAY = 20;
    private final List<TerritoryHighlighter> highlighters = new ArrayList<TerritoryHighlighter>();
    private TerritoryManagementScreen wrappedScreen;
    private int currentPage;
    private int requestedPage;
    private int loadedItems;
    private long nextRequestTicks;
    private long lastItemLoadedTicks;
    private boolean initialLoadFinished;
    private Int2ObjectSortedMap<Pair<class_1799, TerritoryItem>> territories = new Int2ObjectAVLTreeMap();
    private Map<TerritoryItem, TerritoryConnectionType> territoryConnections = Map.of();
    private boolean selectionMode;
    private String territoryToBeClicked;
    private Set<String> selectedTerritories = new HashSet<String>();
    private int currentClick;
    private long lastClickTicks;

    public TerritoryManagementHolder() {
        this.registerHighlighter(new TerritoryBonusEffectHighlighter());
        this.registerHighlighter(new TerritoryTypeHighlighter(this));
    }

    @SubscribeEvent
    public void onContainerSetContent(ContainerSetContentEvent.Post event) {
        if (event.getContainerId() != this.wrappedScreen.getWrappedScreenInfo().containerId()) {
            return;
        }
        for (int i = 0; i < event.getItems().size(); ++i) {
            Optional<TerritoryItem> territoryItemOpt;
            if (i % 9 < 2 || i >= 45) continue;
            ++this.loadedItems;
            class_1799 itemStack = event.getItems().get(i);
            int absSlot = this.getAbsoluteSlot(i);
            if (absSlot == this.currentClick) {
                this.currentClick = -1;
                this.lastClickTicks = Integer.MAX_VALUE;
            }
            if ((territoryItemOpt = Models.Item.asWynnItem(itemStack, TerritoryItem.class)).isEmpty()) {
                this.territories.remove(absSlot);
            } else {
                TerritoryItem territoryItem = territoryItemOpt.get();
                this.territories.put(absSlot, Pair.of(itemStack, territoryItem));
                if (!this.isSinglePage() && Objects.equals(this.territoryToBeClicked, territoryItem.getName())) {
                    this.clickOnTerritory(absSlot);
                }
            }
            this.lastItemLoadedTicks = McUtils.player().field_6012;
            this.updateRenderedItems();
            if (this.loadedItems < 35) continue;
            this.requestedPage = -1;
            this.loadedItems = 0;
            this.nextRequestTicks = McUtils.player().field_6012 + (this.selectionMode ? 20 : 5);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        if ((long)McUtils.player().field_6012 >= this.lastItemLoadedTicks + 20L) {
            WynntilsMod.warn("Forcing the next page load, as the previous one did not finish properly.");
            this.requestedPage = -1;
            this.loadedItems = 0;
            this.nextRequestTicks = McUtils.player().field_6012;
            this.lastItemLoadedTicks = Integer.MAX_VALUE;
        }
        if ((long)McUtils.player().field_6012 >= this.lastClickTicks + 20L) {
            WynntilsMod.warn("Forcing the next click, as the previous one did not finish properly.");
            this.currentClick = -1;
            this.lastClickTicks = Integer.MAX_VALUE;
        }
        if (this.initialLoadFinished && this.selectionMode && !this.shouldChangePageForSelection()) {
            this.tryClickNextSelection();
            return;
        }
        if ((long)McUtils.player().field_6012 < this.nextRequestTicks) {
            return;
        }
        if (this.isSinglePage()) {
            return;
        }
        if (this.requestedPage != -1) {
            return;
        }
        boolean forwardPage = StyledText.fromComponent(((class_1799)this.wrappedScreen.getWrappedScreenInfo().containerMenu().method_7602().get(27)).method_7964()).matches(NEXT_PAGE_PATTERN);
        if (forwardPage) {
            this.requestedPage = this.currentPage + 1;
        } else {
            this.requestedPage = this.currentPage - 1;
            this.initialLoadFinished = true;
        }
        this.doNextRequest();
        this.nextRequestTicks = Integer.MAX_VALUE;
    }

    @Override
    protected Pattern getReplacedScreenTitlePattern() {
        return TITLE_PATTERN;
    }

    @Override
    protected TerritoryManagementScreen createWrappedScreen(WrappedScreenInfo wrappedScreenInfo) {
        return new TerritoryManagementScreen(wrappedScreenInfo, this);
    }

    @Override
    protected void setWrappedScreen(TerritoryManagementScreen wrappedScreen) {
        this.wrappedScreen = wrappedScreen;
        this.reset();
        this.selectionMode = StyledText.fromComponent(wrappedScreen.getWrappedScreenInfo().screen().method_25440()).equalsString(SELECT_TERRITORIES_TITLE, StyleType.NONE);
    }

    @Override
    protected void reset() {
        this.currentPage = 0;
        this.requestedPage = -1;
        this.loadedItems = 0;
        this.nextRequestTicks = Integer.MAX_VALUE;
        this.lastItemLoadedTicks = Integer.MAX_VALUE;
        this.initialLoadFinished = false;
        this.territories = new Int2ObjectAVLTreeMap();
        this.territoryConnections = new HashMap<TerritoryItem, TerritoryConnectionType>();
        this.selectionMode = false;
        this.territoryToBeClicked = null;
        this.selectedTerritories = new HashSet<String>();
        this.currentClick = -1;
        this.lastClickTicks = Integer.MAX_VALUE;
    }

    public TerritoryColor getTerritoryColor(TerritoryItem territoryItem) {
        CustomColor borderColor = CustomColor.NONE;
        ArrayList<CustomColor> backgroundColors = new ArrayList<CustomColor>();
        for (TerritoryHighlighter highlighter : this.highlighters) {
            Optional<CustomColor> highlighterBorderColor = highlighter.getBorderColor(territoryItem);
            if (highlighterBorderColor.isPresent() && borderColor == CustomColor.NONE) {
                borderColor = highlighterBorderColor.get();
            }
            backgroundColors.addAll(highlighter.getBackgroundColors(territoryItem));
        }
        return new TerritoryColor(borderColor, backgroundColors);
    }

    public Collection<Pair<class_1799, TerritoryItem>> territoryItems() {
        List<String> territoryNames = this.territories.values().stream().map(Pair::b).map(TerritoryItem::getName).distinct().toList();
        return territoryNames.stream().map(name -> this.territories.values().stream().filter(pair -> ((TerritoryItem)pair.b()).getName().equals(name)).findFirst().orElseThrow()).toList();
    }

    public Map<TerritoryItem, TerritoryConnectionType> territoryConnections() {
        return this.territoryConnections;
    }

    public boolean isSelectionMode() {
        return this.selectionMode;
    }

    public int getCountForConnectionType(TerritoryConnectionType territoryConnectionType) {
        return (int)this.territoryConnections.values().stream().filter(type -> type == territoryConnectionType).count();
    }

    public int getCountForUpgrade(TerritoryUpgrade upgrade) {
        return (int)this.territories.values().stream().map(Pair::b).map(TerritoryItem::getUpgrades).map(Map::keySet).flatMap(Collection::stream).filter(upgrade::equals).count();
    }

    public int getOverallProductionForResource(GuildResource resource) {
        return this.territories.values().stream().map(Pair::b).map(TerritoryItem::getProduction).mapToInt(production -> production.getOrDefault((Object)resource, 0)).sum();
    }

    public CappedValue getOverallStorageForResource(GuildResource resource) {
        return this.territories.values().stream().map(Pair::b).map(TerritoryItem::getStorage).map(storage -> storage.getOrDefault((Object)resource, new CappedValue(0, 0))).reduce((cappedValue1, cappedValue2) -> new CappedValue(cappedValue1.current() + cappedValue2.current(), cappedValue1.max() + cappedValue2.max())).orElse(new CappedValue(0, 0));
    }

    public long getOverallUsageForResource(GuildResource resource) {
        return this.territories.values().stream().map(Pair::b).map(TerritoryItem::getUpgrades).flatMap(upgrades -> upgrades.entrySet().stream()).filter(entry -> ((TerritoryUpgrade)((Object)((Object)entry.getKey()))).getCostResource() == resource).map(entry -> ((TerritoryUpgrade)((Object)((Object)entry.getKey()))).getLevels()[(Integer)entry.getValue()]).mapToLong(TerritoryUpgrade.Level::cost).sum();
    }

    public void territoryItemClicked(TerritoryItem territoryItem) {
        if (this.selectionMode) {
            if (this.selectedTerritories.contains(territoryItem.getName())) {
                this.selectedTerritories.remove(territoryItem.getName());
            } else {
                this.selectedTerritories.add(territoryItem.getName());
            }
        } else {
            if (!Models.War.isWarActive()) {
                Handlers.Command.sendCommandImmediately("gu territory " + territoryItem.getName());
                return;
            }
            this.territoryToBeClicked = territoryItem.getName();
        }
        int absSlot = this.getAbsoluteSlotForItem(territoryItem);
        int itemPage = absSlot / 35;
        if (absSlot == -1) {
            WynntilsMod.warn("Could not find the slot for the territory item when trying to click it: " + territoryItem.getName());
            return;
        }
        if (this.selectionMode && this.currentClick != -1) {
            return;
        }
        this.currentClick = absSlot;
        this.lastClickTicks = McUtils.player().field_6012;
        if (this.currentPage != itemPage) {
            return;
        }
        this.clickOnTerritory(this.getRelativeSlot(this.currentClick));
    }

    public Texture getApplyButtonTexture() {
        if (!this.selectionMode) {
            return Texture.CHECKMARK_GREEN;
        }
        class_1799 applyButton = (class_1799)this.wrappedScreen.getWrappedScreenInfo().containerMenu().method_7602().get(0);
        if (applyButton.method_7919() == 17) {
            return Texture.CHECKMARK_GRAY;
        }
        if (applyButton.method_7919() == 19) {
            return Texture.CHECKMARK_YELLOW;
        }
        if (applyButton.method_7919() == 20) {
            return Texture.CHECKMARK_GREEN;
        }
        WynntilsMod.warn("Unknown apply button damage value: " + applyButton.method_7919());
        return Texture.CHECKMARK_GREEN;
    }

    private void doNextRequest() {
        class_2371 items = this.wrappedScreen.getWrappedScreenInfo().containerMenu().method_7602();
        if (this.currentPage == this.requestedPage) {
            WynntilsMod.warn("Already at the requested page. Current page: " + this.currentPage + ", Requested page: " + this.requestedPage);
            return;
        }
        if (this.requestedPage > this.currentPage) {
            ++this.currentPage;
            ContainerUtils.clickOnSlot(27, this.wrappedScreen.getWrappedScreenInfo().containerId(), 0, (List<class_1799>)items);
            return;
        }
        if (this.requestedPage < this.currentPage) {
            if (this.currentPage == 0) {
                this.territories.clear();
                this.territoryConnections.clear();
            } else {
                --this.currentPage;
            }
            ContainerUtils.clickOnSlot(9, this.wrappedScreen.getWrappedScreenInfo().containerId(), 0, (List<class_1799>)items);
            return;
        }
    }

    private boolean shouldChangePageForSelection() {
        Set territoriesToBeSelectedOnDifferentPages;
        Set currentlySelectedTerritories = this.territories.values().stream().map(Pair::b).filter(TerritoryItem::isSelected).map(TerritoryItem::getName).collect(Collectors.toUnmodifiableSet());
        List<String> territoriesOnCurrentPage = this.getItemsOnPage(this.currentPage).stream().map(TerritoryItem::getName).toList();
        Set selectedTerritoriesOnCurrentPage = this.territories.values().stream().map(Pair::b).filter(TerritoryItem::isSelected).map(TerritoryItem::getName).filter(territoriesOnCurrentPage::contains).collect(Collectors.toUnmodifiableSet());
        Set territoriesToBeSelectedOnCurrentPage = this.selectedTerritories.stream().filter(territoriesOnCurrentPage::contains).collect(Collectors.toUnmodifiableSet());
        if (!selectedTerritoriesOnCurrentPage.equals(territoriesToBeSelectedOnCurrentPage)) {
            return false;
        }
        Set selectedTerritoriesOnDifferentPages = this.territories.values().stream().map(Pair::b).filter(TerritoryItem::isSelected).map(TerritoryItem::getName).filter(name -> !territoriesOnCurrentPage.contains(name)).collect(Collectors.toUnmodifiableSet());
        return !selectedTerritoriesOnDifferentPages.equals(territoriesToBeSelectedOnDifferentPages = this.selectedTerritories.stream().filter(territory -> !territoriesOnCurrentPage.contains(territory)).collect(Collectors.toUnmodifiableSet()));
    }

    private void tryClickNextSelection() {
        if (this.currentClick != -1) {
            return;
        }
        int nextSelection = this.getNextSelectionInQueue();
        if (nextSelection == -1) {
            return;
        }
        this.currentClick = nextSelection;
        this.lastClickTicks = McUtils.player().field_6012;
        this.clickOnTerritory(this.getRelativeSlot(this.currentClick));
    }

    private void clickOnTerritory(int slot) {
        ContainerUtils.clickOnSlot(slot, this.wrappedScreen.getWrappedScreenInfo().containerId(), 0, (List<class_1799>)this.wrappedScreen.getWrappedScreenInfo().containerMenu().method_7602());
    }

    private boolean isSinglePage() {
        class_2371 items = this.wrappedScreen.getWrappedScreenInfo().containerMenu().method_7602();
        return ((class_1799)items.get(27)).method_7960() && ((class_1799)items.get(9)).method_7960() && this.territories.size() <= 35;
    }

    private int getNextSelectionInQueue() {
        if (this.selectedTerritories.isEmpty()) {
            return -1;
        }
        List<TerritoryItem> itemsOnPage = this.getItemsOnPage(this.currentPage);
        for (TerritoryItem territoryItem : itemsOnPage) {
            if (!territoryItem.isSelected() && this.selectedTerritories.contains(territoryItem.getName())) {
                return this.getAbsoluteSlotForItem(territoryItem);
            }
            if (!territoryItem.isSelected() || this.selectedTerritories.contains(territoryItem.getName())) continue;
            return this.getAbsoluteSlotForItem(territoryItem);
        }
        return -1;
    }

    private int getAbsoluteSlot(int slot) {
        return this.currentPage * 35 + slot / 9 * 7 + slot % 9 - 2;
    }

    private int getRelativeSlot(int absSlot) {
        return absSlot + (absSlot / 7 + 1) * 2 - this.currentPage * 45;
    }

    private int getAbsoluteSlotForItem(TerritoryItem territoryItem) {
        return this.territories.int2ObjectEntrySet().stream().filter(entry -> ((TerritoryItem)((Pair)entry.getValue()).b()).getName().equals(territoryItem.getName())).mapToInt(Map.Entry::getKey).findFirst().orElse(-1);
    }

    private List<TerritoryItem> getItemsOnPage(int page) {
        return this.territories.int2ObjectEntrySet().stream().filter(entry -> entry.getIntKey() / 35 == page).map(Map.Entry::getValue).map(Pair::b).collect(Collectors.toList());
    }

    private void updateRenderedItems() {
        this.territoryConnections = Models.Territory.getTerritoryConnections(this.territories.values().stream().map(Pair::b).collect(Collectors.toList()));
        this.wrappedScreen.updateTerritoryItems();
    }

    private void registerHighlighter(TerritoryHighlighter highlighter) {
        this.highlighters.add(highlighter);
    }
}

