/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.trademarket;

import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.wrappedscreen.WrappedScreenHolder;
import com.wynntils.handlers.wrappedscreen.type.WrappedScreenInfo;
import com.wynntils.mc.event.ContainerSetContentEvent;
import com.wynntils.mc.event.ContainerSetSlotEvent;
import com.wynntils.screens.trademarket.TradeMarketSearchResultScreen;
import com.wynntils.services.itemfilter.type.ItemSearchQuery;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.wynn.ContainerUtils;
import com.wynntils.utils.wynn.ItemUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.neoforged.bus.api.SubscribeEvent;

public class TradeMarketSearchResultHolder
extends WrappedScreenHolder<TradeMarketSearchResultScreen> {
    private static final Pattern TITLE_PATTERN = Pattern.compile("Search Results");
    private static final Pattern PAGE_PATTERN = Pattern.compile("\u00a7f\u00a7lPage (\\d+)\u00a7a (:?[<>]\u00a72[<>]\u00a7a)+[<>]");
    private static final int EXPECTED_ITEMS_PER_PAGE = 42;
    private static final int LAST_ITEM_SLOT = 54;
    private static final int PAGE_BATCH_SIZE = 10;
    private static final int PREVIOUS_PAGE_SLOT = 26;
    private static final int NEXT_PAGE_SLOT = 35;
    private static final int BACK_TO_SEARCH_SLOT = 8;
    private static final int SORT_MODE_SLOT = 53;
    private TradeMarketSearchResultScreen wrappedScreen;
    private int requestedPage = -1;
    private class_1799 requestedItem;
    private PageLoadingMode pageLoadingMode = PageLoadingMode.NONE;
    private QueuedAction queuedAction;
    private int currentPage = 0;
    private int parsedCurrentPage = 0;
    private boolean initialPageLoadRequested = false;
    private boolean allPagesLoaded = false;
    private Map<Integer, Int2ObjectSortedMap<class_1799>> itemMap = new TreeMap<Integer, Int2ObjectSortedMap<class_1799>>();
    private int pageItemCount = 0;
    private List<class_1799> filteredItems = new ArrayList<class_1799>();
    private class_1799 sortingButtonItem = class_1799.field_8037;

    @SubscribeEvent
    public void onContainerSetContent(ContainerSetContentEvent.Pre event) {
        if (this.pageLoadingMode == PageLoadingMode.NONE || this.requestedPage == -1) {
            return;
        }
        WrappedScreenInfo wrappedScreenInfo = this.wrappedScreen.getWrappedScreenInfo();
        if (event.getContainerId() != wrappedScreenInfo.containerId()) {
            return;
        }
        event.setCanceled(true);
        this.pageItemCount = 0;
        if (event.getItems().size() >= 53) {
            this.sortingButtonItem = event.getItems().get(53);
            this.wrappedScreen.onSortingModeChanged();
            return;
        }
    }

    @SubscribeEvent
    public void onContainerSetSlot(ContainerSetSlotEvent.Pre event) {
        if (this.pageLoadingMode == PageLoadingMode.NONE || this.requestedPage == -1) {
            return;
        }
        WrappedScreenInfo wrappedScreenInfo = this.wrappedScreen.getWrappedScreenInfo();
        if (event.getContainerId() != wrappedScreenInfo.containerId()) {
            return;
        }
        int slot = event.getSlot();
        event.setCanceled(true);
        class_1799 itemStack = event.getItemStack();
        this.handleSetItem(slot, itemStack);
        this.updateDisplayItems(this.wrappedScreen.getSearchQuery());
    }

    @Override
    protected Pattern getReplacedScreenTitlePattern() {
        return TITLE_PATTERN;
    }

    @Override
    protected TradeMarketSearchResultScreen createWrappedScreen(WrappedScreenInfo wrappedScreenInfo) {
        return new TradeMarketSearchResultScreen(wrappedScreenInfo, this);
    }

    @Override
    protected void setWrappedScreen(TradeMarketSearchResultScreen wrappedScreen) {
        this.wrappedScreen = wrappedScreen;
        this.pageLoadingMode = PageLoadingMode.LOAD_ITEMS;
        this.requestedPage = 0;
    }

    @Override
    protected void reset() {
        this.requestedPage = -1;
        this.requestedItem = null;
        this.pageLoadingMode = PageLoadingMode.NONE;
        this.queuedAction = null;
        this.allPagesLoaded = false;
        this.currentPage = 0;
        this.parsedCurrentPage = 0;
        this.initialPageLoadRequested = false;
        this.itemMap = new TreeMap<Integer, Int2ObjectSortedMap<class_1799>>();
        this.pageItemCount = 0;
        this.filteredItems = new ArrayList<class_1799>();
        this.sortingButtonItem = class_1799.field_8037;
        this.wrappedScreen = null;
    }

    public void clickOnItem(class_1799 clickedItem) {
        ObjectSortedSet currentPageEntries = this.itemMap.getOrDefault(this.currentPage, (Int2ObjectSortedMap<class_1799>)new Int2ObjectAVLTreeMap()).int2ObjectEntrySet();
        for (Int2ObjectMap.Entry entry : currentPageEntries) {
            if (!ItemUtils.isItemEqual((class_1799)entry.getValue(), clickedItem)) continue;
            WrappedScreenInfo wrappedScreenInfo = this.wrappedScreen.getWrappedScreenInfo();
            ContainerUtils.clickOnSlot(entry.getIntKey(), wrappedScreenInfo.containerId(), 0, (List<class_1799>)wrappedScreenInfo.containerMenu().method_7602());
            return;
        }
        for (int i = 0; i < this.itemMap.size(); ++i) {
            if (i == this.currentPage) continue;
            boolean foundItem = false;
            Int2ObjectSortedMap<class_1799> itemsOnPage = this.itemMap.get(i);
            for (class_1799 itemStack : itemsOnPage.values()) {
                if (!ItemUtils.isItemEqual(itemStack, clickedItem)) continue;
                foundItem = true;
                break;
            }
            if (!foundItem) continue;
            this.runOrQueueAction(new QueuedAction(PageLoadingMode.CLICK_ITEM, i, clickedItem));
            return;
        }
        this.wrappedScreen.setCurrentState((class_2561)class_2561.method_43470((String)"Couldn't find item"));
    }

    public void goBackToSearch() {
        WrappedScreenInfo wrappedScreenInfo = this.wrappedScreen.getWrappedScreenInfo();
        ContainerUtils.clickOnSlot(8, wrappedScreenInfo.containerId(), 0, (List<class_1799>)wrappedScreenInfo.containerMenu().method_7602());
    }

    public void loadNextPageBatch() {
        if (this.allPagesLoaded) {
            return;
        }
        this.runOrQueueAction(new QueuedAction(PageLoadingMode.LOAD_ITEMS, this.itemMap.size() - 1 + 10, null));
    }

    public void changeSortingMode(int mouseButton) {
        WrappedScreenInfo wrappedScreenInfo = this.wrappedScreen.getWrappedScreenInfo();
        ContainerUtils.clickOnSlot(53, wrappedScreenInfo.containerId(), mouseButton, (List<class_1799>)wrappedScreenInfo.containerMenu().method_7602());
        this.itemMap = new TreeMap<Integer, Int2ObjectSortedMap<class_1799>>();
        this.pageItemCount = 0;
        this.pageLoadingMode = PageLoadingMode.LOAD_ITEMS;
        this.requestedPage = 0;
        this.queuedAction = null;
    }

    public List<class_2561> getSortingItemTooltip() {
        return LoreUtils.getTooltipLines(this.sortingButtonItem);
    }

    public void updateDisplayItems(ItemSearchQuery searchQuery) {
        this.filteredItems.clear();
        Stream items = this.itemMap.values().stream().map(map -> (class_1799[])map.values().toArray((Object[])new class_1799[0])).flatMap(Stream::of);
        List matchingItems = Services.ItemFilter.filterAndSort(searchQuery, items.toList());
        this.filteredItems.addAll(matchingItems);
    }

    public List<class_1799> getFilteredItems() {
        return this.filteredItems;
    }

    public int getPageLoadBatchSize() {
        return 10;
    }

    private void handleSetItem(int slot, class_1799 itemStack) {
        if (slot == 53) {
            this.sortingButtonItem = itemStack;
            this.wrappedScreen.onSortingModeChanged();
            return;
        }
        if (slot == 26 || slot == 35) {
            StyledText itemName = StyledText.fromComponent(itemStack.method_7964());
            Matcher matcher = itemName.getMatcher(PAGE_PATTERN);
            if (matcher.matches()) {
                int pageItemNumber = Integer.parseInt(matcher.group(1)) - 1;
                this.parsedCurrentPage = slot == 26 ? pageItemNumber + 1 : pageItemNumber - 1;
            }
            return;
        }
        if (slot % 9 >= 7 || slot >= 54) {
            return;
        }
        Int2ObjectSortedMap currentItems = this.itemMap.computeIfAbsent(this.currentPage, k -> new Int2ObjectAVLTreeMap());
        boolean emptyItem = this.isEmptyItem(itemStack);
        if (!emptyItem) {
            currentItems.put(slot, (Object)itemStack);
        } else {
            currentItems.remove(slot);
        }
        ++this.pageItemCount;
        switch (this.pageLoadingMode.ordinal()) {
            case 0: {
                this.pageLoadedWhileLoadingItems((Int2ObjectSortedMap<class_1799>)currentItems);
                break;
            }
            case 1: {
                this.pageLoadedWhileSelectingItem((Int2ObjectSortedMap<class_1799>)currentItems, slot, itemStack);
            }
        }
    }

    private void pageLoadedWhileLoadingItems(Int2ObjectSortedMap<class_1799> currentItems) {
        this.wrappedScreen.setCurrentState((class_2561)class_2561.method_43470((String)("Loading page " + (this.currentPage + 1) + "...")));
        if (this.pageItemCount != 42) {
            return;
        }
        if (!this.initialPageLoadRequested) {
            this.initialPageLoadRequested = true;
            if (this.parsedCurrentPage == 0) {
                this.loadItemsUntilPage(10, false);
            } else {
                this.itemMap.put(this.parsedCurrentPage, this.itemMap.remove(this.currentPage));
                this.currentPage = this.parsedCurrentPage;
                this.loadItemsUntilPage(1, true);
                return;
            }
        }
        if (currentItems.size() < 42) {
            this.wrappedScreen.setCurrentState((class_2561)class_2561.method_43470((String)"All pages loaded"));
            this.allPagesLoaded = true;
            this.startNextQueuedAction();
            return;
        }
        if (this.currentPage == this.requestedPage) {
            this.wrappedScreen.setCurrentState((class_2561)class_2561.method_43470((String)(this.itemMap.size() + " pages loaded")));
            this.startNextQueuedAction();
            return;
        }
        this.goToNextPage();
    }

    private void pageLoadedWhileSelectingItem(Int2ObjectSortedMap<class_1799> currentItems, int slot, class_1799 itemStack) {
        this.wrappedScreen.setCurrentState((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Clicking on ")).method_10852(this.requestedItem.method_7964()).method_10852((class_2561)class_2561.method_43470((String)"...")));
        if (ItemUtils.isItemEqual(itemStack, this.requestedItem)) {
            WrappedScreenInfo wrappedScreenInfo = this.wrappedScreen.getWrappedScreenInfo();
            ContainerUtils.clickOnSlot(slot, wrappedScreenInfo.containerId(), 0, (List<class_1799>)wrappedScreenInfo.containerMenu().method_7602());
            this.startNextQueuedAction();
            return;
        }
        if (this.pageItemCount == 42) {
            if (this.currentPage == this.requestedPage) {
                this.wrappedScreen.setCurrentState((class_2561)class_2561.method_43470((String)"Couldn't click on item"));
                this.startNextQueuedAction();
                return;
            }
            this.goToNextPage();
        }
    }

    private void goToNextPage() {
        int clickSlot;
        if (this.requestedPage == -1 || this.currentPage == this.requestedPage) {
            return;
        }
        this.pageItemCount = 0;
        if (this.currentPage < this.requestedPage) {
            clickSlot = 35;
            ++this.currentPage;
        } else {
            clickSlot = 26;
            --this.currentPage;
        }
        WrappedScreenInfo wrappedScreenInfo = this.wrappedScreen.getWrappedScreenInfo();
        ContainerUtils.clickOnSlot(clickSlot, wrappedScreenInfo.containerId(), 0, (List<class_1799>)wrappedScreenInfo.containerMenu().method_7602());
    }

    private void startNextQueuedAction() {
        this.pageLoadingMode = PageLoadingMode.NONE;
        this.requestedPage = -1;
        this.runQueuedAction();
    }

    private void runQueuedAction() {
        if (this.queuedAction == null) {
            return;
        }
        this.runOrQueueAction(this.queuedAction);
        this.queuedAction = null;
    }

    private void runOrQueueAction(QueuedAction action) {
        if (this.pageLoadingMode == PageLoadingMode.NONE) {
            this.pageLoadingMode = action.pageLoadingMode();
            this.requestedPage = action.requestedPage();
            this.requestedItem = action.requestedItemStack();
            this.goToNextPage();
        } else if (this.queuedAction == null) {
            this.queuedAction = action;
        }
    }

    private void loadItemsUntilPage(int page, boolean forcePageLoad) {
        this.pageLoadingMode = PageLoadingMode.LOAD_ITEMS;
        this.requestedPage = page - 1;
        if (forcePageLoad) {
            this.goToNextPage();
        }
    }

    private boolean isEmptyItem(class_1799 itemStack) {
        LinkedList<StyledText> loreTag = LoreUtils.getLore(itemStack);
        return itemStack.method_7909() == class_1802.field_8749 && (loreTag == null || loreTag.isEmpty());
    }

    public static enum PageLoadingMode {
        LOAD_ITEMS,
        CLICK_ITEM,
        NONE;

    }

    public record QueuedAction(PageLoadingMode pageLoadingMode, int requestedPage, class_1799 requestedItemStack) {
    }
}

