/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.trademarket.widgets;

import com.wynntils.core.components.Models;
import com.wynntils.screens.base.TooltipProvider;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.trademarket.TradeMarketSearchResultScreen;
import com.wynntils.utils.mc.RenderedStringUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class PresetButton
extends WynntilsButton
implements TooltipProvider {
    private final int presetId;
    private final TradeMarketSearchResultScreen tradeMarketSearchResultScreen;

    public PresetButton(int x, int y, int width, int height, int presetId, TradeMarketSearchResultScreen screen) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)"Preset Button"));
        this.presetId = presetId;
        this.tradeMarketSearchResultScreen = screen;
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        Texture itemTexture = this.isSavedPreset() ? Texture.SAVED_PRESET : Texture.PRESET;
        RenderUtils.drawTexturedRect(guiGraphics.method_51448(), itemTexture, this.method_46426(), this.method_46427());
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        if (button == 0) {
            String lastSearchFilter = this.tradeMarketSearchResultScreen.getSearchQuery().queryString();
            if (lastSearchFilter.isEmpty()) {
                return true;
            }
            Models.TradeMarket.setPresetFilter(this.presetId, lastSearchFilter);
            return true;
        }
        if (button == 1) {
            Optional<String> presetFilterOpt = Models.TradeMarket.getPresetFilter(this.presetId);
            if (presetFilterOpt.isEmpty()) {
                return true;
            }
            String filter = presetFilterOpt.get();
            this.tradeMarketSearchResultScreen.setSearchQuery(filter);
            return true;
        }
        return false;
    }

    public void method_25306() {
    }

    @Override
    public List<class_2561> getTooltipLines() {
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        if (this.isSavedPreset()) {
            list.add((class_2561)class_2561.method_43469((String)"screens.wynntils.tradeMarketSearchResult.button.savedPreset", (Object[])new Object[]{this.presetId + 1}).method_27692(class_124.field_1067).method_27692(class_124.field_1054));
        } else {
            list.add((class_2561)class_2561.method_43469((String)"screens.wynntils.tradeMarketSearchResult.button.preset", (Object[])new Object[]{this.presetId + 1}).method_27692(class_124.field_1067));
        }
        list.add((class_2561)class_2561.method_43473());
        if (this.isSavedPreset()) {
            Models.TradeMarket.getPresetFilter(this.presetId).ifPresent(presetString -> {
                list.add((class_2561)class_2561.method_43470((String)RenderedStringUtils.getMaxFittingText(presetString, 150.0f, FontRenderer.getInstance().getFont())).method_27692(class_124.field_1080));
                list.add((class_2561)class_2561.method_43473());
            });
        }
        list.add((class_2561)class_2561.method_43471((String)"screens.wynntils.tradeMarketSearchResult.button.clickToSave").method_27692(class_124.field_1060));
        list.add((class_2561)class_2561.method_43471((String)"screens.wynntils.tradeMarketSearchResult.button.clickToLoad").method_27692(class_124.field_1054));
        return list;
    }

    private boolean isSavedPreset() {
        return Models.TradeMarket.getPresetFilter(this.presetId).isPresent();
    }
}

