/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.favorites;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Service;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.inventory.ItemFavoriteFeature;
import com.wynntils.models.gear.type.GearInfo;
import com.wynntils.models.ingredients.type.IngredientInfo;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.items.game.GearBoxItem;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.models.items.items.game.IngredientItem;
import com.wynntils.models.items.items.gui.IngredientPouchItem;
import com.wynntils.utils.type.Pair;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public final class FavoritesService
extends Service {
    private int revision = 1;

    public FavoritesService() {
        super(List.of());
    }

    public boolean isFavorite(String unformattedName) {
        return this.getFavoriteItems().contains(unformattedName);
    }

    public boolean isFavorite(class_2561 component) {
        return this.isFavorite(StyledText.fromComponent(component).getStringWithoutFormatting());
    }

    public boolean isFavorite(class_1799 itemStack) {
        return this.isFavorite(itemStack.method_7964());
    }

    public boolean calculateFavorite(class_1799 itemStack, WynnItem wynnItem) {
        String unformattedName = StyledText.fromComponent(itemStack.method_7964()).getNormalized().getStringWithoutFormatting();
        if (this.isFavorite(unformattedName)) {
            return true;
        }
        if (wynnItem instanceof IngredientItem) {
            IngredientItem ingredientItem = (IngredientItem)wynnItem;
            return this.isFavorite(ingredientItem.getIngredientInfo().name());
        }
        if (wynnItem instanceof GearItem) {
            GearItem gearItem = (GearItem)wynnItem;
            return this.isFavorite(gearItem.getName());
        }
        if (wynnItem instanceof IngredientPouchItem) {
            IngredientPouchItem pouchItem = (IngredientPouchItem)wynnItem;
            for (Pair<IngredientInfo, Integer> ingredientPair : pouchItem.getIngredients()) {
                IngredientInfo ingredientProfile = ingredientPair.a();
                if (!this.isFavorite(ingredientProfile.name())) continue;
                return true;
            }
        }
        if (wynnItem instanceof GearBoxItem) {
            GearBoxItem gearBoxItem = (GearBoxItem)wynnItem;
            for (GearInfo possibleGear : Models.Gear.getPossibleGears(gearBoxItem)) {
                if (!this.isFavorite(possibleGear.name())) continue;
                return true;
            }
        }
        return false;
    }

    public void addFavorite(String unformattedName) {
        this.getFavoriteItems().add(unformattedName);
        Managers.Feature.getFeatureInstance(ItemFavoriteFeature.class).favoriteItems.touched();
        ++this.revision;
    }

    public void removeFavorite(String unformattedName) {
        this.getFavoriteItems().remove(unformattedName);
        Managers.Feature.getFeatureInstance(ItemFavoriteFeature.class).favoriteItems.touched();
        ++this.revision;
    }

    public void toggleFavorite(String unformattedName) {
        if (this.isFavorite(unformattedName)) {
            this.removeFavorite(unformattedName);
        } else {
            this.addFavorite(unformattedName);
        }
    }

    public int getRevision() {
        return this.revision;
    }

    public Set<String> getFavoriteItems() {
        return (Set)Managers.Feature.getFeatureInstance(ItemFavoriteFeature.class).favoriteItems.get();
    }
}

