/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.lootrunpaths;

import com.wynntils.core.components.Managers;
import com.wynntils.features.LootrunFeature;
import com.wynntils.services.lootrunpaths.LootrunPathInstance;
import com.wynntils.services.lootrunpaths.UncompiledLootrunPath;
import com.wynntils.services.lootrunpaths.type.ColoredPath;
import com.wynntils.services.lootrunpaths.type.ColoredPosition;
import com.wynntils.services.lootrunpaths.type.LootrunNote;
import com.wynntils.services.lootrunpaths.type.LootrunPath;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.PosUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_6492;
import net.minecraft.class_6501;
import net.minecraft.class_9848;
import org.joml.Vector2d;
import org.joml.Vector2dc;

public final class LootrunCompiler {
    private static final List<Integer> COLORS = List.of(class_124.field_1061.method_532(), class_124.field_1065.method_532(), class_124.field_1054.method_532(), class_124.field_1060.method_532(), class_124.field_1078.method_532(), Integer.valueOf(0x3F00FF), class_124.field_1064.method_532());

    public static LootrunPathInstance compile(UncompiledLootrunPath uncompiled, boolean recording) {
        Long2ObjectMap<List<ColoredPath>> points = LootrunCompiler.generatePointsByChunk(uncompiled.path(), recording);
        Long2ObjectMap<Set<class_2338>> chests = LootrunCompiler.getChests(uncompiled.chests());
        Long2ObjectMap<List<LootrunNote>> notes = LootrunCompiler.getNotes(uncompiled.notes());
        String lootrunName = LootrunCompiler.getLootrunName(uncompiled, recording);
        return new LootrunPathInstance(lootrunName, uncompiled.path(), LootrunCompiler.generateSimplifiedPoints(uncompiled.path(), 0.5), points, chests, notes);
    }

    private static String getLootrunName(UncompiledLootrunPath uncompiled, boolean recording) {
        if (recording) {
            return "recorded_lootrun";
        }
        if (uncompiled.file() == null) {
            return "lootrun";
        }
        return uncompiled.file().getName().replace(".json", "");
    }

    private static List<LootrunPath> sample(LootrunPath raw, float sampleRate) {
        ArrayList<LootrunPath> positions = new ArrayList<LootrunPath>();
        LootrunPath currentPositions = new LootrunPath(new ArrayList<class_243>());
        positions.add(currentPositions);
        for (class_243 element : raw.points()) {
            if (!currentPositions.points().isEmpty() && currentPositions.points().getLast().method_1022(element) >= 32.0) {
                currentPositions = new LootrunPath(new ArrayList<class_243>());
                positions.add(currentPositions);
            }
            currentPositions.points().add(element);
        }
        ArrayList<LootrunPath> result = new ArrayList<LootrunPath>();
        for (LootrunPath current : positions) {
            float distance = 0.0f;
            class_6492.class_6493 builderX = class_6492.method_37918((class_6501)class_6501.field_37409);
            class_6492.class_6493 builderY = class_6492.method_37918((class_6501)class_6501.field_37409);
            class_6492.class_6493 builderZ = class_6492.method_37918((class_6501)class_6501.field_37409);
            for (int i = 0; i < current.points().size(); ++i) {
                class_243 position = current.points().get(i);
                if (i > 0) {
                    distance = (float)((double)distance + current.points().get(i - 1).method_1022(position));
                }
                float slopeX = 0.0f;
                float slopeY = 0.0f;
                float slopeZ = 0.0f;
                if (i < current.points().size() - 1) {
                    class_243 next = current.points().get(i + 1);
                    slopeX = (float)((next.field_1352 - position.field_1352) / position.method_1022(next));
                    slopeY = (float)((next.field_1351 - position.field_1351) / position.method_1022(next));
                    slopeZ = (float)((next.field_1350 - position.field_1350) / position.method_1022(next));
                }
                builderX.method_37924(distance, (float)position.field_1352, slopeX);
                builderY.method_37924(distance, (float)position.field_1351, slopeY);
                builderZ.method_37924(distance, (float)position.field_1350, slopeZ);
            }
            class_6492 splineX = builderX.method_37923();
            class_6492 splineY = builderY.method_37923();
            class_6492 splineZ = builderZ.method_37923();
            LootrunPath newResult = new LootrunPath(new ArrayList<class_243>());
            for (float i = 0.0f; i < distance; i += 1.0f / sampleRate) {
                newResult.points().add(new class_243((double)splineX.method_41296((Object)Float.valueOf(i)), (double)splineY.method_41296((Object)Float.valueOf(i)), (double)splineZ.method_41296((Object)Float.valueOf(i))));
            }
            result.add(newResult);
        }
        return result;
    }

    private static Long2ObjectMap<List<ColoredPath>> generatePointsByChunk(LootrunPath raw, boolean recording) {
        Integer nextColor;
        float sampleRate = 10.0f;
        List<List> sampled = LootrunCompiler.sample(raw, sampleRate).stream().map(LootrunPath::points).toList();
        List positions = sampled.stream().flatMap(Collection::stream).toList();
        ColoredPath locationsList = new ColoredPath(new ArrayList<ColoredPosition>());
        Iterator<Integer> colorIterator = COLORS.iterator();
        Integer currentColor = nextColor = colorIterator.next();
        float differenceRed = 0.0f;
        float differenceGreen = 0.0f;
        float differenceBlue = 0.0f;
        for (int i = 0; i < positions.size(); ++i) {
            class_243 position = (class_243)positions.get(i);
            if (((Boolean)Managers.Feature.getFeatureInstance(LootrunFeature.class).rainbowLootRun.get()).booleanValue() && !recording) {
                int usedColor;
                int cycleDistance = (Integer)Managers.Feature.getFeatureInstance(LootrunFeature.class).cycleDistance.get();
                int cycle = 10 * cycleDistance;
                int parts = i % cycle;
                float done = (float)parts / (float)cycle;
                if (parts == 0) {
                    currentColor = nextColor;
                    if (!colorIterator.hasNext()) {
                        colorIterator = COLORS.iterator();
                    }
                    nextColor = colorIterator.next();
                    differenceRed = class_9848.method_61327((int)nextColor) - class_9848.method_61327((int)currentColor);
                    differenceGreen = class_9848.method_61329((int)nextColor) - class_9848.method_61329((int)currentColor);
                    differenceBlue = class_9848.method_61331((int)nextColor) - class_9848.method_61331((int)currentColor);
                    usedColor = currentColor;
                } else {
                    usedColor = currentColor;
                    usedColor += 65536 * (int)(differenceRed * done);
                    usedColor += 256 * (int)(differenceGreen * done);
                    usedColor += (int)(differenceBlue * done);
                }
                locationsList.points().add(new ColoredPosition(position, usedColor | 0xFF000000));
                continue;
            }
            locationsList.points().add(new ColoredPosition(position, recording ? ((CustomColor)Managers.Feature.getFeatureInstance(LootrunFeature.class).recordingPathColor.get()).asInt() : ((CustomColor)Managers.Feature.getFeatureInstance(LootrunFeature.class).activePathColor.get()).asInt()));
        }
        ColoredPath lastLocationList = null;
        Long2ObjectOpenHashMap sampleByChunk = new Long2ObjectOpenHashMap();
        class_1923 lastChunkPos = null;
        for (int i = 0; i < locationsList.points().size(); ++i) {
            class_243 position = locationsList.points().get(i).position();
            class_1923 currentChunkPos = new class_1923(MathUtils.floor(position.method_10216()) >> 4, MathUtils.floor(position.method_10215()) >> 4);
            if (!currentChunkPos.equals(lastChunkPos)) {
                if (lastChunkPos != null && position.method_1022(locationsList.points().get(i - 1).position()) < 32.0) {
                    lastLocationList.points().add(locationsList.points().get(i));
                }
                lastChunkPos = currentChunkPos;
                sampleByChunk.putIfAbsent(class_1923.method_8331((int)currentChunkPos.field_9181, (int)currentChunkPos.field_9180), new ArrayList());
                lastLocationList = new ColoredPath(new ArrayList<ColoredPosition>());
                ((List)sampleByChunk.get(class_1923.method_8331((int)currentChunkPos.field_9181, (int)currentChunkPos.field_9180))).add(lastLocationList);
            }
            lastLocationList.points().add(locationsList.points().get(i));
        }
        return sampleByChunk;
    }

    private static List<Vector2d> generateSimplifiedPoints(LootrunPath raw, double tolerance) {
        ArrayList<Vector2d> points = new ArrayList<Vector2d>();
        for (class_243 point : raw.points()) {
            points.add(new Vector2d(point.field_1352, point.field_1350));
        }
        return LootrunCompiler.simplify(points, tolerance);
    }

    private static List<Vector2d> simplify(List<Vector2d> points, double epsilon) {
        if (points.size() < 3) {
            return points;
        }
        int end = points.size() - 1;
        int index = -1;
        double dist = 0.0;
        for (int i = 1; i < end; ++i) {
            double d = LootrunCompiler.pointLineDistance(points.get(i), points.getFirst(), points.get(end));
            if (!(d > dist)) continue;
            dist = d;
            index = i;
        }
        ArrayList<Vector2d> simplified = new ArrayList<Vector2d>();
        if (dist > epsilon) {
            List<Vector2d> left = LootrunCompiler.simplify(points.subList(0, index + 1), epsilon);
            List<Vector2d> right = LootrunCompiler.simplify(points.subList(index, end + 1), epsilon);
            simplified.addAll(left.subList(0, left.size() - 1));
            simplified.addAll(right);
        } else {
            simplified.add(points.getFirst());
            simplified.add(points.get(end));
        }
        return simplified;
    }

    private static double pointLineDistance(Vector2d point, Vector2d lineStart, Vector2d lineEnd) {
        Vector2d lineDelta;
        Vector2d delta = new Vector2d((Vector2dc)point).sub((Vector2dc)lineStart);
        double param = delta.dot((Vector2dc)(lineDelta = new Vector2d((Vector2dc)lineEnd).sub((Vector2dc)lineStart))) / lineDelta.lengthSquared();
        Vector2d closestPoint = param < 0.0 ? new Vector2d((Vector2dc)lineStart) : (param > 1.0 ? new Vector2d((Vector2dc)lineEnd) : new Vector2d((Vector2dc)lineStart).add((Vector2dc)lineDelta.mul(param)));
        return closestPoint.distance((Vector2dc)point);
    }

    private static Long2ObjectMap<Set<class_2338>> getChests(Set<class_2338> chests) {
        Long2ObjectOpenHashMap result = new Long2ObjectOpenHashMap();
        for (class_2338 pos : chests) {
            Set addTo = (Set)result.computeIfAbsent(new class_1923(pos).method_8324(), chunk -> new HashSet());
            addTo.add(pos);
        }
        return result;
    }

    private static Long2ObjectMap<List<LootrunNote>> getNotes(List<LootrunNote> notes) {
        Long2ObjectOpenHashMap result = new Long2ObjectOpenHashMap();
        for (LootrunNote note : notes) {
            class_1923 chunk = new class_1923(PosUtils.newBlockPos(note.position()));
            List notesChunk = (List)result.computeIfAbsent(chunk.method_8324(), chunkPos -> new ArrayList());
            notesChunk.add(note);
        }
        return result;
    }
}

