/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.map.pois;

import com.wynntils.services.hades.HadesUser;
import com.wynntils.services.map.pois.Poi;
import com.wynntils.services.map.type.DisplayPriority;
import com.wynntils.utils.mc.type.PoiLocation;

public abstract class PlayerPoiBase
implements Poi {
    private static final float INITIAL_PLAYER_HEAD_RENDER_SIZE = 20.0f;
    private static final float ADDITIONAL_WIDTH = 20.0f;
    private static final float ADDITIONAL_HEIGHT = 17.0f;
    protected final HadesUser user;
    protected final float playerHeadRenderSize;

    protected PlayerPoiBase(HadesUser user, float playerHeadScale) {
        this.user = user;
        this.playerHeadRenderSize = 20.0f * playerHeadScale;
    }

    @Override
    public PoiLocation getLocation() {
        return this.user.getMapLocation();
    }

    @Override
    public boolean hasStaticLocation() {
        return false;
    }

    @Override
    public int getWidth(float mapZoom, float scale) {
        return (int)(this.playerHeadRenderSize + 20.0f);
    }

    @Override
    public int getHeight(float mapZoom, float scale) {
        return (int)(this.playerHeadRenderSize + 17.0f);
    }

    @Override
    public String getName() {
        return this.user.getName();
    }

    @Override
    public DisplayPriority getDisplayPriority() {
        return DisplayPriority.LOW;
    }
}

