/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils;

import com.wynntils.utils.type.ArrayReader;
import com.wynntils.utils.type.UnsignedByte;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import java.util.stream.Collectors;

public final class EncodedByteBuffer {
    private static final int PRIVATE_USE_AREA_A_START = 983040;
    private static final int PRIVATE_USE_AREA_B_START = 0x100000;
    private final UnsignedByte[] bytes;

    private EncodedByteBuffer(UnsignedByte[] bytes) {
        this.bytes = bytes;
    }

    public static EncodedByteBuffer fromBytes(UnsignedByte[] bytes) {
        return new EncodedByteBuffer(bytes);
    }

    public static EncodedByteBuffer fromUtf16String(String string) {
        int[] codePoints;
        ArrayList<UnsignedByte> bytes = new ArrayList<UnsignedByte>();
        for (int codePoint : codePoints = string.codePoints().toArray()) {
            if (codePoint >= 0x100000) {
                int singleByteOffset = 0x1000EE;
                if ((codePoint & 0xFF) == 238) {
                    int actualValue = codePoint - singleByteOffset >> 8;
                    bytes.add(UnsignedByte.of((byte)actualValue));
                    assert (actualValue <= 255) : "Invalid code point: " + codePoint;
                    continue;
                }
                int values = codePoint - 0x100000;
                UnsignedByte firstByte = UnsignedByte.of((byte)-1);
                UnsignedByte secondByte = UnsignedByte.of((byte)(254 + (values & 0xFF)));
                bytes.add(firstByte);
                bytes.add(secondByte);
                assert (codePoint < 0x100002) : "Invalid code point: " + codePoint;
                continue;
            }
            int values = codePoint - 983040;
            UnsignedByte firstByte = UnsignedByte.of((byte)(values >> 8));
            UnsignedByte secondByte = UnsignedByte.of((byte)(values & 0xFF));
            bytes.add(firstByte);
            bytes.add(secondByte);
            assert (codePoint < 1048574) : "Invalid code point: " + codePoint;
        }
        return EncodedByteBuffer.fromBytes((UnsignedByte[])bytes.toArray(UnsignedByte[]::new));
    }

    public static EncodedByteBuffer fromBase64String(String string) {
        byte[] decodedBytes = Base64.getDecoder().decode(string);
        UnsignedByte[] bytes = UnsignedByte.of(decodedBytes);
        return EncodedByteBuffer.fromBytes(bytes);
    }

    public String toUtf16String() {
        StringBuilder builder = new StringBuilder(this.bytes.length / 2 + this.bytes.length % 2);
        for (int i = 0; i < this.bytes.length - 1; i += 2) {
            int codePoint = this.bytes[i].value() == 255 && this.bytes[i + 1].value() >= 254 ? 0x100000 + (this.bytes[i + 1].value() - 254) : 983040 + (this.bytes[i].value() << 8 | this.bytes[i + 1].value());
            builder.appendCodePoint(codePoint);
        }
        if (this.bytes.length % 2 == 1) {
            builder.appendCodePoint(0x100000 + (this.bytes[this.bytes.length - 1].value() << 8) + 238);
        }
        return builder.toString();
    }

    public String toBase64String() {
        byte[] bytes = UnsignedByte.toPrimitive(this.bytes);
        return Base64.getEncoder().encodeToString(bytes);
    }

    public UnsignedByte[] getBytes() {
        return this.bytes;
    }

    public ArrayReader<UnsignedByte> getReader() {
        return new ArrayReader<UnsignedByte>(this.bytes);
    }

    public String toString() {
        return "EncodedByteBuffer{bytes=" + Arrays.stream(this.bytes).map(UnsignedByte::value).map(Objects::toString).collect(Collectors.joining(", ")) + "}";
    }
}

