/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils;

import com.wynntils.core.WynntilsMod;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.regex.Pattern;

public class MD5Verification {
    private String md5;
    private static final char[] hex = "0123456789abcdef".toCharArray();
    private static final Pattern md5Regex = Pattern.compile("^[0-9a-fA-F]{32}$");

    public MD5Verification(File f) {
        try (FileInputStream fis = new FileInputStream(f);){
            byte[] buffer = new byte[1024];
            MessageDigest md = MessageDigest.getInstance("MD5");
            int numRead = ((InputStream)fis).read(buffer);
            while (numRead != -1) {
                if (numRead > 0) {
                    md.update(buffer, 0, numRead);
                }
                numRead = ((InputStream)fis).read(buffer);
            }
            ((InputStream)fis).close();
            this.md5 = MD5Verification.hexDigest(md.digest());
        }
        catch (Exception ex) {
            WynntilsMod.error("Error when creating MD5Verification object.", ex);
        }
    }

    public MD5Verification(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(data);
            this.md5 = MD5Verification.hexDigest(md.digest());
        }
        catch (Exception ex) {
            WynntilsMod.error("Error when creating MD5Verification object.", ex);
        }
    }

    private static String hexDigest(byte[] digest) {
        char[] hexChars = new char[32];
        for (int i = 0; i < 16; ++i) {
            int b = Byte.toUnsignedInt(digest[i]);
            hexChars[2 * i] = hex[b >> 4];
            hexChars[2 * i + 1] = hex[b & 0xF];
        }
        return new String(hexChars);
    }

    public String getMd5() {
        return this.md5;
    }

    public boolean equalsHashString(String other) {
        return this.md5 != null && this.md5.equalsIgnoreCase(other);
    }

    public static boolean isMd5Digest(String s) {
        return s != null && s.length() == 32 && md5Regex.matcher(s).matches();
    }
}

