/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.mc;

import com.wynntils.core.text.StyledText;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import java.util.Arrays;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;

public final class RenderedStringUtils {
    private static final Pattern OPENING_PARANTHESIS_PATTERN = Pattern.compile(" \\(");
    private static final Pattern OPENING_BRACKET_PATTERN = Pattern.compile(" \\[");

    public static StyledText[] wrapTextBySize(StyledText s, int maxPixels) {
        class_327 font = McUtils.mc().field_1772;
        int spaceSize = font.method_1727(" ");
        StyledText[] stringArray = s.split(" ");
        StringBuilder result = new StringBuilder();
        int length = 0;
        for (StyledText string : stringArray) {
            StyledText[] lines = string.split("\\\\n");
            for (int i = 0; i < lines.length; ++i) {
                StyledText line = lines[i];
                if (i > 0 || length + font.method_1727(line.getString()) >= maxPixels) {
                    result.append('\n');
                    length = 0;
                }
                if (line.isEmpty()) continue;
                result.append(line.getString()).append(' ');
                length += font.method_1727(line.getString()) + spaceSize;
            }
        }
        return (StyledText[])Arrays.stream(result.toString().split("\n")).map(StyledText::fromString).toArray(StyledText[]::new);
    }

    public static String getMaxFittingText(String text, float maxTextWidth, class_327 font) {
        if ((float)font.method_1727(text) < maxTextWidth) {
            return text;
        }
        StringBuilder builder = new StringBuilder();
        int suffixWidth = font.method_1727("...");
        for (int stringPosition = 0; (float)font.method_1727(builder.toString()) < maxTextWidth - (float)suffixWidth && stringPosition < text.length(); ++stringPosition) {
            builder.append(text.charAt(stringPosition));
        }
        builder.append("...");
        String renderedText = builder.toString();
        return renderedText;
    }

    public static StyledText trySplitOptimally(StyledText line, float maxWidth) {
        String maxFitting = RenderedStringUtils.getMaxFittingText(line.getStringWithoutFormatting(), maxWidth, FontRenderer.getInstance().getFont());
        if (maxFitting.contains("[") && !maxFitting.contains("]")) {
            String color = "";
            if (line.startsWith("\u00a7")) {
                color = line.getString().substring(0, 2);
            }
            return StyledText.fromString(OPENING_BRACKET_PATTERN.matcher(line.getString()).replaceFirst("\n" + color + "["));
        }
        if (maxFitting.contains("(") && !maxFitting.contains(")")) {
            String color = "";
            if (line.startsWith("\u00a7")) {
                color = line.getString().substring(0, 2);
            }
            return StyledText.fromString(OPENING_PARANTHESIS_PATTERN.matcher(line.getString()).replaceFirst("\n" + color + "("));
        }
        return line;
    }

    public static String substringMaxWidth(String input, int maxWidth) {
        class_327 font = McUtils.mc().field_1772;
        if (font.method_1727(input) <= maxWidth) {
            return input;
        }
        StringBuilder builder = new StringBuilder();
        for (char c : input.toCharArray()) {
            if (font.method_1727(builder.toString() + c) > maxWidth) break;
            builder.append(c);
        }
        return builder.toString();
    }

    public static class_2561 getPercentageComponent(int count, int totalCount, int tickCount) {
        return RenderedStringUtils.getPercentageComponent(count, totalCount, tickCount, false, "");
    }

    public static class_2561 getPercentageComponent(int count, int totalCount, int tickCount, boolean displayRawCount, String amountSuffix) {
        class_124 foregroundColor;
        class_124 braceColor;
        int percentage = Math.round((float)count / (float)totalCount * 100.0f);
        if (percentage < 25) {
            braceColor = class_124.field_1079;
            foregroundColor = class_124.field_1061;
        } else if (percentage < 75) {
            braceColor = class_124.field_1065;
            foregroundColor = class_124.field_1054;
        } else {
            braceColor = class_124.field_1077;
            foregroundColor = class_124.field_1060;
        }
        StringBuilder insideText = new StringBuilder(foregroundColor.toString());
        if (displayRawCount) {
            insideText.append("|".repeat(tickCount)).append(count).append(amountSuffix).append("|".repeat(tickCount));
        } else {
            insideText.append("|".repeat(tickCount)).append(percentage).append("%").append("|".repeat(tickCount));
        }
        int insertAt = Math.min(insideText.length(), Math.round((float)(insideText.length() - 2) * (float)count / (float)totalCount) + 2);
        insideText.insert(insertAt, class_124.field_1063);
        return class_2561.method_43470((String)"[").method_27692(braceColor).method_10852((class_2561)class_2561.method_43470((String)insideText.toString())).method_10852((class_2561)class_2561.method_43470((String)"]").method_27692(braceColor));
    }
}

