/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.mc;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.text.StyledText;
import com.wynntils.core.text.StyledTextPart;
import com.wynntils.core.text.type.StyleType;
import com.wynntils.utils.mc.type.Location;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;

public final class StyledTextUtils {
    private static final Pattern COORDINATE_PATTERN = Pattern.compile(".*\\[(-?\\d+)(?:.\\d+)?, ?(-?\\d+)(?:.\\d+)?, ?(-?\\d+)(?:.\\d+)?\\].*");
    public static final Pattern NICKNAME_PATTERN = Pattern.compile("\u00a7f(?<nick>.+?)(\u00a77)?'s?(\u00a77)? real (user)?name is \u00a7f(?<username>.+)");
    private static final String NEWLINE_PREPARATION = "\n";
    private static final Pattern NEWLINE_WRAP_PATTERN = Pattern.compile("\udaff\udffc\ue001\udb00\udc06");
    private static final Pattern WHITESPACES_PATTERN = Pattern.compile("\\s+");

    public static StyledTextPart createLocationPart(Location location) {
        String locationString = "[%d, %d, %d]".formatted(location.x, location.y, location.z);
        class_2583 style = class_2583.field_24360.method_10977(class_124.field_1062).method_30938(Boolean.valueOf(true));
        style = style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/compass at " + location.x + " " + location.y + " " + location.z));
        style = style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"utils.wynntils.component.clickToSetCompass")));
        return new StyledTextPart(locationString, style, null, class_2583.field_24360);
    }

    public static Optional<Location> extractLocation(StyledText text) {
        Matcher matcher = text.getMatcher(COORDINATE_PATTERN, StyleType.NONE);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        return Optional.of(new Location(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3))));
    }

    public static StyledText joinLines(List<StyledText> lines) {
        String description = WHITESPACES_PATTERN.matcher(String.join((CharSequence)" ", lines.stream().map(StyledText::getString).toList())).replaceAll(" ").trim();
        return StyledText.fromString(description);
    }

    public static int getLineCount(StyledText styledText) {
        List<StyledText> lines = List.of(styledText.split(NEWLINE_PREPARATION, true));
        int lineCount = lines.size();
        return lineCount;
    }

    public static StyledText joinAllLines(StyledText styledText) {
        return styledText.replaceAll(NEWLINE_PREPARATION, "");
    }

    public static List<StyledText> stripEventsAndLinks(List<StyledText> lines) {
        List<StyledText> linesWithoutEvents = lines.stream().map(s -> s.getString()).map(str -> StyledText.fromString(str)).toList();
        return linesWithoutEvents;
    }

    public static StyledText unwrap(StyledText styledText) {
        ArrayList<StyledTextPart> newParts = new ArrayList<StyledTextPart>();
        StyledTextPart lastWrappedPart = null;
        boolean expectEmptySpaceAfterWrap = false;
        for (StyledTextPart part : styledText) {
            Object partString = part.getString(null, StyleType.NONE);
            if (expectEmptySpaceAfterWrap) {
                if (((String)partString).equals(" ")) {
                    expectEmptySpaceAfterWrap = false;
                    continue;
                }
                if (((String)partString).startsWith(" ")) {
                    partString = ((String)partString).substring(1);
                    part = new StyledTextPart((String)partString, part.getPartStyle().getStyle(), null, null);
                    expectEmptySpaceAfterWrap = false;
                } else {
                    WynntilsMod.warn("Unexpected edge-case in unwrap: " + String.valueOf(part));
                }
            }
            if (((String)partString).endsWith(NEWLINE_PREPARATION)) {
                lastWrappedPart = part;
                continue;
            }
            if (lastWrappedPart != null) {
                if (NEWLINE_WRAP_PATTERN.matcher((CharSequence)partString).matches()) {
                    Object lastPartWithoutNewline = lastWrappedPart.getString(null, StyleType.NONE);
                    lastPartWithoutNewline = ((String)lastPartWithoutNewline).substring(0, ((String)lastPartWithoutNewline).length() - NEWLINE_PREPARATION.length());
                    if (!newParts.isEmpty() && ((StyledTextPart)newParts.getLast()).getPartStyle().equals(lastWrappedPart.getPartStyle())) {
                        StyledTextPart lastPart = (StyledTextPart)newParts.removeLast();
                        lastPartWithoutNewline = lastPart.getString(null, StyleType.NONE) + (String)lastPartWithoutNewline;
                        newParts.add(new StyledTextPart((String)lastPartWithoutNewline, lastWrappedPart.getPartStyle().getStyle(), null, null));
                    } else {
                        newParts.add(new StyledTextPart((String)lastPartWithoutNewline, lastWrappedPart.getPartStyle().getStyle(), null, null));
                    }
                    if (!((StyledTextPart)newParts.getLast()).getString(null, StyleType.NONE).equals(" ")) {
                        newParts.add(new StyledTextPart(" ", lastWrappedPart.getPartStyle().getStyle(), null, null));
                    }
                    expectEmptySpaceAfterWrap = true;
                } else {
                    newParts.add(lastWrappedPart);
                    newParts.add(part);
                }
                lastWrappedPart = null;
                continue;
            }
            if (!newParts.isEmpty() && ((StyledTextPart)newParts.getLast()).getPartStyle().equals(part.getPartStyle())) {
                StyledTextPart lastPart = (StyledTextPart)newParts.removeLast();
                partString = lastPart.getString(null, StyleType.NONE) + (String)partString;
                newParts.add(new StyledTextPart((String)partString, part.getPartStyle().getStyle(), null, null));
                continue;
            }
            newParts.add(part);
        }
        if (lastWrappedPart != null) {
            newParts.add(lastWrappedPart);
        }
        if (!newParts.isEmpty() && ((StyledTextPart)newParts.getLast()).getString(null, StyleType.NONE).equals(" ")) {
            newParts.removeLast();
        }
        return StyledText.fromParts(newParts);
    }

    public static Pair<String, String> extractNameAndNick(Iterable<StyledTextPart> styledText) {
        for (StyledTextPart part : styledText) {
            StyledText[] partTexts;
            class_2568 hoverEvent = part.getPartStyle().getStyle().method_10969();
            if (hoverEvent == null || hoverEvent.method_10892() != class_2568.class_5247.field_24342) continue;
            for (StyledText partText : partTexts = StyledText.fromComponent((class_2561)hoverEvent.method_10891(class_2568.class_5247.field_24342)).split(NEWLINE_PREPARATION)) {
                Matcher nicknameMatcher = partText.getMatcher(NICKNAME_PATTERN);
                if (!nicknameMatcher.matches()) continue;
                return new Pair<String, String>(nicknameMatcher.group("username"), nicknameMatcher.group("nick"));
            }
        }
        return null;
    }
}

