/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.mc.type;

import com.wynntils.utils.MathUtils;
import com.wynntils.utils.mc.PosUtils;
import com.wynntils.utils.mc.type.PoiLocation;
import java.util.Comparator;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;

public class Location
implements Comparable<Location> {
    private static final Comparator<Location> LOCATION_COMPARATOR = Comparator.comparing(Location::x, Integer::compareTo).thenComparing(Location::z, Integer::compareTo).thenComparing(Location::y, Integer::compareTo);
    public final int x;
    public final int y;
    public final int z;

    public Location(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Location(class_2338 pos) {
        this(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public Location(PoiLocation location) {
        this(location.getX(), location.getY().orElse(0), location.getZ());
    }

    public static Location containing(class_2374 position) {
        return new Location(MathUtils.floor(position.method_10216()), MathUtils.floor(position.method_10214()), MathUtils.floor(position.method_10215()));
    }

    public static Location containing(double x, double y, double z) {
        return new Location(MathUtils.floor(x), MathUtils.floor(y), MathUtils.floor(z));
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public int z() {
        return this.z;
    }

    public Location offset(int dx, int dy, int dz) {
        return new Location(this.x() + dx, this.y() + dy, this.z() + dz);
    }

    public class_2338 toBlockPos() {
        return PosUtils.newBlockPos(this.x, this.y, this.z);
    }

    public class_243 toVec3() {
        return new class_243((double)this.x, (double)this.y, (double)this.z);
    }

    public class_2374 toPosition() {
        return new class_243((double)this.x, (double)this.y, (double)this.z);
    }

    public boolean equalsIgnoringY(Location other) {
        return this.x() == other.x() && this.z() == other.z();
    }

    public double distanceToSqr(class_2374 position) {
        double xDiff = position.method_10216() - (double)this.x;
        double yDiff = position.method_10214() - (double)this.y;
        double zDiff = position.method_10215() - (double)this.z;
        return xDiff * xDiff + yDiff * yDiff + zDiff * zDiff;
    }

    public String asChatCoordinates() {
        return this.x + " " + this.y + " " + this.z;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        return this.x == location.x && this.y == location.y && this.z == location.z;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    @Override
    public int compareTo(Location that) {
        return LOCATION_COMPARATOR.compare(this, that);
    }
}

