/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.type;

import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;

public class TimedValue<T> {
    private T value = null;
    private long creation;
    private final long duration;

    public TimedValue(long duration, TimeUnit unit, T initial) {
        this.value = initial;
        this.creation = System.currentTimeMillis();
        this.duration = unit.toMillis(duration);
    }

    public TimedValue(long duration, TimeUnit unit) {
        this.creation = System.currentTimeMillis();
        this.duration = unit.toMillis(duration);
    }

    public T get() {
        if (this.value == null || this.isExpired()) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean matches(T value) {
        return !this.isExpired() && this.value.equals(value);
    }

    public void set(T value) {
        this.value = value;
        this.creation = System.currentTimeMillis();
    }

    public void reset() {
        this.value = null;
    }

    public boolean isExpired() {
        return this.value == null || System.currentTimeMillis() >= this.creation + this.duration;
    }
}

