/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.wynn;

import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.items.game.GatheringToolItem;
import com.wynntils.models.items.properties.GearTypeItemProperty;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public final class ItemUtils {
    private static final String EMPTY_ACCESSORY_SLOT = "\u00a77Accessory Slot";
    public static final Pattern ITEM_RARITY_PATTERN = Pattern.compile("(Normal|Set|Unique|Rare|Legendary|Fabled|Mythic)( Raid)? (Item|Reward).*");

    public static boolean isWeapon(class_1799 itemStack) {
        Optional<GearTypeItemProperty> gearItemOpt = Models.Item.asWynnItemProperty(itemStack, GearTypeItemProperty.class);
        if (gearItemOpt.isEmpty()) {
            return false;
        }
        return gearItemOpt.get().getGearType().isWeapon();
    }

    public static boolean isGatheringTool(class_1799 itemStack) {
        Optional<WynnItem> wynnItemOpt = Models.Item.getWynnItem(itemStack);
        return wynnItemOpt.filter(wynnItem -> wynnItem instanceof GatheringToolItem).isPresent();
    }

    public static boolean isEmptyAccessorySlot(class_1799 itemStack) {
        return itemStack.method_7964().getString().equals(EMPTY_ACCESSORY_SLOT);
    }

    public static StyledText getItemName(class_1799 itemStack) {
        return StyledText.fromComponent(itemStack.method_7964());
    }

    public static boolean isItemListsEqual(List<class_1799> firstItems, List<class_1799> secondItems) {
        if (firstItems.size() != secondItems.size()) {
            return false;
        }
        for (int i = 0; i < firstItems.size(); ++i) {
            class_1799 newItem = firstItems.get(i);
            class_1799 oldItem = secondItems.get(i);
            if (ItemUtils.isItemEqual(oldItem, newItem)) continue;
            return false;
        }
        return true;
    }

    public static boolean isItemEqual(class_1799 oldItem, class_1799 newItem) {
        if (oldItem == null || newItem == null) {
            return oldItem != newItem;
        }
        return newItem.method_7909().equals(oldItem.method_7909()) && newItem.method_7919() == oldItem.method_7919() && newItem.method_7947() == oldItem.method_7947() && class_1799.method_31577((class_1799)oldItem, (class_1799)newItem);
    }

    public static boolean areItemsSimilar(class_1799 a, class_1799 b) {
        if (a.method_7960()) {
            return b.method_7960();
        }
        return !b.method_7960() && a.method_7964().getString().equals(b.method_7964().getString());
    }

    public static class_5250 getNonGearDescription(class_1799 itemStack, String gearName) {
        if (gearName.contains("Crafted")) {
            return class_2561.method_43470((String)gearName).method_27692(class_124.field_1062);
        }
        if (itemStack.method_7909() == class_1802.field_8776 && itemStack.method_7919() >= 1 && itemStack.method_7919() <= 6) {
            return class_2561.method_43470((String)"Unidentified Item").method_27692(GearTier.fromBoxDamage(itemStack.method_7919()).getChatFormatting());
        }
        return null;
    }
}

