/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.commands.Command;
import com.wynntils.models.guild.type.GuildInfo;
import com.wynntils.models.guild.type.GuildMemberInfo;
import com.wynntils.models.guild.type.GuildRank;
import com.wynntils.utils.mc.McUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;

public class OnlineMembersCommand
extends Command {
    private static final SuggestionProvider<CommandSourceStack> GUILD_SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest(Models.Guild.getAllGuilds(), (SuggestionsBuilder)builder);

    @Override
    public String getCommandName() {
        return "onlinemembers";
    }

    @Override
    public List<String> getAliases() {
        return List.of("om");
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> getCommandBuilder(LiteralArgumentBuilder<CommandSourceStack> base, CommandBuildContext context) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)base.then(Commands.argument((String)"guildName", (ArgumentType)StringArgumentType.greedyString()).suggests(GUILD_SUGGESTION_PROVIDER).executes(this::lookupGuild))).executes(this::syntaxError);
    }

    private int lookupGuild(CommandContext<CommandSourceStack> context) {
        CompletableFuture<GuildInfo> completableFuture = Models.Guild.getGuild((String)context.getArgument("guildName", String.class));
        completableFuture.whenComplete((guild, throwable) -> {
            if (throwable != null) {
                McUtils.sendMessageToClient((Component)Component.literal((String)("Unable to view online members for " + (String)context.getArgument("guildName", String.class))).withStyle(ChatFormatting.RED));
                WynntilsMod.error("Error trying to parse guild online members", throwable);
            } else {
                if (guild == null) {
                    McUtils.sendMessageToClient((Component)Component.literal((String)("Unknown guild " + (String)context.getArgument("guildName", String.class))).withStyle(ChatFormatting.RED));
                    return;
                }
                MutableComponent response = Component.literal((String)(guild.name() + " [" + guild.prefix() + "]")).withStyle(ChatFormatting.DARK_AQUA);
                response.append((Component)Component.literal((String)" has ").withStyle(ChatFormatting.GRAY));
                response.append((Component)Component.literal((String)(guild.onlineMembers() + "/" + guild.totalMembers())).withStyle(ChatFormatting.GOLD)).append((Component)Component.literal((String)" members currently online:").withStyle(ChatFormatting.GRAY));
                List<GuildRank> guildRanks = Arrays.asList(GuildRank.values());
                Collections.reverse(guildRanks);
                for (GuildRank guildRank : guildRanks) {
                    List<GuildMemberInfo> onlineRankMembers = guild.getOnlineMembersbyRank(guildRank);
                    if (onlineRankMembers.isEmpty()) continue;
                    response.append((Component)Component.literal((String)("\n" + guildRank.getGuildDescription() + ":\n")).withStyle(ChatFormatting.GOLD));
                    for (GuildMemberInfo guildMember : onlineRankMembers) {
                        response.append((Component)Component.literal((String)guildMember.username()).withStyle(ChatFormatting.AQUA).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("Click to private message " + guildMember.username())).withStyle(ChatFormatting.GRAY))).withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/msg " + guildMember.username() + " "))));
                        if (onlineRankMembers.indexOf(guildMember) == onlineRankMembers.size() - 1) continue;
                        response.append((Component)Component.literal((String)", ").withStyle(ChatFormatting.GRAY));
                    }
                }
                McUtils.sendMessageToClient((Component)response);
            }
        });
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.wynntils.onlineMembers.lookingUp").withStyle(ChatFormatting.GREEN), false);
        return 1;
    }

    private int syntaxError(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Missing argument").withStyle(ChatFormatting.RED));
        return 0;
    }
}

