/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.commands.Command;
import com.wynntils.core.net.ApiResponse;
import com.wynntils.core.net.UrlId;
import com.wynntils.screens.downloads.DownloadScreen;
import com.wynntils.screens.maps.GuildMapScreen;
import com.wynntils.screens.maps.MainMapScreen;
import com.wynntils.screens.playerviewer.GearSharingSettingsScreen;
import com.wynntils.screens.wynntilsmenu.WynntilsMenuScreen;
import com.wynntils.services.athena.type.UpdateResult;
import com.wynntils.utils.FileUtils;
import com.wynntils.utils.mc.McUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class WynntilsCommand
extends Command {
    private static final Pattern STATUS_HEADING = Pattern.compile("<h1 class='status-page__title'>(.*)</h1>");

    public void registerWithCommands(Consumer<LiteralArgumentBuilder<CommandSourceStack>> consumer, CommandBuildContext context, List<Command> commands) {
        List<LiteralArgumentBuilder<CommandSourceStack>> commandBuilders = this.getCommandBuilders(context);
        for (LiteralArgumentBuilder<CommandSourceStack> builder : commandBuilders) {
            for (Command commandInstance : commands) {
                if (commandInstance == this) continue;
                commandInstance.getCommandBuilders(context).forEach(arg_0 -> builder.then(arg_0));
            }
            consumer.accept(builder);
        }
    }

    @Override
    public String getCommandName() {
        return "wynntils";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> getCommandBuilder(LiteralArgumentBuilder<CommandSourceStack> base, CommandBuildContext context) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)base.then(((LiteralArgumentBuilder)Commands.literal((String)"clearcaches").then(Commands.literal((String)"run").executes(this::doClearCaches))).executes(this::clearCaches))).then(Commands.literal((String)"debug").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"profile").then(Commands.literal((String)"reset").executes(this::profileReset))).then(Commands.literal((String)"showAnnotations").executes(this::profileShowAnnotations))).then(Commands.literal((String)"showOverlays").executes(this::profileShowOverlays))))).then(Commands.literal((String)"discord").executes(this::discordLink))).then(Commands.literal((String)"donate").executes(this::donateLink))).then(Commands.literal((String)"downloads").executes(this::downloads))).then(Commands.literal((String)"gearsharing").executes(this::openGearSharingSettings))).then(Commands.literal((String)"guildmap").executes(this::openGuildMap))).then(Commands.literal((String)"help").executes(this::help))).then(Commands.literal((String)"map").executes(this::openMap))).then(Commands.literal((String)"menu").executes(this::openMenu))).then(Commands.literal((String)"reauth").executes(this::reauth))).then(Commands.literal((String)"reloadcaches").executes(this::reloadCaches))).then(Commands.literal((String)"rescan").executes(this::rescan))).then(Commands.literal((String)"status").executes(this::status))).then(Commands.literal((String)"token").executes(this::token))).then(Commands.literal((String)"update").executes(this::update))).then(Commands.literal((String)"version").executes(this::version))).executes(this::help);
    }

    private int profileReset(CommandContext<CommandSourceStack> context) {
        Handlers.Item.resetProfiling();
        Managers.Overlay.resetProfiling();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.wynntils.debug.profile.cleared").withStyle(ChatFormatting.GREEN), false);
        return 1;
    }

    private int profileShowAnnotations(CommandContext<CommandSourceStack> context) {
        Map<Class<?>, Integer> profilingTimes = Handlers.Item.getProfilingTimes();
        Map<Class<?>, Integer> profilingCounts = Handlers.Item.getProfilingCounts();
        this.showProfilingData(context, profilingTimes, profilingCounts);
        return 1;
    }

    private int profileShowOverlays(CommandContext<CommandSourceStack> context) {
        Map<Class<?>, Integer> profilingTimes = Managers.Overlay.getProfilingTimes();
        Map<Class<?>, Integer> profilingCounts = Managers.Overlay.getProfilingCounts();
        this.showProfilingData(context, profilingTimes, profilingCounts);
        return 1;
    }

    private void showProfilingData(CommandContext<CommandSourceStack> context, Map<Class<?>, Integer> profilingTimes, Map<Class<?>, Integer> profilingCounts) {
        StringBuilder resList = new StringBuilder();
        profilingTimes.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(10L).forEach(entry -> {
            int time = (Integer)entry.getValue();
            int count = (Integer)profilingCounts.get(entry.getKey());
            double average = (double)time / (double)count;
            resList.append("%7d ms, %7d c, avg: %7.2f ms/c  %s\n".formatted(time, count, average, ((Class)entry.getKey()).getSimpleName()));
        });
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)resList.toString()).withStyle(ChatFormatting.AQUA), false);
        int totalCount = profilingCounts.values().stream().reduce(0, Integer::sum);
        int totalTime = profilingTimes.values().stream().reduce(0, Integer::sum);
        double average = (double)totalTime / (double)totalCount;
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.wynntils.debug.profile.total", (Object[])new Object[]{totalTime, totalCount}).withStyle(ChatFormatting.AQUA), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.wynntils.debug.profile.avg", (Object[])new Object[]{average}).withStyle(ChatFormatting.AQUA), false);
    }

    private int reauth(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.wynntils.reauth.tryReauth").withStyle(ChatFormatting.GREEN), false);
        Services.Hades.tryDisconnect();
        Services.WynntilsAccount.reloadData();
        Models.Player.reset();
        return 1;
    }

    private int openGearSharingSettings(CommandContext<CommandSourceStack> commandSourceStackCommandContext) {
        Managers.TickScheduler.scheduleNextTick(() -> McUtils.mc().setScreen((Screen)GearSharingSettingsScreen.create(null)));
        return 1;
    }

    private int clearCaches(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.wynntils.clearCaches.warn").withStyle(ChatFormatting.DARK_RED), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.wynntils.clearCaches.clickHere").withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.UNDERLINE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/wynntils clearcaches run"))), false);
        return 1;
    }

    private int doClearCaches(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.wynntils.clearCaches.deleting").withStyle(ChatFormatting.YELLOW), false);
        Managers.TickScheduler.scheduleLater(() -> {
            FileUtils.deleteFolder(Managers.Net.getCacheDir());
            FileUtils.deleteFolder(Services.Update.getUpdatesFolder());
            System.exit(0);
        }, 100);
        return 1;
    }

    private int reloadCaches(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.wynntils.reloadCaches.reloading").withStyle(ChatFormatting.YELLOW), false);
        Managers.Url.loadUrls();
        return 1;
    }

    private int downloads(CommandContext<CommandSourceStack> context) {
        Managers.TickScheduler.scheduleNextTick(() -> McUtils.mc().setScreen(DownloadScreen.create(null, null)));
        return 1;
    }

    private int version(CommandContext<CommandSourceStack> context) {
        MutableComponent buildText = WynntilsMod.getVersion().isEmpty() ? Component.literal((String)"Unknown Version") : (WynntilsMod.isDevelopmentBuild() ? Component.literal((String)"Development Build") : Component.literal((String)("Version " + WynntilsMod.getVersion())));
        buildText.setStyle(buildText.getStyle().withColor(ChatFormatting.YELLOW));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> buildText, false);
        return 1;
    }

    private int status(CommandContext<CommandSourceStack> context) {
        MutableComponent component = Component.literal((String)"Reading status of Wynntils services from ").withStyle(ChatFormatting.WHITE);
        MutableComponent url = Component.literal((String)Managers.Url.getUrl(UrlId.LINK_WYNNTILS_STATUS)).withStyle(Style.EMPTY.withColor(ChatFormatting.LIGHT_PURPLE).withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, Managers.Url.getUrl(UrlId.LINK_WYNNTILS_STATUS))).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click here to open in your browser."))));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> component.append((Component)url), false);
        ApiResponse result = Managers.Net.callApi(UrlId.LINK_WYNNTILS_STATUS);
        result.handleInputStream(is -> {
            try (InputStreamReader isReader = new InputStreamReader((InputStream)is, StandardCharsets.UTF_8);
                 BufferedReader reader = new BufferedReader(isReader);){
                while (true) {
                    String line;
                    if ((line = reader.readLine()) != null) {
                        Matcher m = STATUS_HEADING.matcher(line);
                        if (!m.matches()) continue;
                        String status = m.group(1);
                        McUtils.sendMessageToClient((Component)Component.literal((String)"Wynntils status: ").withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)status).withStyle(ChatFormatting.AQUA)));
                        return;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                WynntilsMod.warn("Failed to read status page", e);
            }
            McUtils.sendErrorToClient("Failed to read status page");
        }, onError -> {
            WynntilsMod.warn("Failed to read status page", onError);
            McUtils.sendErrorToClient("Failed to read status page");
        });
        return 1;
    }

    private int donateLink(CommandContext<CommandSourceStack> context) {
        MutableComponent c = Component.literal((String)"You can donate to Wynntils at: ").withStyle(ChatFormatting.AQUA);
        MutableComponent url = Component.literal((String)Managers.Url.getUrl(UrlId.LINK_WYNNTILS_PATREON)).withStyle(Style.EMPTY.withColor(ChatFormatting.LIGHT_PURPLE).withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, Managers.Url.getUrl(UrlId.LINK_WYNNTILS_PATREON))).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click here to open in your browser."))));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> c.append((Component)url), false);
        return 1;
    }

    private int discordLink(CommandContext<CommandSourceStack> context) {
        MutableComponent msg = Component.literal((String)"You're welcome to join our Discord server at:\n").withStyle(ChatFormatting.GOLD);
        String discordInvite = Managers.Url.getUrl(UrlId.LINK_WYNNTILS_DISCORD_INVITE);
        MutableComponent link = Component.literal((String)discordInvite).withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_AQUA));
        link.setStyle(link.getStyle().withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, discordInvite)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click here to join our Discord server."))));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> msg.append((Component)link), false);
        return 1;
    }

    private int token(CommandContext<CommandSourceStack> context) {
        if (!Services.WynntilsAccount.isLoggedIn()) {
            MutableComponent failed = Component.literal((String)"Either setting up your Wynntils account or accessing the token failed. To try to set up the Wynntils account again, run ").withStyle(ChatFormatting.GREEN);
            failed.append((Component)Component.literal((String)"/wynntils reauth").withStyle(Style.EMPTY.withColor(ChatFormatting.AQUA).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/wynntils reauth"))));
            ((CommandSourceStack)context.getSource()).sendFailure((Component)failed);
            return 1;
        }
        String token = Services.WynntilsAccount.getToken();
        MutableComponent text = Component.literal((String)"Wynntils Token ").withStyle(ChatFormatting.AQUA);
        MutableComponent response = Component.literal((String)token).withStyle(Style.EMPTY.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click me to register an account."))).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, Managers.Url.buildUrl(UrlId.LINK_WYNNTILS_REGISTER_ACCOUNT, Map.of("token", token)))).withColor(ChatFormatting.DARK_AQUA).withUnderlined(Boolean.valueOf(true)));
        text.append((Component)response);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> text, false);
        return 1;
    }

    private int update(CommandContext<CommandSourceStack> context) {
        if (WynntilsMod.isDevelopmentEnvironment()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"feature.wynntils.updates.error.development").withStyle(ChatFormatting.DARK_RED));
            WynntilsMod.error("Development environment detected, cannot update!");
            return 0;
        }
        CompletableFuture.runAsync(() -> {
            WynntilsMod.info("Attempting to fetch Wynntils update.");
            CompletableFuture<UpdateResult> completableFuture = Services.Update.tryUpdate();
            completableFuture.whenComplete((result, throwable) -> McUtils.sendMessageToClient((Component)result.getMessage()));
        });
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"feature.wynntils.updates.checking").withStyle(ChatFormatting.GREEN), false);
        return 1;
    }

    private int openGuildMap(CommandContext<CommandSourceStack> context) {
        return this.openScreen(GuildMapScreen.create());
    }

    private int openMap(CommandContext<CommandSourceStack> context) {
        return this.openScreen(MainMapScreen.create());
    }

    private int openMenu(CommandContext<CommandSourceStack> context) {
        return this.openScreen(WynntilsMenuScreen.create());
    }

    private int openScreen(Screen screenToOpen) {
        Managers.TickScheduler.scheduleLater(() -> McUtils.mc().setScreen(screenToOpen), 2);
        return 1;
    }

    private int rescan(CommandContext<CommandSourceStack> context) {
        Models.Character.scanCharacterInfo();
        Models.Account.scanRankInfo(true);
        return 1;
    }

    private int help(CommandContext<CommandSourceStack> context) {
        MutableComponent text = Component.literal((String)"Available Wynntils commands: \n").withStyle(Style.EMPTY.withColor(ChatFormatting.GOLD));
        WynntilsCommand.describeWynntilsSubcommand(text, "clearcaches", "Clears all Wynntils caches and closes the game");
        WynntilsCommand.describeWynntilsSubcommand(text, "debug", "Debug command for developers.");
        WynntilsCommand.describeWynntilsSubcommand(text, "discord", "Provide an invite link to our Discord server");
        WynntilsCommand.describeWynntilsSubcommand(text, "donate", "Provides a link to our Patreon");
        WynntilsCommand.describeWynntilsSubcommand(text, "help", "List of all available commands for Wynntils");
        WynntilsCommand.describeWynntilsSubcommand(text, "menu", "Opens Wynntils Menu");
        WynntilsCommand.describeWynntilsSubcommand(text, "reauth", "Re-authorize Wynntils online services (Athena and Hades)");
        WynntilsCommand.describeWynntilsSubcommand(text, "reloadcaches", "Clear and re-download caches of online data");
        WynntilsCommand.describeWynntilsSubcommand(text, "status", "Show Wynntils server status");
        WynntilsCommand.describeWynntilsSubcommand(text, "token", "Provide a link for creating a Wynntils account");
        WynntilsCommand.describeWynntilsSubcommand(text, "update", "Update Wynntils to the latest version");
        WynntilsCommand.describeWynntilsSubcommand(text, "version", "Shows the version of Wynntils currently installed");
        List<Command> otherCommands = Managers.Command.getCommandInstanceSet().stream().filter(c -> !(c instanceof WynntilsCommand)).toList();
        for (Command command : otherCommands) {
            WynntilsCommand.describeCommand(text, command.getCommandName(), command.getDescription());
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> text, false);
        return 1;
    }

    private static void describeWynntilsSubcommand(MutableComponent text, String subcommand, String description) {
        WynntilsCommand.describeCommand(text, "wynntils " + subcommand, description);
    }

    private static void describeCommand(MutableComponent text, String command, String description) {
        MutableComponent clickComponent = Component.empty();
        clickComponent.setStyle(clickComponent.getStyle().withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/" + command)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click here to run this command"))));
        clickComponent.append((Component)Component.literal((String)("/" + command)).withStyle(ChatFormatting.GREEN));
        clickComponent.append((Component)Component.literal((String)" - ").withStyle(ChatFormatting.DARK_GRAY));
        clickComponent.append((Component)Component.literal((String)description).withStyle(ChatFormatting.GRAY));
        text.append("\n");
        text.append((Component)clickComponent);
    }
}

