/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.consumers.features;

import com.google.common.collect.ComparisonChain;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.features.AbstractConfigurable;
import com.wynntils.core.mod.type.CrashType;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.storage.Storageable;

public abstract class Feature
extends AbstractConfigurable
implements Storageable,
Comparable<Feature> {
    private Category category = Category.UNCATEGORIZED;
    @Persisted(i18nKey="feature.wynntils.userFeature.userEnabled")
    public final Config<Boolean> userEnabled = new Config<Boolean>(true);

    @Override
    public String getTypeName() {
        return "Feature";
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public String getTranslatedDescription() {
        return this.getTranslation("description", new Object[0]);
    }

    public String getShortName() {
        return this.getClass().getSimpleName().replace("Feature", "");
    }

    @Override
    public String getStorageJsonName() {
        return "feature." + this.getTranslationKeyName();
    }

    protected void onConfigUpdate(Config<?> config) {
    }

    private void callOnConfigUpdate(Config<?> config) {
        try {
            this.onConfigUpdate(config);
        }
        catch (Throwable t) {
            if (!Managers.Feature.isEnabled(this)) {
                return;
            }
            Managers.Feature.crashFeature(this);
            WynntilsMod.reportCrash(CrashType.FEATURE, this.getTranslatedName(), this.getClass().getName(), "config update", t);
        }
    }

    public void onEnable() {
    }

    public void onDisable() {
    }

    public final boolean isEnabled() {
        return Managers.Feature.isEnabled(this);
    }

    public void setUserEnabled(boolean newState) {
        this.userEnabled.store(newState);
        this.tryUserToggle();
    }

    @Override
    public final void updateConfigOption(Config<?> config) {
        if (config.getFieldName().equals("userEnabled")) {
            this.tryUserToggle();
            return;
        }
        this.callOnConfigUpdate(config);
    }

    private void tryUserToggle() {
        if (((Boolean)this.userEnabled.get()).booleanValue()) {
            Managers.Feature.enableFeature(this);
        } else {
            Managers.Feature.disableFeature(this, false);
        }
    }

    @Override
    public int compareTo(Feature other) {
        return ComparisonChain.start().compare((Comparable)((Object)this.getCategory().toString()), (Comparable)((Object)other.getCategory().toString())).compare((Comparable)((Object)this.getTranslatedName()), (Comparable)((Object)other.getTranslatedName())).result();
    }
}

