/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.consumers.functions;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Manager;
import com.wynntils.core.consumers.functions.Function;
import com.wynntils.core.consumers.functions.arguments.Argument;
import com.wynntils.core.consumers.functions.arguments.FunctionArguments;
import com.wynntils.core.consumers.functions.arguments.parser.ArgumentParser;
import com.wynntils.core.consumers.functions.expressions.Expression;
import com.wynntils.core.consumers.functions.expressions.parser.ExpressionParser;
import com.wynntils.core.consumers.functions.templates.Template;
import com.wynntils.core.consumers.functions.templates.parser.TemplateParser;
import com.wynntils.core.mod.type.CrashType;
import com.wynntils.core.text.StyledText;
import com.wynntils.functions.ActivityFunctions;
import com.wynntils.functions.BombFunctions;
import com.wynntils.functions.CharacterFunctions;
import com.wynntils.functions.CombatFunctions;
import com.wynntils.functions.CombatXpFunctions;
import com.wynntils.functions.EnvironmentFunctions;
import com.wynntils.functions.GuildFunctions;
import com.wynntils.functions.HadesPartyFunctions;
import com.wynntils.functions.HorseFunctions;
import com.wynntils.functions.InventoryFunctions;
import com.wynntils.functions.LootrunFunctions;
import com.wynntils.functions.MinecraftFunctions;
import com.wynntils.functions.ProfessionFunctions;
import com.wynntils.functions.RaidFunctions;
import com.wynntils.functions.SocialFunctions;
import com.wynntils.functions.SpellFunctions;
import com.wynntils.functions.StatisticFunctions;
import com.wynntils.functions.StatusEffectFunctions;
import com.wynntils.functions.WarFunctions;
import com.wynntils.functions.WorldEventFunctions;
import com.wynntils.functions.WorldFunctions;
import com.wynntils.functions.WynnAlphabetFunctions;
import com.wynntils.functions.WynnFontFunctions;
import com.wynntils.functions.generic.CappedFunctions;
import com.wynntils.functions.generic.ColorFunctions;
import com.wynntils.functions.generic.ConditionalFunctions;
import com.wynntils.functions.generic.LocationFunctions;
import com.wynntils.functions.generic.LogicFunctions;
import com.wynntils.functions.generic.MathFunctions;
import com.wynntils.functions.generic.NamedFunctions;
import com.wynntils.functions.generic.RangedFunctions;
import com.wynntils.functions.generic.StringFunctions;
import com.wynntils.functions.generic.TimeFunctions;
import com.wynntils.models.emeralds.type.EmeraldUnits;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.type.ErrorOr;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public final class FunctionManager
extends Manager {
    private static final Pattern HEX_COLOR_PATTERN = Pattern.compile("&(?<!\\\\)(#[0-9A-Fa-f]{8})");
    private static final Pattern FORMATTING_CODE_PATTERN = Pattern.compile("&(?<!\\\\)([0-9a-fA-Fk-oK-OrR])");
    private static final Pattern NBSP_PATTERN = Pattern.compile("\u00a0");
    private final List<Function<?>> functions = new ArrayList();
    private final Set<Function<?>> crashedFunctions = new HashSet();
    private final Map<String, Template> calculatedTemplateCache = new HashMap<String, Template>();

    public FunctionManager() {
        super(List.of());
    }

    public List<Function<?>> getFunctions() {
        return this.functions;
    }

    public void enableFunction(Function<?> function) {
        this.crashedFunctions.remove(function);
    }

    private void crashFunction(Function<?> function) {
        this.crashedFunctions.add(function);
    }

    public boolean isCrashed(Function<?> function) {
        return this.crashedFunctions.contains(function);
    }

    public Optional<Function<?>> forName(String functionName) {
        for (Function<?> function : this.getFunctions()) {
            if (!this.hasName(function, functionName)) continue;
            return Optional.of(function);
        }
        return Optional.empty();
    }

    private boolean hasName(Function<?> function, String name) {
        if (function.getName().equalsIgnoreCase(name)) {
            return true;
        }
        for (String alias : function.getAliasList()) {
            if (!alias.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private Optional<Object> getFunctionValueSafely(Function<?> function, FunctionArguments arguments) {
        if (this.crashedFunctions.contains(function)) {
            return Optional.empty();
        }
        try {
            Object value = function.getValue(arguments);
            return Optional.ofNullable(value);
        }
        catch (Throwable throwable) {
            this.crashFunction(function);
            WynntilsMod.reportCrash(CrashType.FUNCTION, function.getTranslatedName(), function.getClass().getName(), "calculation", throwable);
            return Optional.empty();
        }
    }

    public Component getSimpleValueString(Function<?> function, String rawArguments, ChatFormatting color, boolean includeName) {
        MutableComponent header = includeName ? Component.literal((String)(function.getTranslatedName() + ": ")).withStyle(ChatFormatting.WHITE) : Component.literal((String)"");
        ErrorOr<List<Expression>> errorOrArgumentExpressions = ArgumentParser.parseArguments(function.getArgumentsBuilder(), rawArguments);
        if (errorOrArgumentExpressions.hasError()) {
            return header.append((Component)Component.literal((String)errorOrArgumentExpressions.getError()).withStyle(ChatFormatting.RED));
        }
        List<ErrorOr> errorsOrargumentObjects = errorOrArgumentExpressions.getValue().stream().map(Expression::calculate).toList();
        Optional<ErrorOr> argumentError = errorsOrargumentObjects.stream().filter(ErrorOr::hasError).findFirst();
        if (argumentError.isPresent()) {
            return header.append((Component)Component.literal((String)argumentError.get().getError()).withStyle(ChatFormatting.RED));
        }
        ErrorOr<FunctionArguments> errorOrArgument = function.getArgumentsBuilder().buildWithValues(errorsOrargumentObjects.stream().map(ErrorOr::getValue).toList());
        if (errorOrArgument.hasError()) {
            return header.append((Component)Component.literal((String)errorOrArgument.getError()).withStyle(ChatFormatting.RED));
        }
        Optional<Object> value = this.getFunctionValueSafely(function, errorOrArgument.getValue());
        if (value.isEmpty()) {
            return header.append((Component)Component.literal((String)"??"));
        }
        String formattedValue = this.format(value.get(), false, 2);
        return header.append((Component)Component.literal((String)formattedValue).withStyle(color));
    }

    public String getStringFunctionValue(Function<?> function, FunctionArguments arguments, boolean formatted, int decimals) {
        Optional<Object> value = this.getFunctionValueSafely(function, arguments);
        if (value.isEmpty()) {
            return "??";
        }
        return this.format(value.get(), formatted, decimals);
    }

    private String format(Object value, boolean formatted, int decimals) {
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            if (!formatted) {
                return String.valueOf(integer);
            }
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            if (formatted) {
                NumberFormat instance = NumberFormat.getInstance();
                instance.setMinimumFractionDigits(decimals);
                instance.setMaximumFractionDigits(decimals);
                return NBSP_PATTERN.matcher(instance.format(number)).replaceAll(" ");
            }
            if (decimals == 0) {
                return String.valueOf(number.intValue());
            }
            DecimalFormat decimalFormat = new DecimalFormat("0." + "0".repeat(decimals));
            return decimalFormat.format(number);
        }
        if (value instanceof CustomColor) {
            CustomColor color = (CustomColor)value;
            return "\u00a7" + color.toHexString();
        }
        return value.toString();
    }

    public ErrorOr<Object> getRawFunctionValue(Function<?> function, FunctionArguments arguments) {
        Optional<Object> value = this.getFunctionValueSafely(function, arguments);
        return value.map(ErrorOr::of).orElseGet(() -> ErrorOr.error("Failed to get value of function: " + function.getName()));
    }

    public <T> ErrorOr<T> tryGetRawValueOfType(String valueTemplate, Class<T> clazz) {
        ErrorOr<Expression> valueExpression = ExpressionParser.tryParse(valueTemplate);
        if (valueExpression.hasError()) {
            return ErrorOr.error(valueExpression.getError());
        }
        Expression expression = valueExpression.getValue();
        ErrorOr<Object> calculatedExpression = expression.calculate();
        if (calculatedExpression.hasError()) {
            return ErrorOr.error(calculatedExpression.getError());
        }
        try {
            return ErrorOr.of(clazz.cast(calculatedExpression.getValue()));
        }
        catch (Exception e) {
            return ErrorOr.error("The provided expression does not return a " + clazz.getSimpleName());
        }
    }

    private String doFormat(String templateString) {
        this.calculatedTemplateCache.computeIfAbsent(templateString, TemplateParser::getTemplateFromString);
        return this.calculatedTemplateCache.get(templateString).getString();
    }

    public StyledText[] doFormatLines(String templateString) {
        StringBuilder resultBuilder = new StringBuilder();
        for (int i = 0; i < templateString.length(); ++i) {
            char c = templateString.charAt(i);
            if (c == '\\' && i + 1 < templateString.length()) {
                char nextChar = templateString.charAt(i + 1);
                resultBuilder.append(this.doEscapeFormat(nextChar));
                ++i;
                continue;
            }
            resultBuilder.append(c);
        }
        String escapedTemplate = this.parseColorCodes(resultBuilder.toString());
        String calculatedString = this.doFormat(escapedTemplate);
        calculatedString = calculatedString.replace("\\[\\", "{");
        calculatedString = calculatedString.replace("\\]\\", "}");
        calculatedString = calculatedString.replace("\\&\\", "&");
        return (StyledText[])Arrays.stream(calculatedString.split("\n")).map(StyledText::fromString).toArray(StyledText[]::new);
    }

    private String parseColorCodes(String toProcess) {
        String processed = FORMATTING_CODE_PATTERN.matcher(toProcess).replaceAll("\u00a7$1");
        processed = HEX_COLOR_PATTERN.matcher(processed).replaceAll("\u00a7$1");
        return processed;
    }

    private String doEscapeFormat(char escaped) {
        return switch (escaped) {
            case '\\' -> "\\\\";
            case 'n' -> "\n";
            case '{' -> "\\[\\";
            case '}' -> "\\]\\";
            case 'E' -> EmeraldUnits.EMERALD.getSymbol();
            case 'B' -> EmeraldUnits.EMERALD_BLOCK.getSymbol();
            case 'L' -> EmeraldUnits.LIQUID_EMERALD.getSymbol();
            case 'M' -> "\u273a";
            case 'H' -> "\u2764";
            case '&' -> "\\&\\";
            default -> "\\" + String.valueOf(escaped);
        };
    }

    public void init() {
        block2: {
            try {
                this.registerAllFunctions();
            }
            catch (AssertionError ae) {
                WynntilsMod.error("Fix i18n for functions", (Throwable)((Object)ae));
                if (!WynntilsMod.isDevelopmentEnvironment()) break block2;
                System.exit(1);
            }
        }
    }

    private void registerFunction(Function<?> function) {
        this.functions.add(function);
        assert (!function.getTranslatedName().startsWith("function.wynntils.")) : "Fix i18n name for " + function.getTranslatedName();
        assert (!function.getDescription().startsWith("function.wynntils.")) : "Fix i18n description for " + function.getDescription();
        for (Argument<?> argument : function.getArgumentsBuilder().getArguments()) {
            assert (!function.getArgumentDescription(argument.getName()).startsWith("function.wynntils.")) : "Fix i18n argument description for " + function.getArgumentDescription(argument.getName());
        }
    }

    private void registerAllFunctions() {
        this.registerFunction(new CappedFunctions.AtCapFunction());
        this.registerFunction(new CappedFunctions.CapFunction());
        this.registerFunction(new CappedFunctions.CappedFunction());
        this.registerFunction(new CappedFunctions.CurrentFunction());
        this.registerFunction(new CappedFunctions.PercentageFunction());
        this.registerFunction(new CappedFunctions.RemainingFunction());
        this.registerFunction(new ColorFunctions.BlinkShaderFunction());
        this.registerFunction(new ColorFunctions.BrightnessShiftFunction());
        this.registerFunction(new ColorFunctions.FadeShaderFunction());
        this.registerFunction(new ColorFunctions.FromHexFunction());
        this.registerFunction(new ColorFunctions.FromRgbFunction());
        this.registerFunction(new ColorFunctions.FromRgbPercentFunction());
        this.registerFunction(new ColorFunctions.GradientShaderFunction());
        this.registerFunction(new ColorFunctions.HueShiftFunction());
        this.registerFunction(new ColorFunctions.RainbowShaderFunction());
        this.registerFunction(new ColorFunctions.SaturationShiftFunction());
        this.registerFunction(new ColorFunctions.ShineShaderFunction());
        this.registerFunction(new ColorFunctions.ToHexStringFunction());
        this.registerFunction(new ConditionalFunctions.IfCappedValueFunction());
        this.registerFunction(new ConditionalFunctions.IfCustomColorFunction());
        this.registerFunction(new ConditionalFunctions.IfFunction());
        this.registerFunction(new ConditionalFunctions.IfNumberFunction());
        this.registerFunction(new ConditionalFunctions.IfStringFunction());
        this.registerFunction(new LocationFunctions.DistanceFunction());
        this.registerFunction(new LocationFunctions.LocationFunction());
        this.registerFunction(new LocationFunctions.XFunction());
        this.registerFunction(new LocationFunctions.YFunction());
        this.registerFunction(new LocationFunctions.ZFunction());
        this.registerFunction(new LogicFunctions.AndFunction());
        this.registerFunction(new LogicFunctions.EqualsFunction());
        this.registerFunction(new LogicFunctions.GreaterThanFunction());
        this.registerFunction(new LogicFunctions.GreaterThanOrEqualsFunction());
        this.registerFunction(new LogicFunctions.LessThanFunction());
        this.registerFunction(new LogicFunctions.LessThanOrEqualsFunction());
        this.registerFunction(new LogicFunctions.NotEqualsFunction());
        this.registerFunction(new LogicFunctions.NotFunction());
        this.registerFunction(new LogicFunctions.OrFunction());
        this.registerFunction(new MathFunctions.AddFunction());
        this.registerFunction(new MathFunctions.DivideFunction());
        this.registerFunction(new MathFunctions.IntegerFunction());
        this.registerFunction(new MathFunctions.LongFunction());
        this.registerFunction(new MathFunctions.MaxFunction());
        this.registerFunction(new MathFunctions.MinFunction());
        this.registerFunction(new MathFunctions.ModuloFunction());
        this.registerFunction(new MathFunctions.MultiplyFunction());
        this.registerFunction(new MathFunctions.PowerFunction());
        this.registerFunction(new MathFunctions.RandomFunction());
        this.registerFunction(new MathFunctions.RoundFunction());
        this.registerFunction(new MathFunctions.SquareRootFunction());
        this.registerFunction(new MathFunctions.SubtractFunction());
        this.registerFunction(new NamedFunctions.NameFunction());
        this.registerFunction(new NamedFunctions.NamedValueFunction());
        this.registerFunction(new NamedFunctions.ValueFunction());
        this.registerFunction(new StringFunctions.CappedStringFunction());
        this.registerFunction(new StringFunctions.ConcatFunction());
        this.registerFunction(new StringFunctions.FormatCappedFunction());
        this.registerFunction(new StringFunctions.FormatDateFunction());
        this.registerFunction(new StringFunctions.FormatDurationFunction());
        this.registerFunction(new StringFunctions.FormatFunction());
        this.registerFunction(new StringFunctions.FormatRangedFunction());
        this.registerFunction(new StringFunctions.LeadingZerosFunction());
        this.registerFunction(new StringFunctions.ParseDoubleFunction());
        this.registerFunction(new StringFunctions.ParseIntegerFunction());
        this.registerFunction(new StringFunctions.RegexFindFunction());
        this.registerFunction(new StringFunctions.RegexMatchFunction());
        this.registerFunction(new StringFunctions.RegexReplaceFunction());
        this.registerFunction(new StringFunctions.RepeatFunction());
        this.registerFunction(new StringFunctions.StringContainsFunction());
        this.registerFunction(new StringFunctions.StringEqualsFunction());
        this.registerFunction(new StringFunctions.StringFunction());
        this.registerFunction(new StringFunctions.ToRomanNumeralsFunction());
        this.registerFunction(new TimeFunctions.AbsoluteTimeFunction());
        this.registerFunction(new TimeFunctions.FormatTimeAdvancedFunction());
        this.registerFunction(new TimeFunctions.SecondsBetweenFunction());
        this.registerFunction(new TimeFunctions.SecondsSinceFunction());
        this.registerFunction(new TimeFunctions.TimeFunction());
        this.registerFunction(new TimeFunctions.TimeOffsetFunction());
        this.registerFunction(new TimeFunctions.TimeStringFunction());
        this.registerFunction(new TimeFunctions.TimestampFunction());
        this.registerFunction(new ActivityFunctions.ActivityColorFunction());
        this.registerFunction(new ActivityFunctions.ActivityNameFunction());
        this.registerFunction(new ActivityFunctions.ActivityTaskFunction());
        this.registerFunction(new ActivityFunctions.ActivityTypeFunction());
        this.registerFunction(new ActivityFunctions.IsTrackingActivityFunction());
        this.registerFunction(new BombFunctions.BombEndTimeFunction());
        this.registerFunction(new BombFunctions.BombFormattedStringFunction());
        this.registerFunction(new BombFunctions.BombLengthFunction());
        this.registerFunction(new BombFunctions.BombOwnerFunction());
        this.registerFunction(new BombFunctions.BombRemainingTimeFunction());
        this.registerFunction(new BombFunctions.BombStartTimeFunction());
        this.registerFunction(new BombFunctions.BombTypeFunction());
        this.registerFunction(new BombFunctions.BombWorldFunction());
        this.registerFunction(new CharacterFunctions.AspectTierFunction());
        this.registerFunction(new CharacterFunctions.BpsFunction());
        this.registerFunction(new CharacterFunctions.BpsXzFunction());
        this.registerFunction(new CharacterFunctions.CappedAwakenedProgressFunction());
        this.registerFunction(new CharacterFunctions.CappedBloodPoolFunction());
        this.registerFunction(new CharacterFunctions.CappedCorruptedFunction());
        this.registerFunction(new CharacterFunctions.CappedFocusFunction());
        this.registerFunction(new CharacterFunctions.CappedHealthFunction());
        this.registerFunction(new CharacterFunctions.CappedHolyPowerFunction());
        this.registerFunction(new CharacterFunctions.CappedManaBankFunction());
        this.registerFunction(new CharacterFunctions.CappedManaFunction());
        this.registerFunction(new CharacterFunctions.CappedOphanimFunction());
        this.registerFunction(new CharacterFunctions.ClassFunction());
        this.registerFunction(new CharacterFunctions.CommanderActivatedFunction());
        this.registerFunction(new CharacterFunctions.CommanderDurationFunction());
        this.registerFunction(new CharacterFunctions.EquippedAspectFunction());
        this.registerFunction(new CharacterFunctions.GuildObjectiveGoalFunction());
        this.registerFunction(new CharacterFunctions.GuildObjectiveScoreFunction());
        this.registerFunction(new CharacterFunctions.HasNoGuiFunction());
        this.registerFunction(new CharacterFunctions.HealthFunction());
        this.registerFunction(new CharacterFunctions.HealthMaxFunction());
        this.registerFunction(new CharacterFunctions.HealthPctFunction());
        this.registerFunction(new CharacterFunctions.HummingbirdsStateFunction());
        this.registerFunction(new CharacterFunctions.IdFunction());
        this.registerFunction(new CharacterFunctions.IsAspectEquippedFunction());
        this.registerFunction(new CharacterFunctions.IsRidingHorseFunction());
        this.registerFunction(new CharacterFunctions.ManaFunction());
        this.registerFunction(new CharacterFunctions.ManaMaxFunction());
        this.registerFunction(new CharacterFunctions.ManaPctFunction());
        this.registerFunction(new CharacterFunctions.OphanimActive());
        this.registerFunction(new CharacterFunctions.OphanimHealingPercentFunction());
        this.registerFunction(new CharacterFunctions.OphanimOrb());
        this.registerFunction(new CharacterFunctions.PersonalObjectiveGoalFunction());
        this.registerFunction(new CharacterFunctions.PersonalObjectiveScoreFunction());
        this.registerFunction(new CharacterFunctions.SprintFunction());
        this.registerFunction(new CombatFunctions.AreaDamageAverageFunction());
        this.registerFunction(new CombatFunctions.AreaDamagePerSecondFunction());
        this.registerFunction(new CombatFunctions.BlocksAboveGroundFunction());
        this.registerFunction(new CombatFunctions.FocusedMobHealthFunction());
        this.registerFunction(new CombatFunctions.FocusedMobHealthPercentFunction());
        this.registerFunction(new CombatFunctions.FocusedMobNameFunction());
        this.registerFunction(new CombatFunctions.KillsPerMinuteFunction());
        this.registerFunction(new CombatFunctions.LastDamageDealtFunction());
        this.registerFunction(new CombatFunctions.LastKillFunction());
        this.registerFunction(new CombatFunctions.LastSpellNameFunction());
        this.registerFunction(new CombatFunctions.LastSpellRepeatCountFunction());
        this.registerFunction(new CombatFunctions.TicksSinceLastSpellFunction());
        this.registerFunction(new CombatFunctions.TimeSinceLastDamageDealtFunction());
        this.registerFunction(new CombatFunctions.TimeSinceLastKillFunction());
        this.registerFunction(new CombatFunctions.TotalAreaDamageFunction());
        this.registerFunction(new CombatXpFunctions.CappedLevelFunction());
        this.registerFunction(new CombatXpFunctions.CappedXpFunction());
        this.registerFunction(new CombatXpFunctions.LevelFunction());
        this.registerFunction(new CombatXpFunctions.XpFunction());
        this.registerFunction(new CombatXpFunctions.XpPctFunction());
        this.registerFunction(new CombatXpFunctions.XpPerMinuteFunction());
        this.registerFunction(new CombatXpFunctions.XpPerMinuteRawFunction());
        this.registerFunction(new CombatXpFunctions.XpPercentagePerMinuteFunction());
        this.registerFunction(new CombatXpFunctions.XpRawFunction());
        this.registerFunction(new CombatXpFunctions.XpReqFunction());
        this.registerFunction(new CombatXpFunctions.XpReqRawFunction());
        this.registerFunction(new EnvironmentFunctions.CappedMemFunction());
        this.registerFunction(new EnvironmentFunctions.ClockFunction());
        this.registerFunction(new EnvironmentFunctions.ClockmFunction());
        this.registerFunction(new EnvironmentFunctions.MemMaxFunction());
        this.registerFunction(new EnvironmentFunctions.MemPctFunction());
        this.registerFunction(new EnvironmentFunctions.MemUsedFunction());
        this.registerFunction(new EnvironmentFunctions.MinecraftVersionFunction());
        this.registerFunction(new EnvironmentFunctions.NowFunction());
        this.registerFunction(new EnvironmentFunctions.StopwatchHoursFunction());
        this.registerFunction(new EnvironmentFunctions.StopwatchMillisecondsFunction());
        this.registerFunction(new EnvironmentFunctions.StopwatchMinutesFunction());
        this.registerFunction(new EnvironmentFunctions.StopwatchRunningFunction());
        this.registerFunction(new EnvironmentFunctions.StopwatchSecondsFunction());
        this.registerFunction(new EnvironmentFunctions.StopwatchZero());
        this.registerFunction(new EnvironmentFunctions.WynncraftVersionFunction());
        this.registerFunction(new EnvironmentFunctions.WynntilsVersionFunction());
        this.registerFunction(new GuildFunctions.CappedGuildLevelProgressFunction());
        this.registerFunction(new GuildFunctions.CappedGuildObjectivesProgressFunction());
        this.registerFunction(new GuildFunctions.GuildLevelFunction());
        this.registerFunction(new GuildFunctions.GuildNameFunction());
        this.registerFunction(new GuildFunctions.GuildRankFunction());
        this.registerFunction(new GuildFunctions.IsAlliedGuildFunction());
        this.registerFunction(new GuildFunctions.IsGuildMemberFunction());
        this.registerFunction(new GuildFunctions.ObjectiveStreakFunction());
        this.registerFunction(new HadesPartyFunctions.HadesPartyMemberHealthFunction());
        this.registerFunction(new HadesPartyFunctions.HadesPartyMemberLocationFunction());
        this.registerFunction(new HadesPartyFunctions.HadesPartyMemberManaFunction());
        this.registerFunction(new HadesPartyFunctions.HadesPartyMemberNameFunction());
        this.registerFunction(new HorseFunctions.CappedHorseLevelFunction());
        this.registerFunction(new HorseFunctions.CappedHorseTotalLevelTimeFunction());
        this.registerFunction(new HorseFunctions.CappedHorseXpFunction());
        this.registerFunction(new HorseFunctions.HorseLevelFunction());
        this.registerFunction(new HorseFunctions.HorseLevelMaxFunction());
        this.registerFunction(new HorseFunctions.HorseLevelTimeFunction());
        this.registerFunction(new HorseFunctions.HorseNameFunction());
        this.registerFunction(new HorseFunctions.HorseTierFunction());
        this.registerFunction(new HorseFunctions.HorseXpFunction());
        this.registerFunction(new InventoryFunctions.AccessoryDurabilityFunction());
        this.registerFunction(new InventoryFunctions.AllShinyStatsFunction());
        this.registerFunction(new InventoryFunctions.ArmorDurabilityFunction());
        this.registerFunction(new InventoryFunctions.CappedHeldItemDurabilityFunction());
        this.registerFunction(new InventoryFunctions.CappedIngredientPouchSlotsFunction());
        this.registerFunction(new InventoryFunctions.CappedInventorySlotsFunction());
        this.registerFunction(new InventoryFunctions.EmeraldBlockFunction());
        this.registerFunction(new InventoryFunctions.EmeraldStringFunction());
        this.registerFunction(new InventoryFunctions.EmeraldsFunction());
        this.registerFunction(new InventoryFunctions.HeldItemCooldownFunction());
        this.registerFunction(new InventoryFunctions.HeldItemCurrentDurabilityFunction());
        this.registerFunction(new InventoryFunctions.HeldItemMaxDurabilityFunction());
        this.registerFunction(new InventoryFunctions.HeldItemNameFunction());
        this.registerFunction(new InventoryFunctions.HeldItemShinyStatFunction());
        this.registerFunction(new InventoryFunctions.HeldItemTypeFunction());
        this.registerFunction(new InventoryFunctions.IngredientPouchIngredientsFunction());
        this.registerFunction(new InventoryFunctions.IngredientPouchOpenSlotsFunction());
        this.registerFunction(new InventoryFunctions.IngredientPouchUsedSlotsFunction());
        this.registerFunction(new InventoryFunctions.InventoryFreeFunction());
        this.registerFunction(new InventoryFunctions.InventoryIngredientsFunction());
        this.registerFunction(new InventoryFunctions.InventoryUsedFunction());
        this.registerFunction(new InventoryFunctions.ItemCountFunction());
        this.registerFunction(new InventoryFunctions.LiquidEmeraldFunction());
        this.registerFunction(new InventoryFunctions.MaterialCountFunction());
        this.registerFunction(new InventoryFunctions.MoneyFunction());
        this.registerFunction(new LootrunFunctions.ChestOpenedFunction());
        this.registerFunction(new LootrunFunctions.ChestsOpenedThisSessionFunction());
        this.registerFunction(new LootrunFunctions.DryBoxesFunction());
        this.registerFunction(new LootrunFunctions.DryPullsFunction());
        this.registerFunction(new LootrunFunctions.DryStreakFunction());
        this.registerFunction(new LootrunFunctions.HighestDryStreakFunction());
        this.registerFunction(new LootrunFunctions.LastDryStreakFunction());
        this.registerFunction(new LootrunFunctions.LastMythicFunction());
        this.registerFunction(new LootrunFunctions.LootrunBeaconCountFunction());
        this.registerFunction(new LootrunFunctions.LootrunBeaconVibrantFunction());
        this.registerFunction(new LootrunFunctions.LootrunChallengesFunction());
        this.registerFunction(new LootrunFunctions.LootrunLastSelectedBeaconColorFunction());
        this.registerFunction(new LootrunFunctions.LootrunLastSelectedBeaconVibrantFunction());
        this.registerFunction(new LootrunFunctions.LootrunMissionFunction());
        this.registerFunction(new LootrunFunctions.LootrunNextOrangeExpireFunction());
        this.registerFunction(new LootrunFunctions.LootrunOrangeBeaconCountFunction());
        this.registerFunction(new LootrunFunctions.LootrunRainbowBeaconCountFunction());
        this.registerFunction(new LootrunFunctions.LootrunRedBeaconChallengeCountFunction());
        this.registerFunction(new LootrunFunctions.LootrunRerollsFunction());
        this.registerFunction(new LootrunFunctions.LootrunSacrificesFunction());
        this.registerFunction(new LootrunFunctions.LootrunStateFunction());
        this.registerFunction(new LootrunFunctions.LootrunTaskLocationFunction());
        this.registerFunction(new LootrunFunctions.LootrunTaskNameFunction());
        this.registerFunction(new LootrunFunctions.LootrunTaskTypeFunction());
        this.registerFunction(new LootrunFunctions.LootrunTimeFunction());
        this.registerFunction(new LootrunFunctions.LootrunTrialFunction());
        this.registerFunction(new MinecraftFunctions.DirFunction());
        this.registerFunction(new MinecraftFunctions.FpsFunction());
        this.registerFunction(new MinecraftFunctions.KeyPressedFunction());
        this.registerFunction(new MinecraftFunctions.MinecraftEffectDurationFunction());
        this.registerFunction(new MinecraftFunctions.MyLocationFunction());
        this.registerFunction(new MinecraftFunctions.TicksFunction());
        this.registerFunction(new ProfessionFunctions.LastHarvestMaterialLevelFunction());
        this.registerFunction(new ProfessionFunctions.LastHarvestMaterialNameFunction());
        this.registerFunction(new ProfessionFunctions.LastHarvestMaterialTierFunction());
        this.registerFunction(new ProfessionFunctions.LastHarvestMaterialTypeFunction());
        this.registerFunction(new ProfessionFunctions.LastHarvestResourceTypeFunction());
        this.registerFunction(new ProfessionFunctions.LastHarvestXpGainFunction());
        this.registerFunction(new ProfessionFunctions.LastProfessionXpGainFunction());
        this.registerFunction(new ProfessionFunctions.MaterialDryStreak());
        this.registerFunction(new ProfessionFunctions.ProfessionLevelFunction());
        this.registerFunction(new ProfessionFunctions.ProfessionPercentageFunction());
        this.registerFunction(new ProfessionFunctions.ProfessionXpFunction());
        this.registerFunction(new ProfessionFunctions.ProfessionXpPerMinuteFunction());
        this.registerFunction(new ProfessionFunctions.ProfessionXpPerMinuteRawFunction());
        this.registerFunction(new RaidFunctions.CurrentRaidBossCountFunction());
        this.registerFunction(new RaidFunctions.CurrentRaidChallengeCountFunction());
        this.registerFunction(new RaidFunctions.CurrentRaidDamageFunction());
        this.registerFunction(new RaidFunctions.CurrentRaidFunction());
        this.registerFunction(new RaidFunctions.CurrentRaidRoomDamageFunction());
        this.registerFunction(new RaidFunctions.CurrentRaidRoomNameFunction());
        this.registerFunction(new RaidFunctions.CurrentRaidRoomStartFunction());
        this.registerFunction(new RaidFunctions.CurrentRaidRoomTimeFunction());
        this.registerFunction(new RaidFunctions.CurrentRaidStartFunction());
        this.registerFunction(new RaidFunctions.CurrentRaidTimeFunction());
        this.registerFunction(new RaidFunctions.DryAspectsFunction());
        this.registerFunction(new RaidFunctions.DryRaidRewardPullsFunction());
        this.registerFunction(new RaidFunctions.DryRaidsAspectsFunction());
        this.registerFunction(new RaidFunctions.DryRaidsTomesFunction());
        this.registerFunction(new RaidFunctions.RaidChallengesFunction());
        this.registerFunction(new RaidFunctions.RaidHasRoomFunction());
        this.registerFunction(new RaidFunctions.RaidIntermissionTimeFunction());
        this.registerFunction(new RaidFunctions.RaidIsBossRoomFunction());
        this.registerFunction(new RaidFunctions.RaidPersonalBestTimeFunction());
        this.registerFunction(new RaidFunctions.RaidRoomDamageFunction());
        this.registerFunction(new RaidFunctions.RaidRoomNameFunction());
        this.registerFunction(new RaidFunctions.RaidRoomStartFunction());
        this.registerFunction(new RaidFunctions.RaidRoomTimeFunction());
        this.registerFunction(new RaidFunctions.RaidTimeRemainingFunction());
        this.registerFunction(new RaidFunctions.RaidsRunsSinceFunction());
        this.registerFunction(new RaidFunctions.SpecificRaidRunsSinceFunction());
        this.registerFunction(new RangedFunctions.RangeHighFunction());
        this.registerFunction(new RangedFunctions.RangeLowFunction());
        this.registerFunction(new RangedFunctions.RangedFunction());
        this.registerFunction(new SocialFunctions.FriendsFunction());
        this.registerFunction(new SocialFunctions.IsFriendFunction());
        this.registerFunction(new SocialFunctions.IsPartyMemberFunction());
        this.registerFunction(new SocialFunctions.PartyLeaderFunction());
        this.registerFunction(new SocialFunctions.PartyMembersFunction());
        this.registerFunction(new SocialFunctions.PlayerNameFunction());
        this.registerFunction(new SocialFunctions.WynntilsRoleFunction());
        this.registerFunction(new SpellFunctions.ArrowShieldCountFunction());
        this.registerFunction(new SpellFunctions.GuardianAngelsCountFunction());
        this.registerFunction(new SpellFunctions.MantleShieldCountFunction());
        this.registerFunction(new SpellFunctions.ShamanMaskFunction());
        this.registerFunction(new SpellFunctions.ShamanTotemDistanceFunction());
        this.registerFunction(new SpellFunctions.ShamanTotemLocationFunction());
        this.registerFunction(new SpellFunctions.ShamanTotemStateFunction());
        this.registerFunction(new SpellFunctions.ShamanTotemTimeLeftFunction());
        this.registerFunction(new SpellFunctions.ShieldTypeNameFunction());
        this.registerFunction(new StatisticFunctions.StatisticsAverageFunction());
        this.registerFunction(new StatisticFunctions.StatisticsCountFunction());
        this.registerFunction(new StatisticFunctions.StatisticsFirstModifiedFunction());
        this.registerFunction(new StatisticFunctions.StatisticsFirstModifiedTimeFunction());
        this.registerFunction(new StatisticFunctions.StatisticsFormattedFunction());
        this.registerFunction(new StatisticFunctions.StatisticsLastModifiedFunction());
        this.registerFunction(new StatisticFunctions.StatisticsLastModifiedTimeFunction());
        this.registerFunction(new StatisticFunctions.StatisticsMaxFunction());
        this.registerFunction(new StatisticFunctions.StatisticsMinFunction());
        this.registerFunction(new StatisticFunctions.StatisticsTotalFunction());
        this.registerFunction(new StatusEffectFunctions.StatusEffectActiveFunction());
        this.registerFunction(new StatusEffectFunctions.StatusEffectDurationFunction());
        this.registerFunction(new StatusEffectFunctions.StatusEffectModifierFunction());
        this.registerFunction(new StatusEffectFunctions.StatusEffectPrefixFunction());
        this.registerFunction(new StatusEffectFunctions.StatusEffectsFunction());
        this.registerFunction(new WarFunctions.AuraTimerFunction());
        this.registerFunction(new WarFunctions.CurrentTowerAttackSpeedFunction());
        this.registerFunction(new WarFunctions.CurrentTowerDamageFunction());
        this.registerFunction(new WarFunctions.CurrentTowerDefenseFunction());
        this.registerFunction(new WarFunctions.CurrentTowerHealthFunction());
        this.registerFunction(new WarFunctions.EstimatedTimeToFinishWarFunction());
        this.registerFunction(new WarFunctions.EstimatedWarEndFunction());
        this.registerFunction(new WarFunctions.InitialTowerAttackSpeedFunction());
        this.registerFunction(new WarFunctions.InitialTowerDamageFunction());
        this.registerFunction(new WarFunctions.InitialTowerDefenseFunction());
        this.registerFunction(new WarFunctions.InitialTowerHealthFunction());
        this.registerFunction(new WarFunctions.IsTerritoryQueuedFunction());
        this.registerFunction(new WarFunctions.TeamDpsFunction());
        this.registerFunction(new WarFunctions.TimeInWarFunction());
        this.registerFunction(new WarFunctions.TowerDpsFunction());
        this.registerFunction(new WarFunctions.TowerEffectiveHpFunction());
        this.registerFunction(new WarFunctions.TowerOwnerFunction());
        this.registerFunction(new WarFunctions.TowerTerritoryFunction());
        this.registerFunction(new WarFunctions.VolleyTimerFunction());
        this.registerFunction(new WarFunctions.WarStartFunction());
        this.registerFunction(new WarFunctions.WarsSinceFunction());
        this.registerFunction(new WorldEventFunctions.AnnihilationDryCount());
        this.registerFunction(new WorldEventFunctions.AnnihilationSunProgressFunction());
        this.registerFunction(new WorldEventFunctions.CurrentWorldEventFunction());
        this.registerFunction(new WorldEventFunctions.CurrentWorldEventStartTimeFunction());
        this.registerFunction(new WorldEventFunctions.WorldEventStartTimeFunction());
        this.registerFunction(new WorldFunctions.CurrentTerritoryFunction());
        this.registerFunction(new WorldFunctions.CurrentTerritoryOwnerFunction());
        this.registerFunction(new WorldFunctions.CurrentWorldFunction());
        this.registerFunction(new WorldFunctions.GatheringTotemCountFunction());
        this.registerFunction(new WorldFunctions.GatheringTotemDistanceFunction());
        this.registerFunction(new WorldFunctions.GatheringTotemFunction());
        this.registerFunction(new WorldFunctions.GatheringTotemOwnerFunction());
        this.registerFunction(new WorldFunctions.GatheringTotemTimeLeftFunction());
        this.registerFunction(new WorldFunctions.InMappedAreaFunction());
        this.registerFunction(new WorldFunctions.InStreamFunction());
        this.registerFunction(new WorldFunctions.MobTotemCountFunction());
        this.registerFunction(new WorldFunctions.MobTotemDistanceFunction());
        this.registerFunction(new WorldFunctions.MobTotemFunction());
        this.registerFunction(new WorldFunctions.MobTotemOwnerFunction());
        this.registerFunction(new WorldFunctions.MobTotemTimeLeftFunction());
        this.registerFunction(new WorldFunctions.NewestWorldFunction());
        this.registerFunction(new WorldFunctions.PingFunction());
        this.registerFunction(new WorldFunctions.TokenGatekeeperCountFunction());
        this.registerFunction(new WorldFunctions.TokenGatekeeperDepositedFunction());
        this.registerFunction(new WorldFunctions.TokenGatekeeperFunction());
        this.registerFunction(new WorldFunctions.TokenGatekeeperTypeFunction());
        this.registerFunction(new WorldFunctions.WorldStateFunction());
        this.registerFunction(new WorldFunctions.WorldUptimeFunction());
        this.registerFunction(new WynnAlphabetFunctions.TranscribeGavellianFunction());
        this.registerFunction(new WynnAlphabetFunctions.TranscribeWynnicFunction());
        this.registerFunction(new WynnFontFunctions.ToBackgroundTextFunction());
        this.registerFunction(new WynnFontFunctions.ToFancyTextFunction());
    }
}

